/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.internal.base.HelpBaseResources;
import org.eclipse.help.search.ISearchEngine;
import org.eclipse.help.search.ISearchEngineResult;
import org.eclipse.help.search.ISearchEngineResultCollector;
import org.eclipse.help.search.ISearchScope;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class InfoCenter
implements ISearchEngine {
    private Hashtable tocs = new Hashtable();

    public void run(String query, ISearchScope scope, ISearchEngineResultCollector collector, IProgressMonitor monitor) throws CoreException {
        block17: {
            InputStream is;
            block16: {
                URL url = this.createURL(query, (Scope)scope);
                if (url == null) {
                    return;
                }
                is = null;
                this.tocs.clear();
                try {
                    try {
                        URLConnection connection = url.openConnection();
                        monitor.beginTask(HelpBaseResources.InfoCenter_connecting, 5);
                        is = connection.getInputStream();
                        BufferedReader reader = new BufferedReader(new InputStreamReader(is, "utf-8"));
                        monitor.worked(1);
                        this.load(((Scope)scope).url, reader, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                        reader.close();
                    }
                    catch (FileNotFoundException e) {
                        this.reportError(HelpBaseResources.InfoCenter_fileNotFound, e, collector);
                        break block16;
                    }
                    catch (IOException e) {
                        this.reportError(HelpBaseResources.InfoCenter_io, e, collector);
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                break block17;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void reportError(String message, IOException e, ISearchEngineResultCollector collector) {
        Status status = new Status(4, "org.eclipse.help.base", 0, message, (Throwable)e);
        collector.error((IStatus)status);
    }

    private void load(String baseURL, Reader r, ISearchEngineResultCollector collector, IProgressMonitor monitor) {
        Document document = null;
        try {
            DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            if (monitor.isCanceled()) {
                return;
            }
            monitor.beginTask("", 5);
            monitor.subTask(HelpBaseResources.InfoCenter_searching);
            document = parser.parse(new InputSource(r));
            if (monitor.isCanceled()) {
                return;
            }
            Node root = document.getFirstChild();
            while (root.getNodeType() == 8) {
                document.removeChild(root);
                root = document.getFirstChild();
                if (!monitor.isCanceled()) continue;
                return;
            }
            monitor.worked(1);
            this.load(baseURL, document, (Element)root, collector, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {}
    }

    private void load(String baseURL, Document doc, Element root, ISearchEngineResultCollector collector, IProgressMonitor monitor) {
        NodeList topics = root.getElementsByTagName("topic");
        ISearchEngineResult[] results = new ISearchEngineResult[topics.getLength()];
        monitor.subTask(HelpBaseResources.InfoCenter_processing);
        monitor.beginTask("", results.length);
        int i = 0;
        while (i < topics.getLength()) {
            Element el = (Element)topics.item(i);
            if (monitor.isCanceled()) break;
            results[i] = new InfoCenterResult(baseURL, el);
            monitor.worked(1);
            ++i;
        }
        collector.accept(results);
    }

    private URL createURL(String query, Scope scope) {
        StringBuffer buf = new StringBuffer();
        buf.append(scope.url);
        if (!scope.url.endsWith("/")) {
            buf.append("/search?searchWord=");
        } else {
            buf.append("search?searchWord=");
        }
        try {
            buf.append(URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            buf.append(query);
        }
        buf.append("&locale=");
        buf.append(Platform.getNL());
        if (scope.searchSelected && scope.tocs != null) {
            buf.append("&scopedSearch=true");
            int i = 0;
            while (i < scope.tocs.length) {
                String toc;
                try {
                    toc = URLEncoder.encode(scope.tocs[i], "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    toc = scope.tocs[i];
                }
                buf.append("&scope=");
                buf.append(toc);
                ++i;
            }
        }
        try {
            return new URL(buf.toString());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static class Scope
    implements ISearchScope {
        String url;
        boolean searchSelected;
        String[] tocs;

        public Scope(String url, boolean searchSelected, String[] tocs) {
            this.url = url;
            this.searchSelected = searchSelected;
            this.tocs = tocs;
        }
    }

    private class InfoCenterResult
    implements ISearchEngineResult {
        private IHelpResource category;
        private Element node;
        private String baseURL;

        public InfoCenterResult(String baseURL, Element node) {
            this.baseURL = baseURL;
            this.node = node;
            this.createCategory(node);
        }

        private void createCategory(Element node) {
            final String href = node.getAttribute("toc");
            final String label = node.getAttribute("toclabel");
            if (href != null && label != null) {
                this.category = (IHelpResource)InfoCenter.this.tocs.get(href);
                if (this.category == null) {
                    this.category = new IHelpResource(){

                        public String getLabel() {
                            return label;
                        }

                        public String getHref() {
                            return href;
                        }
                    };
                    InfoCenter.this.tocs.put(href, this.category);
                }
            }
        }

        public String getLabel() {
            return this.node.getAttribute("label");
        }

        public String getDescription() {
            return null;
        }

        public IHelpResource getCategory() {
            return this.category;
        }

        public String getHref() {
            return this.node.getAttribute("href");
        }

        public float getScore() {
            String value = this.node.getAttribute("score");
            if (value != null) {
                return Float.parseFloat(value);
            }
            return 0.0f;
        }

        public boolean getForceExternalWindow() {
            return false;
        }

        public String toAbsoluteHref(String href, boolean frames) {
            String url = this.baseURL;
            if (!url.endsWith("/")) {
                url = String.valueOf(url) + "/";
            }
            if (frames) {
                return String.valueOf(url) + "topic" + href;
            }
            return String.valueOf(url) + "topic" + href + "&noframes=true";
        }
    }
}

