/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.operations;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.operations.TimeTriggeredProgressMonitorDialog;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class OperationHistoryActionHandler
extends Action
implements ActionFactory.IWorkbenchAction,
IAdaptable {
    private static final int MAX_LABEL_LENGTH = 32;
    private boolean pruning = false;
    private IPartListener partListener = new PartListener();
    private IOperationHistoryListener historyListener = new HistoryListener();
    private TimeTriggeredProgressMonitorDialog progressDialog;
    IUndoContext undoContext = null;
    IWorkbenchPartSite site;

    OperationHistoryActionHandler(IWorkbenchPartSite site, IUndoContext context) {
        super("");
        this.site = site;
        this.undoContext = context;
        site.getPage().addPartListener(this.partListener);
        this.getHistory().addOperationHistoryListener(this.historyListener);
        this.update();
    }

    public void dispose() {
        IOperationHistory history = this.getHistory();
        if (history != null) {
            history.removeOperationHistoryListener(this.historyListener);
        }
        if (this.isInvalid()) {
            return;
        }
        this.site.getPage().removePartListener(this.partListener);
        this.site = null;
        this.progressDialog = null;
        this.undoContext = null;
    }

    abstract void flush();

    abstract String getCommandString();

    IOperationHistory getHistory() {
        if (PlatformUI.getWorkbench() == null) {
            return null;
        }
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    abstract IUndoableOperation getOperation();

    public final void run() {
        if (this.isInvalid()) {
            return;
        }
        Shell parent = this.getWorkbenchWindow().getShell();
        this.progressDialog = new TimeTriggeredProgressMonitorDialog(parent, this.getWorkbenchWindow().getWorkbench().getProgressService().getLongOperationTime());
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    OperationHistoryActionHandler.this.runCommand(pm);
                }
                catch (ExecutionException e) {
                    if (OperationHistoryActionHandler.this.pruning) {
                        OperationHistoryActionHandler.this.flush();
                    }
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            try {
                this.progressDialog.run(false, true, runnable);
            }
            catch (InvocationTargetException e) {
                this.reportException(e);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (OperationCanceledException operationCanceledException) {}
        }
        finally {
            this.progressDialog = null;
        }
    }

    abstract IStatus runCommand(IProgressMonitor var1) throws ExecutionException;

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IUndoContext.class)) {
            return this.undoContext;
        }
        if (adapter.equals(IProgressMonitor.class) && this.progressDialog != null) {
            return this.progressDialog.getProgressMonitor();
        }
        if (this.site != null) {
            if (adapter.equals(Shell.class)) {
                return this.getWorkbenchWindow().getShell();
            }
            if (adapter.equals(IWorkbenchWindow.class)) {
                return this.getWorkbenchWindow();
            }
            if (adapter.equals(IWorkbenchPart.class)) {
                return this.site.getPart();
            }
            IWorkbenchPart part = this.site.getPart();
            if (part != null) {
                return part.getAdapter(adapter);
            }
        }
        return null;
    }

    private IWorkbenchWindow getWorkbenchWindow() {
        if (this.site != null) {
            return this.site.getWorkbenchWindow();
        }
        return null;
    }

    abstract boolean shouldBeEnabled();

    public void setContext(IUndoContext context) {
        this.undoContext = context;
        this.update();
    }

    public void setPruneHistory(boolean prune) {
        this.pruning = prune;
    }

    public void update() {
        String tooltipText;
        if (this.isInvalid()) {
            return;
        }
        boolean enabled = this.shouldBeEnabled();
        String text = this.getCommandString();
        if (enabled) {
            tooltipText = NLS.bind((String)WorkbenchMessages.Operations_undoRedoCommand, (Object)text, (Object)this.getOperation().getLabel());
            text = NLS.bind((String)WorkbenchMessages.Operations_undoRedoCommand, (Object)text, (Object)this.shortenText(this.getOperation().getLabel()));
        } else {
            tooltipText = NLS.bind((String)WorkbenchMessages.Operations_undoRedoCommandDisabled, (Object)text);
            if (this.undoContext != null && this.pruning) {
                this.flush();
            }
        }
        this.setText(text);
        this.setToolTipText(tooltipText);
        this.setEnabled(enabled);
    }

    private String shortenText(String message) {
        int length = message.length();
        if (length > 32) {
            StringBuffer result = new StringBuffer();
            int mid = 16;
            result.append(message.substring(0, mid));
            result.append("...");
            result.append(message.substring(length - mid));
            return result.toString();
        }
        return message;
    }

    final void reportException(Exception e) {
        Throwable nestedException = StatusUtil.getCause(e);
        Throwable exception = nestedException == null ? e : nestedException;
        String title = WorkbenchMessages.Error;
        String message = WorkbenchMessages.WorkbenchWindow_exceptionMessage;
        String exceptionMessage = exception.getMessage();
        if (exceptionMessage == null) {
            exceptionMessage = message;
        }
        Status status = new Status(4, WorkbenchPlugin.PI_WORKBENCH, 0, exceptionMessage, exception);
        WorkbenchPlugin.log(message, (IStatus)status);
        ErrorDialog.openError((Shell)this.getWorkbenchWindow().getShell(), (String)title, (String)message, (IStatus)status);
    }

    final boolean isInvalid() {
        return this.undoContext == null || this.site == null;
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part.equals(OperationHistoryActionHandler.this.site.getPart())) {
                OperationHistoryActionHandler.this.dispose();
            } else if (OperationHistoryActionHandler.this.site instanceof MultiPageEditorSite && part.equals(((MultiPageEditorSite)OperationHistoryActionHandler.this.site).getMultiPageEditor())) {
                OperationHistoryActionHandler.this.dispose();
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class HistoryListener
    implements IOperationHistoryListener {
        private HistoryListener() {
        }

        public void historyNotification(final OperationHistoryEvent event) {
            Display display = OperationHistoryActionHandler.this.getWorkbenchWindow().getWorkbench().getDisplay();
            switch (event.getEventType()) {
                case 5: 
                case 8: 
                case 9: 
                case 10: {
                    if (display == null || !event.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(new Runnable(){

                        public void run() {
                            OperationHistoryActionHandler.this.update();
                        }
                    });
                    break;
                }
                case 7: {
                    if (display == null || !event.getOperation().hasContext(OperationHistoryActionHandler.this.undoContext)) break;
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (OperationHistoryActionHandler.this.pruning) {
                                IStatus status = event.getStatus();
                                if (status == null || status.getSeverity() != 8) {
                                    OperationHistoryActionHandler.this.flush();
                                }
                                OperationHistoryActionHandler.this.update();
                            } else {
                                OperationHistoryActionHandler.this.update();
                            }
                        }
                    });
                    break;
                }
                case 6: {
                    if (display == null || event.getOperation() != OperationHistoryActionHandler.this.getOperation()) break;
                    display.asyncExec(new Runnable(){

                        public void run() {
                            OperationHistoryActionHandler.this.update();
                        }
                    });
                }
            }
        }
    }
}

