/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Date;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.resources.ResourceStatus;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.utils.SVNStatusUtils;

public class LocalResourceStatus
extends ResourceStatus {
    public static final LocalResourceStatus NONE = new LocalResourceStatusNone();
    protected String urlCopiedFrom;
    protected String pathConflictOld;
    protected String pathConflictWorking;
    protected String pathConflictNew;
    protected String lockOwner;
    protected long lockCreationDate;
    protected String lockComment;
    protected boolean readOnly;
    protected boolean isCopied;
    protected boolean isWcLocked;
    protected boolean isSwitched;
    static final long serialVersionUID = 1L;

    public static LocalResourceStatus fromBytes(byte[] bytes) throws SVNException {
        return bytes != null && bytes.length > 0 ? new LocalResourceStatus(bytes) : null;
    }

    protected LocalResourceStatus() {
    }

    public LocalResourceStatus(ISVNStatus status, String url) {
        super(status, url);
        Object aValue = null;
        aValue = status.getUrlCopiedFrom();
        this.urlCopiedFrom = aValue == null ? null : aValue.toString();
        this.readOnly = !this.getFile().canWrite();
        aValue = status.getConflictNew();
        this.pathConflictNew = aValue == null ? null : ((File)aValue).getAbsolutePath();
        aValue = status.getConflictOld();
        this.pathConflictOld = aValue == null ? null : ((File)aValue).getAbsolutePath();
        aValue = status.getConflictWorking();
        this.pathConflictWorking = aValue == null ? null : ((File)aValue).getAbsolutePath();
        this.lockOwner = status.getLockOwner();
        this.lockComment = status.getLockComment();
        aValue = status.getLockCreationDate();
        this.lockCreationDate = aValue == null ? -1L : ((Date)aValue).getTime();
        this.isCopied = status.isCopied();
        this.isWcLocked = status.isWcLocked();
        this.isSwitched = status.isSwitched();
    }

    protected LocalResourceStatus(byte[] bytes) throws SVNException {
        if (bytes.length < 4) {
            return;
        }
        ResourceStatus.StatusFromBytesStream in = new ResourceStatus.StatusFromBytesStream(bytes);
        this.initFromBytes(in);
    }

    protected void getBytesInto(ResourceStatus.StatusToBytesStream dos) {
        super.getBytesInto(dos);
        try {
            dos.writeString(this.urlCopiedFrom);
            dos.writeString(this.pathConflictOld);
            dos.writeString(this.pathConflictNew);
            dos.writeString(this.pathConflictWorking);
            dos.writeString(this.lockOwner);
            dos.writeLong(this.lockCreationDate);
            dos.writeString(this.lockComment);
            dos.writeBoolean(this.isCopied);
            dos.writeBoolean(this.isWcLocked);
            dos.writeBoolean(this.isSwitched);
            dos.writeBoolean(this.readOnly);
            dos.writeString(this.file.getAbsolutePath());
        }
        catch (IOException iOException) {
            return;
        }
    }

    protected int initFromBytes(ResourceStatus.StatusFromBytesStream dis) throws SVNException {
        int version = super.initFromBytes(dis);
        try {
            if (version == 3) {
                this.readFromVersion3Stream(dis);
            } else if (version == 2) {
                this.readFromVersion2Stream(dis);
            } else {
                this.readFromVersion1Stream(dis);
            }
        }
        catch (IOException e) {
            throw new SVNException("cannot create LocalResourceStatus from bytes", e);
        }
        return version;
    }

    private void readFromVersion3Stream(ResourceStatus.StatusFromBytesStream dis) throws IOException {
        this.urlCopiedFrom = dis.readString();
        this.pathConflictOld = dis.readString();
        this.pathConflictNew = dis.readString();
        this.pathConflictWorking = dis.readString();
        this.lockOwner = dis.readString();
        this.lockCreationDate = dis.readLong();
        this.lockComment = dis.readString();
        this.isCopied = dis.readBoolean();
        this.isWcLocked = dis.readBoolean();
        this.isSwitched = dis.readBoolean();
        this.readOnly = dis.readBoolean();
        this.file = new File(dis.readString());
    }

    private void readFromVersion2Stream(ResourceStatus.StatusFromBytesStream dis) throws IOException {
        this.readFromVersion1Stream(dis);
        this.lockOwner = dis.readUTF();
        if (this.lockOwner.equals("")) {
            this.lockOwner = null;
        }
        this.lockCreationDate = dis.readLong();
        this.lockComment = dis.readUTF();
        if (this.lockComment.equals("")) {
            this.lockComment = null;
        }
        this.readOnly = dis.readBoolean();
    }

    private void readFromVersion1Stream(ResourceStatus.StatusFromBytesStream dis) throws IOException {
        String urlCopiedFromString = dis.readUTF();
        this.urlCopiedFrom = urlCopiedFromString.equals("") ? null : this.url;
        this.file = new File(dis.readUTF());
        this.pathConflictOld = dis.readUTF();
        if (this.pathConflictOld.equals("")) {
            this.pathConflictOld = null;
        }
        this.pathConflictNew = dis.readUTF();
        if (this.pathConflictNew.equals("")) {
            this.pathConflictNew = null;
        }
        this.pathConflictWorking = dis.readUTF();
        if (this.pathConflictWorking.equals("")) {
            this.pathConflictWorking = null;
        }
        this.lockOwner = null;
        this.lockCreationDate = 0L;
        this.lockComment = null;
        this.readOnly = false;
    }

    public boolean isManaged() {
        return SVNStatusUtils.isManaged((SVNStatusKind)this.getTextStatus());
    }

    public boolean hasRemote() {
        return SVNStatusUtils.hasRemote((ISVNStatus)this);
    }

    public boolean isTextDirty() {
        SVNStatusKind theTextStatus = this.getTextStatus();
        return theTextStatus.equals((Object)SVNStatusKind.ADDED) || theTextStatus.equals((Object)SVNStatusKind.DELETED) || theTextStatus.equals((Object)SVNStatusKind.REPLACED) || theTextStatus.equals((Object)SVNStatusKind.MODIFIED) || theTextStatus.equals((Object)SVNStatusKind.MERGED) || theTextStatus.equals((Object)SVNStatusKind.CONFLICTED);
    }

    public boolean isPropDirty() {
        SVNStatusKind thePropStatus = this.getPropStatus();
        return thePropStatus.equals((Object)SVNStatusKind.CONFLICTED) || thePropStatus.equals((Object)SVNStatusKind.MODIFIED);
    }

    public boolean isDirty() {
        return this.isTextDirty() || this.isPropDirty();
    }

    public boolean isUnversioned() {
        return this.getTextStatus().equals((Object)SVNStatusKind.UNVERSIONED);
    }

    public boolean isAdded() {
        return this.getTextStatus().equals((Object)SVNStatusKind.ADDED);
    }

    public boolean isDeleted() {
        return this.getTextStatus().equals((Object)SVNStatusKind.DELETED);
    }

    public boolean isMissing() {
        return this.getTextStatus().equals((Object)SVNStatusKind.MISSING);
    }

    public boolean isReplaced() {
        return this.getTextStatus().equals((Object)SVNStatusKind.REPLACED);
    }

    public boolean isIgnored() {
        return this.getTextStatus().equals((Object)SVNStatusKind.IGNORED);
    }

    public boolean isTextMerged() {
        return this.getTextStatus().equals((Object)SVNStatusKind.MERGED);
    }

    public boolean isTextModified() {
        return this.getTextStatus().equals((Object)SVNStatusKind.MODIFIED);
    }

    public boolean isTextConflicted() {
        return this.getTextStatus().equals((Object)SVNStatusKind.CONFLICTED);
    }

    public boolean isPropModified() {
        return this.getPropStatus().equals((Object)SVNStatusKind.MODIFIED);
    }

    public boolean isPropConflicted() {
        return this.getPropStatus().equals((Object)SVNStatusKind.CONFLICTED);
    }

    public boolean isLocked() {
        return this.lockOwner != null;
    }

    public SVNUrl getUrlCopiedFrom() {
        if (this.urlCopiedFrom == null) {
            return null;
        }
        try {
            return new SVNUrl(this.urlCopiedFrom);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public File getConflictOld() {
        if (this.pathConflictOld == null) {
            return null;
        }
        return new File(this.pathConflictOld);
    }

    public File getConflictNew() {
        if (this.pathConflictNew == null) {
            return null;
        }
        return new File(this.pathConflictNew);
    }

    public File getConflictWorking() {
        if (this.pathConflictWorking == null) {
            return null;
        }
        return new File(this.pathConflictWorking);
    }

    public Date getLockCreationDate() {
        if (this.lockCreationDate == -1L) {
            return null;
        }
        return new Date(this.lockCreationDate);
    }

    public String getLockOwner() {
        return this.lockOwner;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public String getLockComment() {
        return this.lockComment;
    }

    public boolean isCopied() {
        return this.isCopied;
    }

    public boolean isWcLocked() {
        return this.isWcLocked;
    }

    public boolean isSwitched() {
        return this.isSwitched;
    }

    public SVNStatusKind getRepositoryPropStatus() {
        throw new UnsupportedOperationException("LocalResourceStatus does not provide repository statuses");
    }

    public SVNStatusKind getRepositoryTextStatus() {
        throw new UnsupportedOperationException("LocalResourceStatus does not provide repository statuses");
    }

    public SVNRevision.Number getRevision() {
        throw new UnsupportedOperationException("LocalResourceStatus does not provide (repository) revision");
    }

    public static class LocalResourceStatusNone
    extends LocalResourceStatus {
        static final long serialVersionUID = 1L;

        protected LocalResourceStatusNone() {
            this.nodeKind = SVNNodeKind.UNKNOWN.toInt();
            this.textStatus = SVNStatusKind.NONE.toInt();
            this.propStatus = SVNStatusKind.NONE.toInt();
            this.readOnly = false;
        }
    }
}

