/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.ui.subscriber;

import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.ui.synchronize.ChangeSetCapability;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetChangeSetCollector;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.tigris.subversion.subclipse.core.SVNProviderPlugin;
import org.tigris.subversion.subclipse.ui.Policy;
import org.tigris.subversion.subclipse.ui.SVNUIPlugin;
import org.tigris.subversion.subclipse.ui.subscriber.CommitSetDialog;
import org.tigris.subversion.subclipse.ui.subscriber.SVNChangeSetCollector;

public class SVNChangeSetCapability
extends ChangeSetCapability {
    public ActiveChangeSet createChangeSet(ISynchronizePageConfiguration configuration, IDiff[] infos) {
        ActiveChangeSet set = this.getActiveChangeSetManager().createSet(Policy.bind("WorkspaceChangeSetCapability_1"), new IDiff[0]);
        CommitSetDialog dialog = new CommitSetDialog(configuration.getSite().getShell(), set, this.getResources(infos), Policy.bind("WorkspaceChangeSetCapability_2"), Policy.bind("WorkspaceChangeSetCapability_3"));
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return null;
        }
        set.add(infos);
        return set;
    }

    private IResource[] getResources(IDiff[] diffs) {
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            IResource resource = ResourceDiffTree.getResourceFor((IDiff)diff);
            if (resource != null) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public void editChangeSet(ISynchronizePageConfiguration configuration, ActiveChangeSet set) {
        CommitSetDialog dialog = new CommitSetDialog(configuration.getSite().getShell(), set, set.getResources(), Policy.bind("WorkspaceChangeSetCapability_7"), Policy.bind("WorkspaceChangeSetCapability_8"));
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
    }

    public boolean supportsCheckedInChangeSets() {
        return true;
    }

    public boolean supportsActiveChangeSets() {
        return true;
    }

    public SyncInfoSetChangeSetCollector createSyncInfoSetChangeSetCollector(ISynchronizePageConfiguration configuration) {
        return new SVNChangeSetCollector(configuration);
    }

    public SynchronizePageActionGroup getActionGroup() {
        return null;
    }

    public boolean enableChangeSetsByDefault() {
        return SVNUIPlugin.getPlugin().getPreferenceStore().getBoolean("pref_enable_commit_sets");
    }

    public ActiveChangeSetManager getActiveChangeSetManager() {
        return SVNProviderPlugin.getPlugin().getChangeSetManager();
    }

    public boolean enableActiveChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsActiveChangeSets() && configuration.getMode() != 1;
    }

    public boolean enableCheckedInChangeSetsFor(ISynchronizePageConfiguration configuration) {
        return this.supportsCheckedInChangeSets() && configuration.getMode() != 2;
    }
}

