/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.rubypeople.rdt.internal.core.builder.IndexUpdater;
import org.rubypeople.rdt.internal.core.builder.MassIndexUpdater;
import org.rubypeople.rdt.internal.core.builder.MassIndexUpdaterJob;
import org.rubypeople.rdt.internal.core.symbols.SymbolIndex;
import org.rubypeople.rdt.internal.core.util.EclipseJobScheduler;
import org.rubypeople.rdt.internal.core.util.IJobScheduler;

public final class SymbolIndexResourceChangeListener
implements IResourceChangeListener {
    private final MassIndexUpdater updater;
    private final SymbolIndex symbolIndex;
    private final IJobScheduler scheduler;
    static /* synthetic */ Class class$0;

    public static void register(SymbolIndex symbolIndex) {
        IndexUpdater indexUpdater = new IndexUpdater(symbolIndex);
        MassIndexUpdater massIndexUpdater = new MassIndexUpdater(indexUpdater);
        SymbolIndexResourceChangeListener symbolIndexResourceChangeListener = new SymbolIndexResourceChangeListener(massIndexUpdater, symbolIndex, new EclipseJobScheduler());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)symbolIndexResourceChangeListener);
    }

    public SymbolIndexResourceChangeListener(MassIndexUpdater massIndexUpdater, SymbolIndex symbolIndex, IJobScheduler iJobScheduler) {
        this.updater = massIndexUpdater;
        this.symbolIndex = symbolIndex;
        this.scheduler = iJobScheduler;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        if (iResourceChangeEvent.getType() == 1) {
            this.handlePostChangeEvent(iResourceChangeEvent);
        } else if (iResourceChangeEvent.getType() == 2 || iResourceChangeEvent.getType() == 4) {
            this.symbolIndex.flush((IProject)iResourceChangeEvent.getResource());
        }
    }

    private void handlePostChangeEvent(IResourceChangeEvent iResourceChangeEvent) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        IResourceDelta[] iResourceDeltaArray = iResourceChangeEvent.getDelta().getAffectedChildren();
        int n = 0;
        while (n < iResourceDeltaArray.length) {
            IResource iResource;
            IResourceDelta iResourceDelta = iResourceDeltaArray[n];
            if (this.isDeltaOpen(iResourceDelta) && this.isProject(iResource = iResourceDelta.getResource())) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.core.resources.IProject");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                arrayList.add(iResource.getAdapter((Class)clazz));
            }
            ++n;
        }
        this.scheduler.schedule(new MassIndexUpdaterJob(this.updater, arrayList));
    }

    private boolean isProject(IResource iResource) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IProject");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IProject)iResource.getAdapter((Class)clazz) != null;
    }

    private boolean isDeltaOpen(IResourceDelta iResourceDelta) {
        return iResourceDelta.getKind() == 4 && (iResourceDelta.getFlags() & 0x4000) != 0;
    }
}

