/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.util;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class ResourceSelector {
    protected static final String EMPTY_STRING = "";
    protected Composite composite;
    protected Button browseButton;
    protected Text textField;
    protected String browseDialogMessage = "";
    protected String browseDialogTitle = "";
    protected String validatedSelectionText = "";

    public ResourceSelector(Composite composite) {
        this.composite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        this.textField = new Text(this.composite, 2052);
        this.textField.setLayoutData((Object)new GridData(768));
        this.textField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                ResourceSelector.this.validatedSelectionText = ResourceSelector.this.validateResourceSelection();
            }
        });
        this.browseButton = new Button(this.composite, 8);
        this.browseButton.setText("Browse...");
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourceSelector.this.handleBrowseSelected();
            }
        });
    }

    protected abstract void handleBrowseSelected();

    protected abstract String validateResourceSelection();

    protected Shell getShell() {
        return this.composite.getShell();
    }

    public void setLayoutData(Object object) {
        this.composite.setLayoutData(object);
    }

    public void addModifyListener(ModifyListener modifyListener) {
        this.textField.addModifyListener(modifyListener);
    }

    public void setBrowseDialogMessage(String string) {
        this.browseDialogMessage = string;
    }

    public void setBrowseDialogTitle(String string) {
        this.browseDialogTitle = string;
    }

    public void setEnabled(boolean bl) {
        this.composite.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.browseButton.setEnabled(bl);
    }

    public String getSelectionText() {
        return this.textField.getText();
    }

    public String getValidatedSelectionText() {
        return this.validatedSelectionText;
    }

    public void setSelectionText(String string) {
        this.textField.setText(string);
    }
}

