/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;
import org.rubypeople.rdt.core.formatter.DefaultCodeFormatterConstants;
import org.rubypeople.rdt.internal.corext.util.Messages;
import org.rubypeople.rdt.internal.ui.preferences.PreferencesAccess;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ProfileVersioner;

public class ProfileManager
extends Observable {
    private static final String ID_PREFIX = "_";
    public static final int SELECTION_CHANGED_EVENT = 1;
    public static final int PROFILE_DELETED_EVENT = 2;
    public static final int PROFILE_RENAMED_EVENT = 3;
    public static final int PROFILE_CREATED_EVENT = 4;
    public static final int SETTINGS_CHANGED_EVENT = 5;
    private static final String PROFILE_KEY = "formatter_profile";
    private static final String FORMATTER_SETTINGS_VERSION = "formatter_settings_version";
    public static final String ECLIPSE_PROFILE = "org.rubypeople.rdt.ui.default.eclipse_profile";
    public static final String RUBY_PROFILE = "org.rubypeople.rdt.ui.default.ruby_profile";
    public static final String SHARED_PROFILE = "org.rubypeople.rdt.ui.default.shared";
    public static final String DEFAULT_PROFILE = "org.rubypeople.rdt.ui.default.eclipse_profile";
    private final Map fProfiles;
    private final List fProfilesByName;
    private Profile fSelected;
    private static final List fUIKeys = Collections.EMPTY_LIST;
    private static final List fCoreKeys = new ArrayList(DefaultCodeFormatterConstants.getRubyConventionsSettings().keySet());
    private static final List fKeys = new ArrayList();
    private final PreferencesAccess fPreferencesAccess;

    static {
        fKeys.addAll(fUIKeys);
        fKeys.addAll(fCoreKeys);
        Collections.sort(fKeys);
    }

    public ProfileManager(List list, IScopeContext iScopeContext, PreferencesAccess preferencesAccess) {
        block6: {
            Profile profile;
            Object object;
            String string;
            Object object2;
            Object object3;
            block8: {
                block7: {
                    Object object4;
                    Object object5;
                    this.fPreferencesAccess = preferencesAccess;
                    this.fProfiles = new HashMap();
                    this.fProfilesByName = new ArrayList();
                    this.addBuiltinProfiles(this.fProfiles, this.fProfilesByName);
                    IScopeContext iScopeContext2 = list.iterator();
                    while (iScopeContext2.hasNext()) {
                        object5 = (CustomProfile)iScopeContext2.next();
                        ((CustomProfile)object5).setManager(this);
                        this.fProfiles.put(((CustomProfile)object5).getID(), object5);
                        this.fProfilesByName.add(object5);
                    }
                    Collections.sort(this.fProfilesByName);
                    iScopeContext2 = this.fPreferencesAccess.getInstanceScope();
                    object5 = iScopeContext2.getNode("org.rubypeople.rdt.ui").get(PROFILE_KEY, null);
                    if (object5 == null) {
                        object5 = "org.rubypeople.rdt.ui.default.eclipse_profile";
                        object4 = iScopeContext2.getNode("org.rubypeople.rdt.core");
                        if (object4 != null && "space".equals(object3 = object4.get("org.rubypeople.rdt.core.formatter.tabulation.char", null))) {
                            object5 = RUBY_PROFILE;
                        }
                    }
                    if ((object4 = (Profile)this.fProfiles.get(object5)) == null) {
                        object4 = (Profile)this.fProfiles.get("org.rubypeople.rdt.ui.default.eclipse_profile");
                    }
                    this.fSelected = object4;
                    if (iScopeContext.getName() != "project" || !ProfileManager.hasProjectSpecificSettings(iScopeContext) || (object3 = this.readFromPreferenceStore(iScopeContext, (Profile)object4)) == null) break block6;
                    object2 = null;
                    string = iScopeContext.getNode("org.rubypeople.rdt.ui").get(PROFILE_KEY, null);
                    if (string == null) break block7;
                    object = (Profile)this.fProfiles.get(string);
                    if (object == null || !((Profile)object).isBuiltInProfile() && !((Profile)object).hasEqualSettings((Map)object3, ProfileManager.getKeys())) break block8;
                    object2 = object;
                    break block8;
                }
                object = this.fProfilesByName.iterator();
                while (object.hasNext()) {
                    profile = (Profile)object.next();
                    if (!profile.hasEqualSettings((Map)object3, ProfileManager.getKeys())) continue;
                    object2 = profile;
                    break;
                }
            }
            if (object2 == null) {
                object = string != null && !this.fProfiles.containsKey(string) ? Messages.format(FormatterMessages.ProfileManager_unmanaged_profile_with_name, string.substring(ID_PREFIX.length())) : FormatterMessages.ProfileManager_unmanaged_profile;
                profile = new SharedProfile((String)object, (Map)object3);
                ((CustomProfile)profile).setManager(this);
                this.fProfiles.put(((SharedProfile)profile).getID(), profile);
                this.fProfilesByName.add(profile);
                object2 = profile;
            }
            this.fSelected = object2;
        }
    }

    protected void notifyObservers(int n) {
        this.setChanged();
        this.notifyObservers(new Integer(n));
    }

    public static boolean hasProjectSpecificSettings(IScopeContext iScopeContext) {
        String string;
        Object object;
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.rubypeople.rdt.core");
        IEclipsePreferences iEclipsePreferences2 = fCoreKeys.iterator();
        while (iEclipsePreferences2.hasNext()) {
            object = (String)iEclipsePreferences2.next();
            string = iEclipsePreferences.get((String)object, null);
            if (string == null) continue;
            return true;
        }
        iEclipsePreferences2 = iScopeContext.getNode("org.rubypeople.rdt.ui");
        object = fUIKeys.iterator();
        while (object.hasNext()) {
            string = (String)object.next();
            String string2 = iEclipsePreferences2.get(string, null);
            if (string2 == null) continue;
            return true;
        }
        return false;
    }

    public Map readFromPreferenceStore(IScopeContext iScopeContext, Profile profile) {
        String string;
        String string2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.rubypeople.rdt.ui");
        IEclipsePreferences iEclipsePreferences2 = iScopeContext.getNode("org.rubypeople.rdt.core");
        int n = iEclipsePreferences.getInt(FORMATTER_SETTINGS_VERSION, 1);
        if (n != 1) {
            HashMap hashMap2 = new HashMap();
            this.addAll(iEclipsePreferences, hashMap2);
            this.addAll(iEclipsePreferences2, hashMap2);
            return ProfileVersioner.updateAndComplete(hashMap2, n);
        }
        boolean bl = false;
        Iterator iterator = fCoreKeys.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = iEclipsePreferences2.get(string2, null);
            if (string != null) {
                bl = true;
            } else {
                string = profile.getSettings().get(string2);
            }
            hashMap.put(string2, string);
        }
        iterator = fUIKeys.iterator();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            string = iEclipsePreferences.get(string2, null);
            if (string != null) {
                bl = true;
            } else {
                string = profile.getSettings().get(string2);
            }
            hashMap.put(string2, string);
        }
        if (!bl) {
            return null;
        }
        return hashMap;
    }

    private void addAll(IEclipsePreferences iEclipsePreferences, Map map) {
        try {
            String[] stringArray = iEclipsePreferences.keys();
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                String string2 = iEclipsePreferences.get(string, null);
                if (string2 != null) {
                    map.put(string, string2);
                }
                ++n;
            }
        }
        catch (BackingStoreException backingStoreException) {}
    }

    private boolean updatePreferences(IEclipsePreferences iEclipsePreferences, List list, Map map) {
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = iEclipsePreferences.get(string, null);
            String string3 = (String)map.get(string);
            if (string3 == null) {
                if (string2 == null) continue;
                iEclipsePreferences.remove(string);
                bl = true;
                continue;
            }
            if (string3.equals(string2)) continue;
            iEclipsePreferences.put(string, string3);
            bl = true;
        }
        return bl;
    }

    private void writeToPreferenceStore(Profile profile, IScopeContext iScopeContext) {
        Map map = profile.getSettings();
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.rubypeople.rdt.core");
        this.updatePreferences(iEclipsePreferences, fCoreKeys, map);
        IEclipsePreferences iEclipsePreferences2 = iScopeContext.getNode("org.rubypeople.rdt.ui");
        this.updatePreferences(iEclipsePreferences2, fUIKeys, map);
        if (iEclipsePreferences2.getInt(FORMATTER_SETTINGS_VERSION, 0) != 1) {
            iEclipsePreferences2.putInt(FORMATTER_SETTINGS_VERSION, 1);
        }
        if (iScopeContext.getName() == "instance") {
            iEclipsePreferences2.put(PROFILE_KEY, profile.getID());
        } else if (iScopeContext.getName() == "project" && !profile.isSharedProfile()) {
            iEclipsePreferences2.put(PROFILE_KEY, profile.getID());
        }
    }

    private void addBuiltinProfiles(Map map, List list) {
        BuiltInProfile builtInProfile = new BuiltInProfile(RUBY_PROFILE, FormatterMessages.ProfileManager_ruby_conventions_profile_name, ProfileManager.getRubySettings(), 1);
        map.put(((Profile)builtInProfile).getID(), builtInProfile);
        list.add(builtInProfile);
        BuiltInProfile builtInProfile2 = new BuiltInProfile("org.rubypeople.rdt.ui.default.eclipse_profile", FormatterMessages.ProfileManager_eclipse_profile_name, ProfileManager.getEclipseSettings(), 2);
        map.put(((Profile)builtInProfile2).getID(), builtInProfile2);
        list.add(builtInProfile2);
    }

    public static Map getEclipseSettings() {
        Map map = DefaultCodeFormatterConstants.getEclipseDefaultSettings();
        return map;
    }

    public static Map getRubySettings() {
        Map map = DefaultCodeFormatterConstants.getRubyConventionsSettings();
        return map;
    }

    public static Map getDefaultSettings() {
        return ProfileManager.getEclipseSettings();
    }

    public static List getKeys() {
        return fKeys;
    }

    public List getSortedProfiles() {
        return Collections.unmodifiableList(this.fProfilesByName);
    }

    public String[] getSortedDisplayNames() {
        String[] stringArray = new String[this.fProfilesByName.size()];
        int n = 0;
        Iterator iterator = this.fProfilesByName.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            stringArray[n++] = profile.getName();
        }
        return stringArray;
    }

    public Profile getProfile(String string) {
        return (Profile)this.fProfiles.get(string);
    }

    public void commitChanges(IScopeContext iScopeContext) {
        if (this.fSelected != null) {
            this.writeToPreferenceStore(this.fSelected, iScopeContext);
        }
    }

    public void clearAllSettings(IScopeContext iScopeContext) {
        IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.rubypeople.rdt.core");
        this.updatePreferences(iEclipsePreferences, fCoreKeys, Collections.EMPTY_MAP);
        IEclipsePreferences iEclipsePreferences2 = iScopeContext.getNode("org.rubypeople.rdt.ui");
        this.updatePreferences(iEclipsePreferences2, fUIKeys, Collections.EMPTY_MAP);
        iEclipsePreferences2.remove(PROFILE_KEY);
    }

    public Profile getSelected() {
        return this.fSelected;
    }

    public void setSelected(Profile profile) {
        Profile profile2 = (Profile)this.fProfiles.get(profile.getID());
        if (profile2 != null && !profile2.equals(this.fSelected)) {
            this.fSelected = profile2;
            this.notifyObservers(1);
        }
    }

    public boolean containsName(String string) {
        Iterator iterator = this.fProfilesByName.iterator();
        while (iterator.hasNext()) {
            Profile profile = (Profile)iterator.next();
            if (!string.equals(profile.getName())) continue;
            return true;
        }
        return false;
    }

    public void addProfile(CustomProfile customProfile) {
        customProfile.setManager(this);
        CustomProfile customProfile2 = (CustomProfile)this.fProfiles.get(customProfile.getID());
        if (customProfile2 != null) {
            this.fProfiles.remove(customProfile2.getID());
            this.fProfilesByName.remove(customProfile2);
            customProfile2.setManager(null);
        }
        this.fProfiles.put(customProfile.getID(), customProfile);
        this.fProfilesByName.add(customProfile);
        Collections.sort(this.fProfilesByName);
        this.fSelected = customProfile;
        this.notifyObservers(4);
    }

    public boolean deleteSelected() {
        if (!(this.fSelected instanceof CustomProfile)) {
            return false;
        }
        Profile profile = this.fSelected;
        int n = this.fProfilesByName.indexOf(profile);
        this.fProfiles.remove(profile.getID());
        this.fProfilesByName.remove(profile);
        ((CustomProfile)profile).setManager(null);
        if (n >= this.fProfilesByName.size()) {
            --n;
        }
        this.fSelected = (Profile)this.fProfilesByName.get(n);
        if (!profile.isSharedProfile()) {
            this.updateProfilesWithName(profile.getID(), null, false);
        }
        this.notifyObservers(2);
        return true;
    }

    public void profileRenamed(CustomProfile customProfile, String string) {
        this.fProfiles.remove(string);
        this.fProfiles.put(customProfile.getID(), customProfile);
        if (!customProfile.isSharedProfile()) {
            this.updateProfilesWithName(string, customProfile, false);
        }
        Collections.sort(this.fProfilesByName);
        this.notifyObservers(3);
    }

    public void profileReplaced(CustomProfile customProfile, CustomProfile customProfile2) {
        this.fProfiles.remove(customProfile.getID());
        this.fProfiles.put(customProfile2.getID(), customProfile2);
        this.fProfilesByName.remove(customProfile);
        this.fProfilesByName.add(customProfile2);
        Collections.sort(this.fProfilesByName);
        if (!customProfile.isSharedProfile()) {
            this.updateProfilesWithName(customProfile.getID(), null, false);
        }
        this.setSelected(customProfile2);
        this.notifyObservers(4);
        this.notifyObservers(1);
    }

    public void profileChanged(CustomProfile customProfile) {
        if (!customProfile.isSharedProfile()) {
            this.updateProfilesWithName(customProfile.getID(), customProfile, true);
        }
        this.notifyObservers(5);
    }

    private void updateProfilesWithName(String string, Profile profile, boolean bl) {
        IScopeContext iScopeContext;
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = 0;
        while (n < iProjectArray.length) {
            iScopeContext = this.fPreferencesAccess.getProjectScope(iProjectArray[n]);
            IEclipsePreferences iEclipsePreferences = iScopeContext.getNode("org.rubypeople.rdt.ui");
            String string2 = iEclipsePreferences.get(PROFILE_KEY, null);
            if (string.equals(string2)) {
                if (profile == null) {
                    iEclipsePreferences.remove(PROFILE_KEY);
                } else if (bl) {
                    this.writeToPreferenceStore(profile, iScopeContext);
                } else {
                    iEclipsePreferences.put(PROFILE_KEY, profile.getID());
                }
            }
            ++n;
        }
        IScopeContext iScopeContext2 = this.fPreferencesAccess.getInstanceScope();
        iScopeContext = iScopeContext2.getNode("org.rubypeople.rdt.ui");
        if (profile != null && string.equals(iScopeContext.get(PROFILE_KEY, null))) {
            this.writeToPreferenceStore(profile, iScopeContext2);
        }
    }

    public static abstract class Profile
    implements Comparable {
        public abstract String getName();

        public abstract Profile rename(String var1, ProfileManager var2);

        public abstract Map getSettings();

        public abstract void setSettings(Map var1);

        public int getVersion() {
            return 1;
        }

        public boolean hasEqualSettings(Map map, List list) {
            Map map2 = this.getSettings();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Object v = map.get(string);
                Object v2 = map2.get(string);
                if (!(v == null ? v2 != null : !v.equals(v2))) continue;
                return false;
            }
            return true;
        }

        public abstract boolean isProfileToSave();

        public abstract String getID();

        public boolean isSharedProfile() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return false;
        }
    }

    public static final class BuiltInProfile
    extends Profile {
        private final String fName;
        private final String fID;
        private final Map fSettings;
        private final int fOrder;

        protected BuiltInProfile(String string, String string2, Map map, int n) {
            this.fName = string2;
            this.fID = string;
            this.fSettings = map;
            this.fOrder = n;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String string, ProfileManager profileManager) {
            String string2 = string.trim();
            CustomProfile customProfile = new CustomProfile(string2, this.fSettings, 1);
            profileManager.addProfile(customProfile);
            return customProfile;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map map) {
        }

        public String getID() {
            return this.fID;
        }

        public final int compareTo(Object object) {
            if (object instanceof BuiltInProfile) {
                return this.fOrder - ((BuiltInProfile)object).fOrder;
            }
            return -1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isBuiltInProfile() {
            return true;
        }
    }

    public static class CustomProfile
    extends Profile {
        private String fName;
        private Map fSettings;
        protected ProfileManager fManager;
        private int fVersion;

        public CustomProfile(String string, Map map, int n) {
            this.fName = string;
            this.fSettings = map;
            this.fVersion = n;
        }

        public String getName() {
            return this.fName;
        }

        public Profile rename(String string, ProfileManager profileManager) {
            String string2 = string.trim();
            if (string2.equals(this.getName())) {
                return this;
            }
            String string3 = this.getID();
            this.fName = string2;
            profileManager.profileRenamed(this, string3);
            return this;
        }

        public Map getSettings() {
            return this.fSettings;
        }

        public void setSettings(Map map) {
            if (map == null) {
                throw new IllegalArgumentException();
            }
            this.fSettings = map;
            if (this.fManager != null) {
                this.fManager.profileChanged(this);
            }
        }

        public String getID() {
            return ProfileManager.ID_PREFIX + this.fName;
        }

        public void setManager(ProfileManager profileManager) {
            this.fManager = profileManager;
        }

        public ProfileManager getManager() {
            return this.fManager;
        }

        public int getVersion() {
            return this.fVersion;
        }

        public void setVersion(int n) {
            this.fVersion = n;
        }

        public int compareTo(Object object) {
            if (object instanceof SharedProfile) {
                return -1;
            }
            if (object instanceof CustomProfile) {
                return this.getName().compareToIgnoreCase(((Profile)object).getName());
            }
            return 1;
        }

        public boolean isProfileToSave() {
            return true;
        }
    }

    public static final class SharedProfile
    extends CustomProfile {
        public SharedProfile(String string, Map map) {
            super(string, map, 1);
        }

        public Profile rename(String string, ProfileManager profileManager) {
            CustomProfile customProfile = new CustomProfile(string.trim(), this.getSettings(), this.getVersion());
            profileManager.profileReplaced(this, customProfile);
            return customProfile;
        }

        public String getID() {
            return ProfileManager.SHARED_PROFILE;
        }

        public final int compareTo(Object object) {
            return 1;
        }

        public boolean isProfileToSave() {
            return false;
        }

        public boolean isSharedProfile() {
            return true;
        }
    }
}

