/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences.formatter;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.text.Assert;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.rubypeople.rdt.internal.ui.preferences.formatter.FormatterMessages;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialog;
import org.rubypeople.rdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RubyPreview;
import org.rubypeople.rdt.internal.ui.preferences.formatter.RubyScriptPreview;

public class IndentationTabPage
extends ModifyDialogTabPage {
    private final String PREVIEW = String.valueOf(IndentationTabPage.createPreviewHeader(FormatterMessages.IndentationTabPage_preview_header)) + "class Example\n" + "  @@my_hash= {1 => 'one', 2 => 'two',3 => 'three'}\n" + "  @@my_array= [1,2,3,4,5,6]\n" + "  MY_CONST= 1\n" + "  $some_string= \"Hello\"\n" + "  a_float= 3.0\n" + "  def foo(a, b, c, d, e, f)\n" + "    case a\n" + "    when 0\n" + "      Other.foo\n" + "    else\n" + "      Other.baz\n" + "    end\n" + "  end\n" + "  def bar(v)\n" + "    for i in 0...10 do\n" + "      v << i\n" + "    end\n" + "  end\n" + "end\n" + "\n" + "module MyModule\n" + "end";
    private RubyScriptPreview fPreview;
    private String fOldTabChar = null;

    public IndentationTabPage(ModifyDialog modifyDialog, Map map) {
        super(modifyDialog, map);
    }

    protected void doCreatePreferences(Composite composite, int n) {
        Group group = this.createGroup(n, composite, FormatterMessages.IndentationTabPage_general_group_title);
        String[] stringArray = new String[]{"space", "tab", "mixed"};
        String[] stringArray2 = new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED};
        ModifyDialogTabPage.ComboPreference comboPreference = this.createComboPref((Composite)group, n, FormatterMessages.IndentationTabPage_general_group_option_tab_policy, "org.rubypeople.rdt.core.formatter.tabulation.char", stringArray, stringArray2);
        final ModifyDialogTabPage.CheckboxPreference checkboxPreference = this.createCheckboxPref((Composite)group, n, FormatterMessages.IndentationTabPage_use_tabs_only_for_leading_indentations, "org.rubypeople.rdt.core.formatter.use_tabs_only_for_leading_indentations", FALSE_TRUE);
        final ModifyDialogTabPage.NumberPreference numberPreference = this.createNumberPref((Composite)group, n, FormatterMessages.IndentationTabPage_general_group_option_indent_size, "org.rubypeople.rdt.core.formatter.tabulation.size", 0, 32);
        final ModifyDialogTabPage.NumberPreference numberPreference2 = this.createNumberPref((Composite)group, n, FormatterMessages.IndentationTabPage_general_group_option_tab_size, "org.rubypeople.rdt.core.formatter.tabulation.size", 0, 32);
        String string = (String)this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.tabulation.char");
        this.updateTabPreferences(string, numberPreference2, numberPreference, checkboxPreference);
        comboPreference.addObserver(new Observer(){

            public void update(Observable observable, Object object) {
                IndentationTabPage.this.updateTabPreferences((String)object, numberPreference2, numberPreference, checkboxPreference);
            }
        });
        numberPreference2.addObserver(new Observer(){

            public void update(Observable observable, Object object) {
                numberPreference.updateWidget();
            }
        });
        Group group2 = this.createGroup(n, composite, FormatterMessages.IndentationTabPage_indent_group_title);
        this.createCheckboxPref((Composite)group2, n, FormatterMessages.IndentationTabPage_indent_empty_lines, "org.rubypeople.rdt.core.formatter.indent_empty_lines", FALSE_TRUE);
    }

    public void initializePage() {
        this.fPreview.setPreviewText(this.PREVIEW);
    }

    protected RubyPreview doCreateRubyPreview(Composite composite) {
        this.fPreview = new RubyScriptPreview(this.fWorkingValues, composite);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private void updateTabPreferences(String string, ModifyDialogTabPage.NumberPreference numberPreference, ModifyDialogTabPage.NumberPreference numberPreference2, ModifyDialogTabPage.CheckboxPreference checkboxPreference) {
        if ("mixed".equals(string)) {
            if ("space".equals(this.fOldTabChar) || "tab".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            numberPreference.setEnabled(true);
            numberPreference.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            numberPreference2.setEnabled(true);
            numberPreference2.setKey("org.rubypeople.rdt.core.formatter.indentation.size");
            checkboxPreference.setEnabled(true);
        } else if ("space".equals(string)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            numberPreference.setEnabled(true);
            numberPreference.setKey("org.rubypeople.rdt.core.formatter.indentation.size");
            numberPreference2.setEnabled(true);
            numberPreference2.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            checkboxPreference.setEnabled(false);
        } else if ("tab".equals(string)) {
            if ("mixed".equals(this.fOldTabChar)) {
                this.swapTabValues();
            }
            numberPreference.setEnabled(true);
            numberPreference.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            numberPreference2.setEnabled(false);
            numberPreference2.setKey("org.rubypeople.rdt.core.formatter.tabulation.size");
            checkboxPreference.setEnabled(true);
        } else {
            Assert.isTrue((boolean)false);
        }
        this.fOldTabChar = string;
    }

    private void swapTabValues() {
        Object v = this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.tabulation.size");
        Object v2 = this.fWorkingValues.get("org.rubypeople.rdt.core.formatter.indentation.size");
        this.fWorkingValues.put("org.rubypeople.rdt.core.formatter.tabulation.size", v2);
        this.fWorkingValues.put("org.rubypeople.rdt.core.formatter.indentation.size", v);
    }
}

