/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.rubypeople.rdt.core.IRubyElement;
import org.rubypeople.rdt.core.IRubyProject;
import org.rubypeople.rdt.internal.ui.actions.ActionMessages;
import org.rubypeople.rdt.internal.ui.actions.SelectionConverter;
import org.rubypeople.rdt.internal.ui.rubyeditor.RubyEditor;

public class ActionUtil {
    private ActionUtil() {
    }

    public static boolean isProcessable(Shell shell, RubyEditor rubyEditor) {
        if (rubyEditor == null) {
            return true;
        }
        IRubyElement iRubyElement = SelectionConverter.getInput(rubyEditor);
        if (iRubyElement == null) {
            MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
            return false;
        }
        return ActionUtil.isProcessable(shell, iRubyElement);
    }

    public static boolean isProcessable(Shell shell, Object object) {
        if (!(object instanceof IRubyElement)) {
            return true;
        }
        if (ActionUtil.isOnBuildPath((IRubyElement)object)) {
            return true;
        }
        MessageDialog.openInformation((Shell)shell, (String)ActionMessages.ActionUtil_notOnBuildPath_title, (String)ActionMessages.ActionUtil_notOnBuildPath_message);
        return false;
    }

    public static boolean isOnBuildPath(IRubyElement iRubyElement) {
        if (iRubyElement.getElementType() == 1) {
            return true;
        }
        IRubyProject iRubyProject = iRubyElement.getRubyProject();
        try {
            IProject iProject = iRubyProject.getProject();
            if (iProject == null) {
                return false;
            }
            IProjectNature iProjectNature = iProject.getNature("org.rubypeople.rdt.core.rubynature");
            if (iProjectNature != null) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

