/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.util;

import fr.jayasoft.ivy.IvyContext;
import fr.jayasoft.ivy.util.MessageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Message {
    public static final int MSG_ERR = 0;
    public static final int MSG_WARN = 1;
    public static final int MSG_INFO = 2;
    public static final int MSG_VERBOSE = 3;
    public static final int MSG_DEBUG = 4;
    private static List _problems = new ArrayList();
    private static List _warns = new ArrayList();
    private static List _errors = new ArrayList();
    private static boolean _showProgress = true;
    private static boolean _showedInfo = false;

    public static void init(MessageImpl impl) {
        IvyContext.getContext().setMessageImpl(impl);
        Message.showInfo();
    }

    public static void setImpl(MessageImpl impl) {
        IvyContext.getContext().setMessageImpl(impl);
    }

    public static MessageImpl getImpl() {
        return IvyContext.getContext().getMessageImpl();
    }

    public static boolean isInitialised() {
        return IvyContext.getContext().getMessageImpl() != null;
    }

    private static void showInfo() {
        if (!_showedInfo) {
            Properties props = new Properties();
            URL moduleURL = Message.class.getResource("/module.properties");
            if (moduleURL != null) {
                try {
                    InputStream module = moduleURL.openStream();
                    props.load(module);
                    Message.debug("version information loaded from " + moduleURL);
                    Message.info(":: Ivy " + props.getProperty("version") + " - " + props.getProperty("date") + " :: http://ivy.jayasoft.org/ ::");
                    module.close();
                }
                catch (IOException e) {
                    Message.info(":: Ivy non official version :: http://ivy.jayasoft.org/ ::");
                }
            } else {
                Message.info(":: Ivy non official version :: http://ivy.jayasoft.org/ ::");
            }
            _showedInfo = true;
        }
    }

    public static void debug(String msg) {
        MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
        if (messageImpl != null) {
            messageImpl.log(msg, 4);
        } else {
            System.err.println(msg);
        }
    }

    public static void verbose(String msg) {
        MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
        if (messageImpl != null) {
            messageImpl.log(msg, 3);
        } else {
            System.err.println(msg);
        }
    }

    public static void info(String msg) {
        MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
        if (messageImpl != null) {
            messageImpl.log(msg, 2);
        } else {
            System.err.println(msg);
        }
    }

    public static void rawinfo(String msg) {
        MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
        if (messageImpl != null) {
            messageImpl.rawlog(msg, 2);
        } else {
            System.err.println(msg);
        }
    }

    public static void warn(String msg) {
        MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
        if (messageImpl != null) {
            messageImpl.log("WARN: " + msg, 3);
        } else {
            System.err.println(msg);
        }
        _problems.add("WARN:  " + msg);
        _warns.add(msg);
    }

    public static void error(String msg) {
        MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
        if (messageImpl != null) {
            messageImpl.log("ERROR: " + msg, 3);
        } else {
            System.err.println(msg);
        }
        _problems.add("\tERROR: " + msg);
        _errors.add(msg);
    }

    public static List getProblems() {
        return _problems;
    }

    public static void sumupProblems() {
        if (_problems.size() > 0) {
            String msg;
            Iterator iter;
            Message.info("\n:: problems summary ::");
            MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
            if (_warns.size() > 0) {
                Message.info(":::: WARNINGS");
                iter = _warns.iterator();
                while (iter.hasNext()) {
                    msg = (String)iter.next();
                    if (messageImpl != null) {
                        messageImpl.log("\t" + msg + "\n", 1);
                        continue;
                    }
                    System.err.println(msg);
                }
            }
            if (_errors.size() > 0) {
                Message.info(":::: ERRORS");
                iter = _errors.iterator();
                while (iter.hasNext()) {
                    msg = (String)iter.next();
                    if (messageImpl != null) {
                        messageImpl.log("\t" + msg + "\n", 0);
                        continue;
                    }
                    System.err.println(msg);
                }
            }
            Message.info("\n:: USE VERBOSE OR DEBUG MESSAGE LEVEL FOR MORE DETAILS");
            _problems.clear();
            _warns.clear();
            _errors.clear();
        }
    }

    public static void progress() {
        if (_showProgress) {
            MessageImpl messageImpl = IvyContext.getContext().getMessageImpl();
            if (messageImpl != null) {
                messageImpl.progress();
            } else {
                System.out.println(".");
            }
        }
    }

    public static void endProgress() {
        Message.endProgress("");
    }

    public static void endProgress(String msg) {
        MessageImpl messageImpl;
        if (_showProgress && (messageImpl = IvyContext.getContext().getMessageImpl()) != null) {
            messageImpl.endProgress(msg);
        }
    }

    public static boolean isShowProgress() {
        return _showProgress;
    }

    public static void setShowProgress(boolean progress) {
        _showProgress = progress;
    }

    public static void uninit() {
        IvyContext.getContext().setMessageImpl(null);
    }
}

