/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.xml;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.xml.MetaCharacterMap;
import edu.umd.cs.findbugs.xml.QuoteMetaCharacters;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLAttributeList {
    private static final MetaCharacterMap attrMetaCharacterMap = new MetaCharacterMap();
    private List<NameValuePair> nameValuePairList = new LinkedList<NameValuePair>();

    public XMLAttributeList addAttribute(@NonNull String name, @NonNull String value) {
        if (name == null) {
            throw new NullPointerException("name must be nonnull");
        }
        if (value == null) {
            throw new NullPointerException("value must be nonnull");
        }
        this.nameValuePairList.add(new NameValuePair(name, value));
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (NameValuePair pair : this.nameValuePairList) {
            buf.append(' ');
            buf.append(pair.getName());
            buf.append('=');
            buf.append(XMLAttributeList.getQuotedAttributeValue(pair.getValue()));
        }
        return buf.toString();
    }

    public Iterator<NameValuePair> iterator() {
        return this.nameValuePairList.iterator();
    }

    public static String getQuotedAttributeValue(@NonNull String rawValue) {
        if (rawValue == null) {
            throw new NullPointerException("rawValue must be nonnull");
        }
        StringBuffer buf = new StringBuffer();
        buf.append('\"');
        new StringBufferQuoteMetaCharacters(rawValue, attrMetaCharacterMap, buf).process();
        buf.append('\"');
        return buf.toString();
    }

    static {
        attrMetaCharacterMap.addMeta('<', "&lt;");
        attrMetaCharacterMap.addMeta('>', "&gt;");
        attrMetaCharacterMap.addMeta('&', "&amp;");
        attrMetaCharacterMap.addMeta('\"', "&quot;");
    }

    private static class StringBufferQuoteMetaCharacters
    extends QuoteMetaCharacters {
        private StringBuffer buf;

        public StringBufferQuoteMetaCharacters(String text, MetaCharacterMap map, StringBuffer buf) {
            super(text, map);
            this.buf = buf;
        }

        public void process() {
            try {
                super.process();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void emitLiteral(String s) {
            this.buf.append(s);
        }
    }

    public static class NameValuePair {
        private String name;
        private String value;

        public NameValuePair(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }
    }
}

