/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;

public class ValueNumberFactory {
    private ArrayList<ValueNumber> allocatedValueList = new ArrayList();

    public ValueNumber createFreshValue() {
        ValueNumber result = new ValueNumber(this.getNumValuesAllocated());
        this.allocatedValueList.add(result);
        return result;
    }

    public ValueNumber forNumber(int number) {
        if (number >= this.getNumValuesAllocated()) {
            throw new IllegalArgumentException("Value " + number + " has not been allocated");
        }
        return this.allocatedValueList.get(number);
    }

    public int getNumValuesAllocated() {
        return this.allocatedValueList.size();
    }

    public void compact(int[] map, int numValuesAllocated) {
        ArrayList<ValueNumber> oldList = this.allocatedValueList;
        ArrayList<ValueNumber> newList = new ArrayList<ValueNumber>(Collections.nCopies(numValuesAllocated, null));
        Iterator<ValueNumber> i$ = oldList.iterator();
        while (i$.hasNext()) {
            ValueNumber value = i$.next();
            int newNumber = map[value.getNumber()];
            if (newNumber < 0) continue;
            value.number = newNumber;
            newList.set(newNumber, value);
        }
        this.allocatedValueList = newList;
    }
}

