/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.vna.LoadedFieldSet;
import edu.umd.cs.findbugs.ba.vna.MergeTree;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberCache;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFactory;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrameModelingVisitor;
import java.util.BitSet;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueNumberAnalysis
extends FrameDataflowAnalysis<ValueNumber, ValueNumberFrame> {
    public static final boolean DEBUG = SystemProperties.getBoolean("vna.debug");
    private MethodGen methodGen;
    private ValueNumberFactory factory;
    private ValueNumberFrameModelingVisitor visitor;
    private ValueNumber[] entryLocalValueList;
    private IdentityHashMap<BasicBlock, ValueNumber> exceptionHandlerValueNumberMap;
    private ValueNumber thisValue;
    private HashMap<Location, ValueNumberFrame> factAtLocationMap;
    private HashMap<Location, ValueNumberFrame> factAfterLocationMap;
    private MergeTree mergeTree;

    public ValueNumberAnalysis(MethodGen methodGen, DepthFirstSearch dfs, LoadedFieldSet loadedFieldSet, RepositoryLookupFailureCallback lookupFailureCallback) {
        super(dfs);
        this.methodGen = methodGen;
        this.factory = new ValueNumberFactory();
        ValueNumberCache cache = new ValueNumberCache();
        this.visitor = new ValueNumberFrameModelingVisitor(methodGen, this.factory, cache, loadedFieldSet, lookupFailureCallback);
        int numLocals = methodGen.getMaxLocals();
        this.entryLocalValueList = new ValueNumber[numLocals];
        for (int i = 0; i < numLocals; ++i) {
            this.entryLocalValueList[i] = this.factory.createFreshValue();
        }
        this.exceptionHandlerValueNumberMap = new IdentityHashMap();
        if (!methodGen.isStatic()) {
            this.thisValue = this.entryLocalValueList[0];
        }
        this.factAtLocationMap = new HashMap();
        this.factAfterLocationMap = new HashMap();
        if (DEBUG) {
            System.out.println(new StringBuffer().append("VNA Analysis ").append(methodGen.getClassName()).append(".").append(methodGen.getName()).append(" : ").append(methodGen.getSignature()).toString());
        }
    }

    public ValueNumber getClassObjectValue(String className) {
        return this.visitor.getClassObjectValue(className);
    }

    public void setMergeTree(MergeTree mergeTree) {
        this.mergeTree = mergeTree;
    }

    public MergeTree getMergeTree() {
        return this.mergeTree;
    }

    public ValueNumberFactory getFactory() {
        return this.factory;
    }

    public int getNumValuesAllocated() {
        return this.factory.getNumValuesAllocated();
    }

    public boolean isThisValue(ValueNumber value) {
        return this.thisValue != null && this.thisValue.getNumber() == value.getNumber();
    }

    public ValueNumber getThisValue() {
        return this.thisValue;
    }

    public ValueNumber getEntryValue(int local) {
        return this.entryLocalValueList[local];
    }

    @Override
    public ValueNumberFrame createFact() {
        return new ValueNumberFrame(this.methodGen.getMaxLocals());
    }

    @Override
    public void initEntryFact(ValueNumberFrame result) {
        result.setValid();
        int numSlots = result.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            result.setValue(i, this.entryLocalValueList[i]);
        }
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, ValueNumberFrame fact) throws DataflowAnalysisException {
        Location location = new Location(handle, basicBlock);
        ValueNumberFrame atLocation = this.getFactAtLocation(location);
        this.copy(fact, atLocation);
        this.visitor.setFrameAndLocation(fact, new Location(handle, basicBlock));
        this.visitor.setHandle(handle);
        this.visitor.analyzeInstruction(handle.getInstruction());
        ValueNumberFrame afterLocation = this.getFactAfterLocation(location);
        this.copy(fact, afterLocation);
    }

    @Override
    public void meetInto(ValueNumberFrame fact, Edge edge, ValueNumberFrame result) throws DataflowAnalysisException {
        if (((BasicBlock)edge.getTarget()).isExceptionHandler() && fact.isValid()) {
            BasicBlock handlerBlock = (BasicBlock)edge.getTarget();
            ValueNumber exceptionValueNumber = this.getExceptionValueNumber(handlerBlock);
            ValueNumberFrame tmpFact = this.createFact();
            tmpFact.copyFrom(fact);
            tmpFact.clearStack();
            tmpFact.pushValue(exceptionValueNumber);
            fact = tmpFact;
        }
        this.mergeInto(fact, result);
    }

    @Override
    protected void mergeInto(ValueNumberFrame frame, ValueNumberFrame result) throws DataflowAnalysisException {
        result.mergeAvailableLoadSets(frame, this.factory, this.mergeTree);
        super.mergeInto(frame, result);
    }

    @Override
    protected void mergeValues(ValueNumberFrame otherFrame, ValueNumberFrame resultFrame, int slot) throws DataflowAnalysisException {
        ValueNumber value = this.mergeValues(resultFrame, slot, (ValueNumber)resultFrame.getValue(slot), (ValueNumber)otherFrame.getValue(slot));
        resultFrame.setValue(slot, value);
    }

    private ValueNumber mergeValues(ValueNumberFrame frame, int slot, ValueNumber mine, ValueNumber other) throws DataflowAnalysisException {
        if (mine != frame.getValue(slot)) {
            throw new IllegalStateException();
        }
        if (mine.equals(other)) {
            return mine;
        }
        ValueNumber mergedValue = frame.getMergedValue(slot);
        if (mergedValue == null) {
            mergedValue = this.factory.createFreshValue();
            mergedValue.setFlags(mine.getFlags() | other.getFlags() | 8);
            frame.setMergedValue(slot, mergedValue);
        }
        if (this.mergeTree != null) {
            this.mergeTree.mapInputToOutput(mine, mergedValue);
            this.mergeTree.mapInputToOutput(other, mergedValue);
        }
        return mergedValue;
    }

    @Override
    public ValueNumberFrame getFactAtLocation(Location location) {
        ValueNumberFrame fact = this.factAtLocationMap.get(location);
        if (fact == null) {
            fact = this.createFact();
            this.makeFactTop(fact);
            this.factAtLocationMap.put(location, fact);
        }
        return fact;
    }

    @Override
    public ValueNumberFrame getFactAfterLocation(Location location) {
        ValueNumberFrame fact = this.factAfterLocationMap.get(location);
        if (fact == null) {
            fact = this.createFact();
            this.makeFactTop(fact);
            this.factAfterLocationMap.put(location, fact);
        }
        return fact;
    }

    public Iterator<ValueNumberFrame> factIterator() {
        return this.factAtLocationMap.values().iterator();
    }

    public void compactValueNumbers(Dataflow<ValueNumberFrame, ValueNumberAnalysis> dataflow) {
        ValueNumberFrame frame;
        ValueCompacter compacter = new ValueCompacter(this.factory.getNumValuesAllocated());
        Iterator<ValueNumberFrame> i = this.factIterator();
        while (i.hasNext()) {
            frame = i.next();
            ValueNumberAnalysis.markFrameValues(frame, compacter);
        }
        i = this.resultFactIterator();
        while (i.hasNext()) {
            frame = i.next();
            ValueNumberAnalysis.markFrameValues(frame, compacter);
        }
        int before = this.factory.getNumValuesAllocated();
        this.factory.compact(compacter.discovered, compacter.numValuesUsed);
        int after = this.factory.getNumValuesAllocated();
        if (DEBUG && after < before && before > 0) {
            System.out.println(new StringBuffer().append("Value compaction: ").append(after).append("/").append(before).append(" (").append(after * 100 / before).append("%)").toString());
        }
    }

    private static void markFrameValues(ValueNumberFrame frame, ValueCompacter compacter) {
        if (!frame.isValid()) {
            return;
        }
        for (int j = 0; j < frame.getNumSlots(); ++j) {
            ValueNumber value = (ValueNumber)frame.getValue(j);
            int number = value.getNumber();
            if (compacter.isUsed(number)) continue;
            compacter.discovered[number] = compacter.allocateValue();
            compacter.setUsed(number);
        }
    }

    public static void main(String[] argv) {
        try {
            if (argv.length != 1) {
                System.out.println("Usage: edu.umd.cs.findbugs.ba.ValueNumberAnalysis <filename>");
                System.exit(1);
            }
            DataflowTestDriver<ValueNumberFrame, ValueNumberAnalysis> driver = new DataflowTestDriver<ValueNumberFrame, ValueNumberAnalysis>(){

                @Override
                public Dataflow<ValueNumberFrame, ValueNumberAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                    return classContext.getValueNumberDataflow(method);
                }
            };
            driver.execute(argv[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ValueNumber getExceptionValueNumber(BasicBlock handlerBlock) {
        ValueNumber valueNumber = this.exceptionHandlerValueNumberMap.get(handlerBlock);
        if (valueNumber == null) {
            valueNumber = this.factory.createFreshValue();
            this.exceptionHandlerValueNumberMap.put(handlerBlock, valueNumber);
        }
        return valueNumber;
    }

    @Override
    protected /* synthetic */ void mergeValues(Frame x0, Frame x1, int x2) throws DataflowAnalysisException {
        this.mergeValues((ValueNumberFrame)x0, (ValueNumberFrame)x1, x2);
    }

    @Override
    protected /* synthetic */ void mergeInto(Frame x0, Frame x1) throws DataflowAnalysisException {
        this.mergeInto((ValueNumberFrame)x0, (ValueNumberFrame)x1);
    }

    @Override
    public /* synthetic */ Object getFactAfterLocation(Location x0) throws DataflowAnalysisException {
        return this.getFactAfterLocation(x0);
    }

    @Override
    public /* synthetic */ Object getFactAtLocation(Location x0) throws DataflowAnalysisException {
        return this.getFactAtLocation(x0);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (ValueNumberFrame)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((ValueNumberFrame)x0, x1, (ValueNumberFrame)x2);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((ValueNumberFrame)x0);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    private static class ValueCompacter {
        public final BitSet valuesUsed = new BitSet();
        public int numValuesUsed = 0;
        public final int[] discovered;

        public ValueCompacter(int origNumValuesAllocated) {
            this.discovered = new int[origNumValuesAllocated];
            for (int i = 0; i < this.discovered.length; ++i) {
                this.discovered[i] = -1;
            }
        }

        public boolean isUsed(int number) {
            return this.valuesUsed.get(number);
        }

        public void setUsed(int number) {
            this.valuesUsed.set(number, true);
        }

        public int allocateValue() {
            return this.numValuesUsed++;
        }
    }
}

