/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AnnotationRetentionDatabase;
import edu.umd.cs.findbugs.ba.CheckReturnAnnotationDatabase;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.InnerClassAccessMap;
import edu.umd.cs.findbugs.ba.JCIPAnnotationDatabase;
import edu.umd.cs.findbugs.ba.NullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.RepositoryLookupFailureCallback;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.ba.SourceInfoMap;
import edu.umd.cs.findbugs.ba.URLClassPathRepository;
import edu.umd.cs.findbugs.ba.ch.Subtypes;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.ReturnValueNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.type.FieldStoreTypeDatabase;
import edu.umd.cs.findbugs.util.MapCache;
import java.io.IOException;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.Repository;

public class LegacyAnalysisContext
extends AnalysisContext {
    private RepositoryLookupFailureCallback lookupFailureCallback;
    private SourceFinder sourceFinder;
    private MapCache<JavaClass, ClassContext> classContextCache;
    private Subtypes subtypes;
    private final SourceInfoMap sourceInfoMap;
    private InnerClassAccessMap innerClassAccessMap;
    private FieldStoreTypeDatabase fieldStoreTypeDatabase;
    private ParameterNullnessPropertyDatabase unconditionalDerefParamDatabase;
    private ReturnValueNullnessPropertyDatabase returnValueNullnessDatabase;
    private NullnessAnnotationDatabase nullnessAnnotationDatabase;
    private CheckReturnAnnotationDatabase checkReturnAnnotationDatabase;
    private AnnotationRetentionDatabase annotationRetentionDatabase;
    private JCIPAnnotationDatabase jcipAnnotationDatabase;
    private static final Repository originalRepository = org.apache.bcel.Repository.getRepository();
    private static final int DEFAULT_CACHE_SIZE = 6;
    int hits = 0;
    int misses = 0;

    public NullnessAnnotationDatabase getNullnessAnnotationDatabase() {
        return this.nullnessAnnotationDatabase;
    }

    public CheckReturnAnnotationDatabase getCheckReturnAnnotationDatabase() {
        return this.checkReturnAnnotationDatabase;
    }

    public AnnotationRetentionDatabase getAnnotationRetentionDatabase() {
        return this.annotationRetentionDatabase;
    }

    public JCIPAnnotationDatabase getJCIPAnnotationDatabase() {
        return this.jcipAnnotationDatabase;
    }

    LegacyAnalysisContext(RepositoryLookupFailureCallback lookupFailureCallback) {
        this.lookupFailureCallback = lookupFailureCallback;
        this.sourceFinder = new SourceFinder();
        this.subtypes = new Subtypes();
        this.sourceInfoMap = new SourceInfoMap();
        if (originalRepository instanceof URLClassPathRepository) {
            this.getLookupFailureCallback().logError("originalRepository is a URLClassPathRepository, which may cause problems");
        }
    }

    public void initDatabases() {
        this.checkReturnAnnotationDatabase = new CheckReturnAnnotationDatabase();
        this.annotationRetentionDatabase = new AnnotationRetentionDatabase();
        this.jcipAnnotationDatabase = new JCIPAnnotationDatabase();
        this.nullnessAnnotationDatabase = new NullnessAnnotationDatabase();
    }

    public void updateDatabases(int pass) {
        if (pass == 0) {
            this.checkReturnAnnotationDatabase.loadAuxiliaryAnnotations();
            this.nullnessAnnotationDatabase.loadAuxiliaryAnnotations();
        }
    }

    public RepositoryLookupFailureCallback getLookupFailureCallback() {
        return this.lookupFailureCallback;
    }

    public SourceFinder getSourceFinder() {
        return this.sourceFinder;
    }

    public Subtypes getSubtypes() {
        return this.subtypes;
    }

    public void clearRepository() {
        Repository repos = org.apache.bcel.Repository.getRepository();
        if (repos instanceof URLClassPathRepository) {
            ((URLClassPathRepository)repos).destroy();
        }
        org.apache.bcel.Repository.clearCache();
        this.clearClassContextCache();
        this.getInnerClassAccessMap().clearCache();
        URLClassPathRepository repository = new URLClassPathRepository();
        org.apache.bcel.Repository.setRepository(repository);
    }

    public void clearClassContextCache() {
        if (this.classContextCache != null) {
            this.classContextCache.clear();
        }
    }

    public void addClasspathEntry(String url) throws IOException {
        URLClassPathRepository repos = (URLClassPathRepository)org.apache.bcel.Repository.getRepository();
        repos.addURL(url);
    }

    public void addApplicationClassToRepository(JavaClass appClass) {
        org.apache.bcel.Repository.addClass(appClass);
        this.subtypes.addApplicationClass(appClass);
    }

    public JavaClass lookupClass(@NonNull String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("className is null");
        }
        return org.apache.bcel.Repository.lookupClass(className);
    }

    public ClassContext getClassContext(JavaClass javaClass) {
        ClassContext classContext;
        if (this.classContextCache == null) {
            int cacheSize = this.getBoolProperty(1) ? 3 : 6;
            this.classContextCache = new MapCache(cacheSize);
        }
        if ((classContext = this.classContextCache.get(javaClass)) == null) {
            classContext = new ClassContext(javaClass, this);
            this.classContextCache.put(javaClass, classContext);
            ++this.misses;
        } else {
            ++this.hits;
        }
        return classContext;
    }

    public String getClassContextStats() {
        if (this.classContextCache == null) {
            return null;
        }
        return this.hits + "/" + this.misses + ":" + this.classContextCache.getStatistics();
    }

    public SourceInfoMap getSourceInfoMap() {
        return this.sourceInfoMap;
    }

    public FieldStoreTypeDatabase getFieldStoreTypeDatabase() {
        if (this.fieldStoreTypeDatabase == null) {
            this.fieldStoreTypeDatabase = new FieldStoreTypeDatabase();
        }
        return this.fieldStoreTypeDatabase;
    }

    public ParameterNullnessPropertyDatabase getUnconditionalDerefParamDatabase() {
        if (this.unconditionalDerefParamDatabase == null) {
            this.unconditionalDerefParamDatabase = new ParameterNullnessPropertyDatabase();
        }
        return this.unconditionalDerefParamDatabase;
    }

    public InnerClassAccessMap getInnerClassAccessMap() {
        if (this.innerClassAccessMap == null) {
            this.innerClassAccessMap = InnerClassAccessMap.create();
        }
        return this.innerClassAccessMap;
    }

    public ReturnValueNullnessPropertyDatabase getReturnValueNullnessPropertyDatabase() {
        if (this.returnValueNullnessDatabase == null) {
            this.returnValueNullnessDatabase = new ReturnValueNullnessPropertyDatabase();
        }
        return this.returnValueNullnessDatabase;
    }
}

