/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.detect.FindUnreleasedLock;
import edu.umd.cs.findbugs.visitclass.AnnotationVisitor;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.util.Map;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Visitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NoteJCIPAnnotation
extends AnnotationVisitor
implements Detector,
NonReportingDetector {
    private static final String NET_JCIP_ANNOTATIONS = "net.jcip.annotations.";

    public NoteJCIPAnnotation(BugReporter bugReporter) {
    }

    public void visitAnnotation(String annotationClass, Map<String, Object> map, boolean runtimeVisible) {
        XField member;
        if (!annotationClass.startsWith(NET_JCIP_ANNOTATIONS)) {
            return;
        }
        annotationClass = annotationClass.substring(NET_JCIP_ANNOTATIONS.length());
        Object value = map.get("value");
        if (this.visitingField()) {
            member = XFactory.createXField((PreorderVisitor)this);
        } else if (this.visitingMethod()) {
            member = XFactory.createXMethod((PreorderVisitor)this);
        } else {
            Map annotationsOfThisClass = AnalysisContext.currentAnalysisContext().getJCIPAnnotationDatabase().getEntryForClass(this.getDottedClassName());
            annotationsOfThisClass.put(annotationClass, value);
            return;
        }
        Map annotationsOfThisMember = AnalysisContext.currentAnalysisContext().getJCIPAnnotationDatabase().getEntryForClassMember((ClassMember)member);
        annotationsOfThisMember.put(annotationClass, value);
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (!FindUnreleasedLock.preTiger(javaClass)) {
            javaClass.accept((Visitor)this);
        }
    }

    public void report() {
    }
}

