/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.ClassMember;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessProperty;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class FindBadEqualsImplementation
implements Detector {
    private BugReporter bugReporter;
    private ParameterNullnessPropertyDatabase database;
    private boolean checkedDatabase;

    public FindBadEqualsImplementation(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        Method[] methodList;
        if (!this.checkedDatabase) {
            this.database = AnalysisContext.currentAnalysisContext().getUnconditionalDerefParamDatabase();
            this.checkedDatabase = true;
        }
        if (this.database == null) {
            return;
        }
        JavaClass javaClass = classContext.getJavaClass();
        Method[] arr$ = methodList = javaClass.getMethods();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            XMethod xmethod;
            ParameterNullnessProperty property;
            Method method = arr$[i$];
            if (!this.isEqualsMethod(method) || (property = (ParameterNullnessProperty)this.database.getProperty((ClassMember)(xmethod = XFactory.createXMethod((JavaClass)javaClass, (Method)method)))) == null || !property.isNonNull(0)) continue;
            BugInstance warning = new BugInstance((Detector)this, "NP_DOES_NOT_HANDLE_NULL", 2).addClassAndMethod(javaClass, method);
            this.bugReporter.reportBug(warning);
        }
    }

    private boolean isEqualsMethod(Method method) {
        return method.getName().equals("equals") && method.getSignature().equals("(Ljava/lang/Object;)Z") && !method.isStatic();
    }

    public void report() {
    }

    public static void main(String[] args) {
    }
}

