/*
 * Decompiled with CFR 0.152.
 */
package org.epic.perleditor.templates.textmanipulation;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.util.Assert;
import org.epic.perleditor.PerlEditorPlugin;
import org.epic.perleditor.templates.textmanipulation.TextBufferFactory;
import org.epic.perleditor.templates.textmanipulation.TextManipulationMessages;
import org.epic.perleditor.templates.textmanipulation.TextRange;
import org.epic.perleditor.templates.textmanipulation.TextRegion;
import org.epic.perleditor.templates.util.Strings;

public class TextBuffer {
    private IDocument fDocument;
    private static final TextBufferFactory fgFactory = new TextBufferFactory();

    TextBuffer(IDocument document) {
        this.fDocument = document;
        Assert.isNotNull((Object)this.fDocument);
    }

    public int getLength() {
        return this.fDocument.getLength();
    }

    public int getNumberOfLines() {
        return this.fDocument.getNumberOfLines();
    }

    public char getChar(int offset) {
        try {
            return this.fDocument.getChar(offset);
        }
        catch (BadLocationException e) {
            throw new ArrayIndexOutOfBoundsException(e.getMessage());
        }
    }

    public String getContent() {
        return this.fDocument.get();
    }

    public String getContent(int start, int length) {
        try {
            return this.fDocument.get(start, length);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public Block getBlockContent(int start, int length, int tabWidth) {
        int lineNumber;
        int end;
        TextRegion region;
        Block result = new Block();
        StringBuffer buffer = new StringBuffer();
        int lineOffset = this.getLineInformationOfOffset(start).getOffset();
        if (start > lineOffset) {
            String line = this.getContent(lineOffset, start - lineOffset);
            String indent = Strings.getIndentString(line, tabWidth);
            result.offsetDelta = -indent.length();
            buffer.append(indent);
        }
        if ((lineOffset = (region = this.getLineInformationOfOffset(end = start + length)).getOffset()) == end && (lineNumber = this.getLineOfOffset(lineOffset)) > 0) {
            length -= this.getLineDelimiter(lineNumber - 1).length();
        }
        if (buffer.length() == 0) {
            result.content = this.getContent(start, length);
        } else {
            buffer.append(this.getContent(start, length));
            result.content = buffer.toString();
        }
        return result;
    }

    public String getLineDelimiter() {
        String lineDelimiter = this.getLineDelimiter(0);
        if (lineDelimiter == null) {
            lineDelimiter = System.getProperty("line.separator", "\n");
        }
        return lineDelimiter;
    }

    public String getLineDelimiter(int line) {
        try {
            return this.fDocument.getLineDelimiter(line);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String getLineContent(int line) {
        try {
            IRegion region = this.fDocument.getLineInformation(line);
            return this.fDocument.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getLineIndent(int lineNumber, int tabWidth) {
        return Strings.computeIndent(this.getLineContent(lineNumber), tabWidth);
    }

    public TextRegion getLineInformation(int line) {
        try {
            return new DocumentRegion(this.fDocument.getLineInformation(line));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public TextRegion getLineInformationOfOffset(int offset) {
        try {
            return new DocumentRegion(this.fDocument.getLineInformationOfOffset(offset));
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public int getLineOfOffset(int offset) {
        try {
            return this.fDocument.getLineOfOffset(offset);
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public String getLineContentOfOffset(int offset) {
        try {
            IRegion region = this.fDocument.getLineInformationOfOffset(offset);
            return this.fDocument.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public String[] convertIntoLines(int offset, int length, boolean lastNewLineCreateEmptyLine) {
        try {
            String text = this.fDocument.get(offset, length);
            DefaultLineTracker tracker = new DefaultLineTracker();
            tracker.set(text);
            int size = tracker.getNumberOfLines();
            int lastLine = size - 1;
            ArrayList<String> result = new ArrayList<String>(size);
            int i = 0;
            while (i < size) {
                IRegion region = tracker.getLineInformation(i);
                String line = this.getContent(offset + region.getOffset(), region.getLength());
                if (i < lastLine || !"".equals(line) || lastNewLineCreateEmptyLine) {
                    result.add(line);
                }
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public void replace(int offset, int length, String text) throws CoreException {
        try {
            this.fDocument.replace(offset, length, text);
        }
        catch (BadLocationException e) {
            Status s = new Status(4, PerlEditorPlugin.getPluginId(), 1, TextManipulationMessages.getFormattedString("TextBuffer.wrongRange", new Object[]{new Integer(offset), new Integer(length)}), (Throwable)e);
            throw new CoreException((IStatus)s);
        }
    }

    public void replace(TextRange range, String text) throws CoreException {
        this.replace(range.fOffset, range.fLength, text);
    }

    void release() {
    }

    void registerUpdater(IDocumentListener listener) {
        this.fDocument.addDocumentListener(listener);
    }

    void unregisterUpdater(IDocumentListener listener) {
        this.fDocument.removeDocumentListener(listener);
    }

    public static TextBuffer acquire(IFile file) throws CoreException {
        return fgFactory.acquire(file);
    }

    public static void release(TextBuffer buffer) {
        fgFactory.release(buffer);
    }

    public static void commitChanges(TextBuffer buffer, boolean force, IProgressMonitor pm) throws CoreException {
        fgFactory.commitChanges(buffer, force, pm);
    }

    public static TextBuffer create(IFile file) throws CoreException {
        return fgFactory.create(file);
    }

    public static TextBuffer create(String content) {
        return fgFactory.create(content);
    }

    public static void save(TextBuffer buffer, IProgressMonitor pm) throws CoreException {
        fgFactory.save(buffer, pm);
    }

    public static void aboutToChange(TextBuffer buffer) throws CoreException {
        fgFactory.aboutToChange(buffer);
    }

    public static void changed(TextBuffer buffer) throws CoreException {
        fgFactory.changed(buffer);
    }

    private static class DocumentRegion
    extends TextRegion {
        IRegion fRegion;

        public DocumentRegion(IRegion region) {
            this.fRegion = region;
        }

        public int getOffset() {
            return this.fRegion.getOffset();
        }

        public int getLength() {
            return this.fRegion.getLength();
        }
    }

    public class Block {
        public String content;
        public int offsetDelta;
    }
}

