#
# Tcl Library for tkCVS
#
 
# 
# $Id: tag.tcl,v 1.5 1995/08/19 11:47:31 del Exp $
#
# Set up a small tag dialog.
#

proc tag_setup {} {

  toplevel .tag
  frame .tag.left
  frame .tag.right
  frame .tag.down -relief groove -border 2

  pack .tag.down -side bottom -fill x
  pack .tag.left -side left -fill y
  pack .tag.right -side left -fill both -expand 1

  label .tag.lname -text "Tag Name" -anchor w

  entry .tag.tname -relief sunken -textvariable tagname

  # bind_motifentry .tag.tname

  pack .tag.lname -in .tag.left \
    -side top -fill x -pady 3
 
  pack .tag.tname -in .tag.right \
    -side top -fill x -pady 3
 
  button .tag.tag -text "Tag" \
    -command {
      eval "cvs_tag $tagname no [workdir_list_marked_files]"
      wm withdraw .tag
    }
  button .tag.branchtag -text "Branch Tag" \
    -command {
      eval "cvs_tag $tagname yes [workdir_list_marked_files]"
      wm withdraw .tag
    }
  button .tag.quit -text "Quit" -command { wm withdraw .tag }
 
  pack .tag.tag .tag.branchtag .tag.quit -in .tag.down -side left \
    -ipadx 2 -ipady 2 -padx 4 -pady 4 -fill both -expand 1
 
  wm withdraw .tag
  wm title .tag "Tag a Module"
  wm minsize .tag 1 1
}

proc tag_run {} {
  global incvs
  global cvscfg

  if {$cvscfg(cvsver) < 1.3} {
    cvserror "This function is not supported in CVS version $cvscfg(cvsver).
 
Please upgrade your CVS to version 1.3"
    return
  }

  if {! $incvs} {
    cvserror "This directory is not in CVS.\nPlease import it first."
    return 1
  }

  wm deiconify .tag
}
