// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_AUDIOFORMAT_H
#define _GSTREAMERMM_AUDIOFORMAT_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-2009 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/audio/audio-format.h>


namespace Gst
{

  /** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var AudioFormat AUDIO_FORMAT_UNKNOWN
 *  unknown or unset audio format.
 * 
 *  @var AudioFormat AUDIO_FORMAT_ENCODED
 *  encoded audio format.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S8
 *  8 bits in 8 bits, signed.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U8
 *  8 bits in 8 bits, unsigned.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S16LE
 *  16 bits in 16 bits, signed, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S16BE
 *  16 bits in 16 bits, signed, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U16LE
 *  16 bits in 16 bits, unsigned, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U16BE
 *  16 bits in 16 bits, unsigned, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S24_32LE
 *  24 bits in 32 bits, signed, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S24_32BE
 *  24 bits in 32 bits, signed, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U24_32LE
 *  24 bits in 32 bits, unsigned, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U24_32BE
 *  24 bits in 32 bits, unsigned, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S32LE
 *  32 bits in 32 bits, signed, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S32BE
 *  32 bits in 32 bits, signed, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U32LE
 *  32 bits in 32 bits, unsigned, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U32BE
 *  32 bits in 32 bits, unsigned, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S24LE
 *  24 bits in 24 bits, signed, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S24BE
 *  24 bits in 24 bits, signed, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U24LE
 *  24 bits in 24 bits, unsigned, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U24BE
 *  24 bits in 24 bits, unsigned, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S20LE
 *  20 bits in 24 bits, signed, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S20BE
 *  20 bits in 24 bits, signed, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U20LE
 *  20 bits in 24 bits, unsigned, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U20BE
 *  20 bits in 24 bits, unsigned, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S18LE
 *  18 bits in 24 bits, signed, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S18BE
 *  18 bits in 24 bits, signed, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U18LE
 *  18 bits in 24 bits, unsigned, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U18BE
 *  18 bits in 24 bits, unsigned, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_F32LE
 *  32-bit floating point samples, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_F32BE
 *  32-bit floating point samples, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_F64LE
 *  64-bit floating point samples, little endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_F64BE
 *  64-bit floating point samples, big endian.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S16
 *  16 bits in 16 bits, signed, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U16
 *  16 bits in 16 bits, unsigned, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S24_32
 *  24 bits in 32 bits, signed, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U24_32
 *  24 bits in 32 bits, unsigned, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S32
 *  32 bits in 32 bits, signed, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U32
 *  32 bits in 32 bits, unsigned, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S24
 *  24 bits in 24 bits, signed, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U24
 *  24 bits in 24 bits, unsigned, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S20
 *  20 bits in 24 bits, signed, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U20
 *  20 bits in 24 bits, unsigned, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_S18
 *  18 bits in 24 bits, signed, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_U18
 *  18 bits in 24 bits, unsigned, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_F32
 *  32-bit floating point samples, native endianness.
 * 
 *  @var AudioFormat AUDIO_FORMAT_F64
 *  64-bit floating point samples, native endianness.
 * 
 *  @enum AudioFormat
 * 
 * Enum value describing the most common audio formats.
 * @ingroup gstreamermmEnums
 */
enum AudioFormat
{
  AUDIO_FORMAT_UNKNOWN = 0,
  AUDIO_FORMAT_ENCODED = 1,
  AUDIO_FORMAT_S8 = 2,
  AUDIO_FORMAT_U8 = 3,
  AUDIO_FORMAT_S16LE = 4,
  AUDIO_FORMAT_S16BE = 5,
  AUDIO_FORMAT_U16LE = 6,
  AUDIO_FORMAT_U16BE = 7,
  AUDIO_FORMAT_S24_32LE = 8,
  AUDIO_FORMAT_S24_32BE = 9,
  AUDIO_FORMAT_U24_32LE = 10,
  AUDIO_FORMAT_U24_32BE = 11,
  AUDIO_FORMAT_S32LE = 12,
  AUDIO_FORMAT_S32BE = 13,
  AUDIO_FORMAT_U32LE = 14,
  AUDIO_FORMAT_U32BE = 15,
  AUDIO_FORMAT_S24LE = 16,
  AUDIO_FORMAT_S24BE = 17,
  AUDIO_FORMAT_U24LE = 18,
  AUDIO_FORMAT_U24BE = 19,
  AUDIO_FORMAT_S20LE = 20,
  AUDIO_FORMAT_S20BE = 21,
  AUDIO_FORMAT_U20LE = 22,
  AUDIO_FORMAT_U20BE = 23,
  AUDIO_FORMAT_S18LE = 24,
  AUDIO_FORMAT_S18BE = 25,
  AUDIO_FORMAT_U18LE = 26,
  AUDIO_FORMAT_U18BE = 27,
  AUDIO_FORMAT_F32LE = 28,
  AUDIO_FORMAT_F32BE = 29,
  AUDIO_FORMAT_F64LE = 30,
  AUDIO_FORMAT_F64BE = 31,
  AUDIO_FORMAT_S16 = _GST_AUDIO_FORMAT_NE(S16),
  AUDIO_FORMAT_U16 = _GST_AUDIO_FORMAT_NE(U16),
  AUDIO_FORMAT_S24_32 = _GST_AUDIO_FORMAT_NE(S24_32),
  AUDIO_FORMAT_U24_32 = _GST_AUDIO_FORMAT_NE(U24_32),
  AUDIO_FORMAT_S32 = _GST_AUDIO_FORMAT_NE(S32),
  AUDIO_FORMAT_U32 = _GST_AUDIO_FORMAT_NE(U32),
  AUDIO_FORMAT_S24 = _GST_AUDIO_FORMAT_NE(S24),
  AUDIO_FORMAT_U24 = _GST_AUDIO_FORMAT_NE(U24),
  AUDIO_FORMAT_S20 = _GST_AUDIO_FORMAT_NE(S20),
  AUDIO_FORMAT_U20 = _GST_AUDIO_FORMAT_NE(U20),
  AUDIO_FORMAT_S18 = _GST_AUDIO_FORMAT_NE(S18),
  AUDIO_FORMAT_U18 = _GST_AUDIO_FORMAT_NE(U18),
  AUDIO_FORMAT_F32 = _GST_AUDIO_FORMAT_NE(F32),
  AUDIO_FORMAT_F64 = _GST_AUDIO_FORMAT_NE(F64)
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::AudioFormat> : public Glib::Value_Enum<Gst::AudioFormat>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

  /** 
 *  @var AudioFormatFlags AUDIO_FORMAT_FLAG_INTEGER
 *  integer samples.
 * 
 *  @var AudioFormatFlags AUDIO_FORMAT_FLAG_FLOAT
 *  float samples.
 * 
 *  @var AudioFormatFlags AUDIO_FORMAT_FLAG_SIGNED
 *  signed samples.
 * 
 *  @var AudioFormatFlags AUDIO_FORMAT_FLAG_COMPLEX
 *  complex layout.
 * 
 *  @var AudioFormatFlags AUDIO_FORMAT_FLAG_UNPACK
 *  the format can be used inGst::AudioFormatUnpack and Gst::AudioFormatPack functions.
 * 
 *  @enum AudioFormatFlags
 * 
 * The different audio flags that a format info can have.
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%AudioFormatFlags operator|(AudioFormatFlags, AudioFormatFlags)</tt><br>
 * <tt>%AudioFormatFlags operator&(AudioFormatFlags, AudioFormatFlags)</tt><br>
 * <tt>%AudioFormatFlags operator^(AudioFormatFlags, AudioFormatFlags)</tt><br>
 * <tt>%AudioFormatFlags operator~(AudioFormatFlags)</tt><br>
 * <tt>%AudioFormatFlags& operator|=(AudioFormatFlags&, AudioFormatFlags)</tt><br>
 * <tt>%AudioFormatFlags& operator&=(AudioFormatFlags&, AudioFormatFlags)</tt><br>
 * <tt>%AudioFormatFlags& operator^=(AudioFormatFlags&, AudioFormatFlags)</tt><br>
 */
enum AudioFormatFlags
{
  AUDIO_FORMAT_FLAG_INTEGER = (1 << 0),
  AUDIO_FORMAT_FLAG_FLOAT = (1 << 1),
  AUDIO_FORMAT_FLAG_SIGNED = (1 << 2),
  AUDIO_FORMAT_FLAG_COMPLEX = (1 << 4),
  AUDIO_FORMAT_FLAG_UNPACK = (1 << 5)
};

/** @ingroup gstreamermmEnums */
inline AudioFormatFlags operator|(AudioFormatFlags lhs, AudioFormatFlags rhs)
  { return static_cast<AudioFormatFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline AudioFormatFlags operator&(AudioFormatFlags lhs, AudioFormatFlags rhs)
  { return static_cast<AudioFormatFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline AudioFormatFlags operator^(AudioFormatFlags lhs, AudioFormatFlags rhs)
  { return static_cast<AudioFormatFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline AudioFormatFlags operator~(AudioFormatFlags flags)
  { return static_cast<AudioFormatFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline AudioFormatFlags& operator|=(AudioFormatFlags& lhs, AudioFormatFlags rhs)
  { return (lhs = static_cast<AudioFormatFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline AudioFormatFlags& operator&=(AudioFormatFlags& lhs, AudioFormatFlags rhs)
  { return (lhs = static_cast<AudioFormatFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline AudioFormatFlags& operator^=(AudioFormatFlags& lhs, AudioFormatFlags rhs)
  { return (lhs = static_cast<AudioFormatFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::AudioFormatFlags> : public Glib::Value_Flags<Gst::AudioFormatFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/**
 * Information for an audio format.
 */
class AudioFormatInfo
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef AudioFormatInfo CppObjectType;
  typedef GstAudioFormatInfo BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

private:

public:
  /**
   * Defualt constructor.
   */
  virtual ~AudioFormatInfo();

  /// Gets the underlying gobject.
  GstAudioFormatInfo* gobj() { return m_info; };

  /// Gets the underlying gobject.
  const GstAudioFormatInfo* gobj() const { return m_info; };

   AudioFormat get_format() const;
 
   void set_format(const AudioFormat& value);
 
   std::string get_name() const;
 
   void set_name(const std::string& value);
 
   std::string get_description() const;
 
   void set_description(const std::string& value);
 
   AudioFormatFlags get_flags() const;
 
   void set_flags(const AudioFormatFlags& value);
 
protected:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  GstAudioFormatInfo* m_info;
  bool take_ownership;
#endif


};
} //namespace Gst


#endif /* _GSTREAMERMM_AUDIOFORMAT_H */

