#!/usr/bin/perl
#  rep-txn-list.pl - Prints a report of the transactions sorted by date
#
#  Written by Curtis Olson.  Started November 12, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: miss-check.pl,v 2.6 1997/04/23 18:06:23 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;    # don't take no guff


my($temp, $cbb_incl_dir);
my($start, $end, $last, $misstart, $misend);
my($date, $check, $desc, $debit, $credit, $cat, $com, $cleared, $total);
my($todate, $fromdate, $trans, $result, $account, $name);
my(%BYCHECK, @account_list, @CHECKS);


# return the directory of a file name (this is duplicated in common.pl
# but we need this to find the include directory for common.pl :-(
sub my_file_dirname {
    my($file) = @_;
    my($pos);

    $pos = rindex($file, "/");
    if ( $pos >= 0 ) {
	return substr($file, 0, ($pos + 1));
    } else { 
	return "./"; 
    }
}

# specify the installed location of the necessary pieces.
$temp = &my_file_dirname($0); chop($temp);
$cbb_incl_dir = &my_file_dirname($temp);
unshift(@INC, $cbb_incl_dir);


require "common.pl";
require "reports.pl";
require "engine.pl";
require "memorized.pl";


($#ARGV >= 0) || 
    die "Usage: report [ -from mm/dd/[yy]yy ] [ -to mm/dd/[yy]yy ] accounts";


# process arguments

($fromdate, $todate, @account_list) = &process_rep_args();

if ( $fromdate eq "all" ) {
    $fromdate = "";
}

if ( $todate eq "all" ) {
    $todate = "";
}

# print "'$fromdate' '$todate' '@account_list'\n";

%BYCHECK = ();

# load all matching transactions from all specified accounts (ignoring
# those that are outside the specified date range)

foreach $account ( @account_list ) {
    $name = &file_basename($account);

    # open the account
    (&load_trans($account) eq "ok") || die "Cannot open account:  $account";

    $result = &first_trans();
    while ( $result ne "none" ) {
	($date, $check, $desc, $debit, $credit, $cat, $com,
	 $cleared, $total) = split(/\t/, $trans);

        if ( (($fromdate == 0) || ($fromdate <= $date)) && 
            (($todate == 0) || ($todate >= $date)) ) {

	    if ( $check ne "" ) {
		if ( defined($BYCHECK{$check}) ) {
		    $BYCHECK{$check} .= "\t$date";
		} else {
		    $BYCHECK{$check} = $date;
		}
	    }
	}

        $result = &next_trans();
    }
}


$last = "";
$start = "";
$end = "";

@CHECKS = (sort (keys %BYCHECK) );

while ( $check = shift(@CHECKS) ) {

    # first check for duplicate check numbers
    if ( $BYCHECK{$check} =~ m/\t/ ) {
	print " *** DUPLICATED CHECK ***  #$check ($BYCHECK{$check})\n";
	print "\n";
    }

    if ( $start eq "" ) {
	$start = $check;
    }

    if ( ($last ne "") && ($check != ($last + 1)) ) {
	# ok, we have a break in the action
	print "Continuous range #$start ($BYCHECK{$start}) - " .
	    "#$last ($BYCHECK{$last})\n\n";

	$misstart = $last + 1;
	$misend = $check - 1;
	if ( $misstart == $misend ) {
	    print " *** MISSING CHECK ***  #$misstart\n\n";
	} else {
	    print " *** MISSING CHECKS ***  #$misstart - #$misend\n\n";
	}
	$start = "";
    }

    $last = $check;
}

if ( $start ne "" ) {
    print "Continuous range #$start ($BYCHECK{$start}) - " .
	"#$last ($BYCHECK{$last})\n\n";
}

 
# ----------------------------------------------------------------------------
# $Log: miss-check.pl,v $
# Revision 2.6  1997/04/23 18:06:23  curt
# Fixed a missing "require"
#
# Revision 2.5  1997/01/28 03:25:49  curt
# Force strict scoping in all perl scripts.
#
# Revision 2.4  1996/12/17 14:54:15  curt
# Updated copyright date.
#
# Revision 2.3  1996/12/13 01:25:53  curt
# Modified paths.  Updated to work with reports.tcl
#
# Revision 2.2  1996/10/01 19:21:50  curt
# Reworked and simplified report algorithm.
#
# Revision 2.1  1996/10/01 17:21:11  curt
# Added a new missing check # report.
#
