#!/bin/sh
echo 'name: uniplate
version: 1.6.7
id: uniplate-1.6.7-685e38babec5de6473fccd9214b7fc85

license: BSD3
copyright: Neil Mitchell 2006-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability:
homepage: http://community.haskell.org/~ndm/uniplate/
package-url:
synopsis: Help writing simple, concise and fast generic operations.
description: Uniplate is library for writing simple and concise generic operations.
             Uniplate has similar goals to the original Scrap Your Boilerplate work,
             but is substantially simpler and faster. The Uniplate manual is available at
             <http://community.haskell.org/~ndm/darcs/uniplate/uniplate.htm>.
             .
             To get started with Uniplate you should import one of the three following
             modules:
             .
             * "Data.Generics.Uniplate.Data" - to quickly start writing generic functions.
             Most users should start by importing this module.
             .
             * "Data.Generics.Uniplate.Direct" - a replacement for "Data.Generics.Uniplate.Data"
             with substantially higher performance (around 5 times), but requires writing
             instance declarations.
             .
             * "Data.Generics.Uniplate.Operations" - definitions of all the operations defined
             by Uniplate. Both the above two modules re-export this module.
             .
             In addition, some users may want to make use of the following modules:
             .
             * "Data.Generics.Uniplate.Zipper" - a zipper built on top of Uniplate instances.
             .
             * "Data.Generics.SYB" - users transitioning from the Scrap Your Boilerplate library.
             .
             * "Data.Generics.Compos" - users transitioning from the Compos library.
             .
             * "Data.Generics.Uniplate.DataOnly" - users making use of both @Data@ and @Direct@
             to avoid getting instance conflicts.
category: Generics
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: devel/hs-uniplate
exposed: True
exposed-modules: Data.Generics.Str Data.Generics.Compos
                 Data.Generics.SYB Data.Generics.Uniplate.Data
                 Data.Generics.Uniplate.Data.Instances
                 Data.Generics.Uniplate.DataOnly Data.Generics.Uniplate.Direct
                 Data.Generics.Uniplate.Operations Data.Generics.Uniplate.Typeable
                 Data.Generics.Uniplate.Zipper Data.Generics.Uniplate
                 Data.Generics.UniplateOn Data.Generics.UniplateStr
                 Data.Generics.UniplateStrOn Data.Generics.Biplate
                 Data.Generics.PlateDirect Data.Generics.PlateTypeable
                 Data.Generics.PlateData
hidden-modules: Data.Generics.PlateInternal
                Data.Generics.Uniplate.Internal.Data
                Data.Generics.Uniplate.Internal.DataOnlyOperations
                Data.Generics.Uniplate.Internal.Utils
trusted: False
import-dirs: /usr/local/lib/ghc/uniplate-1.6.7
library-dirs: /usr/local/lib/ghc/uniplate-1.6.7
hs-libraries: HSuniplate-1.6.7
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-d435272bc8de1d17f3a0aacfbd562dbe
         containers-0.5.0.0-3b8b869ec10d44736414ab5bea776319
         hashable-1.1.2.5-93ac9e8f4902e70447854e208345383a
         syb-0.4.0-8e7e08a060d6fc361aca595c701a94d6
         unordered-containers-0.2.3.0-5bf92a1c1b90f6e2e5a5dbbd8a6ab013
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-uniplate-1.6.7/html/uniplate.haddock
haddock-html: /usr/local/share/doc/hs-uniplate-1.6.7/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
