#!/bin/sh
echo 'name: lens
version: 3.7.6
id: lens-3.7.6-279ef4ec8bf447996174817bf749a957

license: BSD3
copyright: Copyright (C) 2012 Edward A. Kmett
maintainer: Edward A. Kmett <ekmett@gmail.com>
stability: provisional
homepage: http://github.com/ekmett/lens/
package-url:
synopsis: Lenses, Folds and Traversals
description: This package comes \"Batteries Included\" with many useful lenses for the types
             commonly used from the Haskell Platform, and with tools for automatically
             generating lenses and isomorphisms for user-supplied data types.
             .
             The combinators in @Control.Lens@ provide a highly generic toolbox for composing
             families of getters, folds, isomorphisms, traversals, setters and lenses and their
             indexed variants.
             .
             An overview, with a large number of examples can be found in the README.
             .
             <https://github.com/ekmett/lens#lens-lenses-folds-and-traversals>
             .
             More information on the care and feeding of lenses, including a brief tutorial and motivation
             for their types can be found on the lens wiki.
             .
             <https://github.com/ekmett/lens/wiki>
             .
             A small game that manages its state using lenses can be found in the example folder.
             .
             <https://github.com/ekmett/lens/blob/master/examples/Pong.hs>
             .
             /Lenses, Folds and Traversals/
             .
             The core of this hierarchy looks like:
             .
             <<http://i.imgur.com/FgfVW.png>>
             .
             You can compose any two elements of the hierarchy above using (.) from the Prelude, and you can
             use any element of the hierarchy as any type it linked to above it.
             .
             The result is their lowest upper bound in the hierarchy (or an error if that bound doesn'\''t exist).
             .
             For instance:
             .
             * You can use any '\''Traversal'\'' as a '\''Fold'\'' or as a '\''Setter'\''.
             .
             * The composition of a '\''Traversal'\'' and a '\''Getter'\'' yields a '\''Fold'\''.
             .
             /Minimizing Dependencies/
             .
             If you want to provide lenses and traversals for your own types in your own libraries, then you
             can do so without incurring a dependency on this (or any other) lens package at all.
             .
             /e.g./ for a data type:
             .
             > data Foo a = Foo Int Int a
             .
             You can define lenses such as
             .
             > -- bar :: Simple Lens (Foo a) Int
             > bar :: Functor f => (Int -> f Int) -> Foo a -> f (Foo a)
             > bar f (Foo a b c) = fmap (\a'\'' -> Foo a'\'' b c) (f a)
             .
             > -- baz :: Lens (Foo a) (Foo b) a b
             > quux :: Functor f => (a -> f b) -> Foo a -> f (Foo b)
             > quux f (Foo a b c) = fmap (Foo a b) (f c)
             .
             without the need to use any type that isn'\''t already defined in the @Prelude@.
             .
             And you can define a traversal of multiple fields with '\''Control.Applicative.Applicative'\'':
             .
             > -- traverseBarAndBaz :: Simple Traversal (Foo a) Int
             > traverseBarAndBaz :: Applicative f => (Int -> f Int) -> Foo a -> f (Foo a)
             > traverseBarAndBaz f (Foo a b c) = Foo <$> f a <*> f b <*> pure c
             .
             What is provided in this library is a number of stock lenses and traversals for
             common haskell types, a wide array of combinators for working them, and more
             exotic functionality, (/e.g./ getters, setters, indexed folds, isomorphisms).
category: Data, Lenses
author: Edward A. Kmett
pkgpath: devel/hs-lens
exposed: True
exposed-modules: Control.Lens.TH Language.Haskell.TH.Lens
                 Control.Exception.Lens Control.Lens Control.Lens.Action
                 Control.Lens.Classes Control.Lens.Combinators Control.Lens.Each
                 Control.Lens.Fold Control.Lens.Getter Control.Lens.Indexed
                 Control.Lens.IndexedGetter Control.Lens.IndexedFold
                 Control.Lens.IndexedLens Control.Lens.IndexedSetter
                 Control.Lens.IndexedTraversal Control.Lens.Internal
                 Control.Lens.Internal.Zipper Control.Lens.Iso Control.Lens.Loupe
                 Control.Lens.Plated Control.Lens.Prism Control.Lens.Representable
                 Control.Lens.Setter Control.Lens.Simple Control.Lens.Traversal
                 Control.Lens.Tuple Control.Lens.Type Control.Lens.WithIndex
                 Control.Lens.Wrapped Control.Lens.Zipper Control.Lens.Zoom
                 Data.Bits.Lens Data.ByteString.Lens Data.ByteString.Strict.Lens
                 Data.ByteString.Lazy.Lens Data.Complex.Lens Data.Data.Lens
                 Data.Dynamic.Lens Data.HashSet.Lens Data.IntSet.Lens Data.List.Lens
                 Data.List.Split.Lens Data.Sequence.Lens Data.Set.Lens
                 Data.Text.Lens Data.Text.Strict.Lens Data.Text.Lazy.Lens
                 Data.Tree.Lens Data.Typeable.Lens Data.Vector.Lens
                 Data.Vector.Generic.Lens GHC.Generics.Lens Data.Array.Lens
                 System.FilePath.Lens Control.Parallel.Strategies.Lens
                 Control.Seq.Lens
hidden-modules: Control.Lens.Internal.Combinators
trusted: False
import-dirs: /usr/local/lib/ghc/lens-3.7.6
library-dirs: /usr/local/lib/ghc/lens-3.7.6
hs-libraries: HSlens-3.7.6
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: array-0.4.0.1-3b78425c10ff2dad7acf7e8c8ae014c3
         base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         bytestring-0.10.0.2-1c6ab0cabcb254a0e55d751d8ef17b51
         comonad-3.0.3-069bdb9621e61706823278b4810c21d4
         comonad-transformers-3.0.3-4b091baf0c9d24a9127cb61fc1605604
         comonads-fd-3.0.2-b839aee353f22d3f6d3eb50afd36a5d0
         containers-0.5.0.0-ab1dae9a94cd3cc84e7b2805636ebfa2
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         ghc-prim-0.3.0.0-d5221a8c8a269b66ab9a07bdc23317dd
         hashable-1.1.2.5-e0f2541518f84d3123a819112b4ffe20
         mtl-2.1.2-94c72af955e94b8d7b2f359dadd0cb62
         nats-0.1-542364788ee81c02f54dc2871fc3c802
         parallel-3.2.0.3-d6c020cb3aa15c71f5f29c0db359fd39
         semigroups-0.9.2-0ae338a1c46795582eacad9d4e2dee57
         split-0.2.2-9ce33138f4fcfb9c37f6e6c300bcc367
         template-haskell-2.8.0.0-2f3447bb22ecbbb93fd4d823f6841241
         text-0.11.3.1-5af30448b2c3a30eee31b3ea9b549812
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
         unordered-containers-0.2.3.0-c7952fe8bed178bdf8ed4d090730c9da
         vector-0.10.0.1-869166d5d49db46ce6c328ea5f8defbf
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-lens-3.7.6/html/lens.haddock
haddock-html: /usr/local/share/doc/hs-lens-3.7.6/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
