#!/bin/sh
echo 'name: cmdargs
version: 0.9.5
id: cmdargs-0.9.5-431416de0ee18e2e4ed963ce1f356acf

license: BSD3
copyright: Neil Mitchell 2009-2012
maintainer: Neil Mitchell <ndmitchell@gmail.com>
stability: Beta
homepage: http://community.haskell.org/~ndm/cmdargs/
package-url:
synopsis: Command line argument processing
description: This library provides an easy way to define command line parsers. Most users
             will want to use the "System.Console.CmdArgs.Implicit" module, whose
             documentation contains an example.
             .
             * "System.Console.CmdArgs.Explicit" provides a way to write command line
             parsers for both single mode programs (most programs) and multiple
             mode programs (e.g. darcs or cabal). Parsers are defined by constructing
             a data structure.
             .
             * "System.Console.CmdArgs.Implicit" provides a way to concisely define
             command line parsers, up to three times shorter than getopt. These parsers
             are translated into the Explicit data type.
             .
             * "System.Console.CmdArgs.GetOpt" provides a wrapper allowing compatiblity
             with existing getopt parsers, mapping to the Explicit data type.
             .
             For a general reference on what command line flags are commonly used,
             see <http://www.faqs.org/docs/artu/ch10s05.html>.
category: Console
author: Neil Mitchell <ndmitchell@gmail.com>
pkgpath: devel/hs-cmdargs
exposed: True
exposed-modules: System.Console.CmdArgs.Quote
                 System.Console.CmdArgs System.Console.CmdArgs.Annotate
                 System.Console.CmdArgs.Default System.Console.CmdArgs.Explicit
                 System.Console.CmdArgs.GetOpt System.Console.CmdArgs.Implicit
                 System.Console.CmdArgs.Text System.Console.CmdArgs.Helper
                 System.Console.CmdArgs.Verbosity
hidden-modules: Data.Generics.Any Data.Generics.Any.Prelude
                System.Console.CmdArgs.Explicit.Complete
                System.Console.CmdArgs.Explicit.ExpandArgsAt
                System.Console.CmdArgs.Explicit.Help
                System.Console.CmdArgs.Explicit.Process
                System.Console.CmdArgs.Explicit.SplitJoin
                System.Console.CmdArgs.Explicit.Type
                System.Console.CmdArgs.Implicit.Ann
                System.Console.CmdArgs.Implicit.Global
                System.Console.CmdArgs.Implicit.Local
                System.Console.CmdArgs.Implicit.Reader
                System.Console.CmdArgs.Implicit.Reform
                System.Console.CmdArgs.Implicit.Type
                System.Console.CmdArgs.Implicit.UI
trusted: False
import-dirs: /usr/local/lib/ghc/cmdargs-0.9.5
library-dirs: /usr/local/lib/ghc/cmdargs-0.9.5
hs-libraries: HScmdargs-0.9.5
extra-libraries:
extra-ghci-libraries:
include-dirs:
includes:
depends: base-4.6.0.1-6b06c3defb20732cfd08deb8ba52ca7c
         filepath-1.3.0.1-b12cbe18566fe1532a1fda4c85e31cbe
         process-1.1.0.2-76e05340eb66705981411022731ca84a
         template-haskell-2.8.0.0-2f3447bb22ecbbb93fd4d823f6841241
         transformers-0.3.0.0-ff2bb6ac67241ebb987351a3db564af0
hugs-options:
cc-options:
ld-options:
framework-dirs:
frameworks:
haddock-interfaces: /usr/local/share/doc/hs-cmdargs-0.9.5/html/cmdargs.haddock
haddock-html: /usr/local/share/doc/hs-cmdargs-0.9.5/html
' | '/usr/local/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
