require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_TLS1_H)) {
    eval 'sub HEADER_TLS1_H () {1;}' unless defined(&HEADER_TLS1_H);
    require 'openssl/buffer.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub TLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES () {0;}' unless defined(&TLS1_ALLOW_EXPERIMENTAL_CIPHERSUITES);
    eval 'sub TLS1_2_VERSION () {0x303;}' unless defined(&TLS1_2_VERSION);
    eval 'sub TLS1_2_VERSION_MAJOR () {0x3;}' unless defined(&TLS1_2_VERSION_MAJOR);
    eval 'sub TLS1_2_VERSION_MINOR () {0x3;}' unless defined(&TLS1_2_VERSION_MINOR);
    eval 'sub TLS1_1_VERSION () {0x302;}' unless defined(&TLS1_1_VERSION);
    eval 'sub TLS1_1_VERSION_MAJOR () {0x3;}' unless defined(&TLS1_1_VERSION_MAJOR);
    eval 'sub TLS1_1_VERSION_MINOR () {0x2;}' unless defined(&TLS1_1_VERSION_MINOR);
    eval 'sub TLS1_VERSION () {0x301;}' unless defined(&TLS1_VERSION);
    eval 'sub TLS1_VERSION_MAJOR () {0x3;}' unless defined(&TLS1_VERSION_MAJOR);
    eval 'sub TLS1_VERSION_MINOR () {0x1;}' unless defined(&TLS1_VERSION_MINOR);
    eval 'sub TLS1_get_version {
        my($s) = @_;
	    eval q((( ($s->{version}) >> 8) ==  &TLS1_VERSION_MAJOR ?  ($s->{version}) : 0));
    }' unless defined(&TLS1_get_version);
    eval 'sub TLS1_get_client_version {
        my($s) = @_;
	    eval q((( ($s->{client_version}) >> 8) ==  &TLS1_VERSION_MAJOR ?  ($s->{client_version}) : 0));
    }' unless defined(&TLS1_get_client_version);
    eval 'sub TLS1_AD_DECRYPTION_FAILED () {21;}' unless defined(&TLS1_AD_DECRYPTION_FAILED);
    eval 'sub TLS1_AD_RECORD_OVERFLOW () {22;}' unless defined(&TLS1_AD_RECORD_OVERFLOW);
    eval 'sub TLS1_AD_UNKNOWN_CA () {48;}' unless defined(&TLS1_AD_UNKNOWN_CA);
    eval 'sub TLS1_AD_ACCESS_DENIED () {49;}' unless defined(&TLS1_AD_ACCESS_DENIED);
    eval 'sub TLS1_AD_DECODE_ERROR () {50;}' unless defined(&TLS1_AD_DECODE_ERROR);
    eval 'sub TLS1_AD_DECRYPT_ERROR () {51;}' unless defined(&TLS1_AD_DECRYPT_ERROR);
    eval 'sub TLS1_AD_EXPORT_RESTRICTION () {60;}' unless defined(&TLS1_AD_EXPORT_RESTRICTION);
    eval 'sub TLS1_AD_PROTOCOL_VERSION () {70;}' unless defined(&TLS1_AD_PROTOCOL_VERSION);
    eval 'sub TLS1_AD_INSUFFICIENT_SECURITY () {71;}' unless defined(&TLS1_AD_INSUFFICIENT_SECURITY);
    eval 'sub TLS1_AD_INTERNAL_ERROR () {80;}' unless defined(&TLS1_AD_INTERNAL_ERROR);
    eval 'sub TLS1_AD_USER_CANCELLED () {90;}' unless defined(&TLS1_AD_USER_CANCELLED);
    eval 'sub TLS1_AD_NO_RENEGOTIATION () {100;}' unless defined(&TLS1_AD_NO_RENEGOTIATION);
    eval 'sub TLS1_AD_UNSUPPORTED_EXTENSION () {110;}' unless defined(&TLS1_AD_UNSUPPORTED_EXTENSION);
    eval 'sub TLS1_AD_CERTIFICATE_UNOBTAINABLE () {111;}' unless defined(&TLS1_AD_CERTIFICATE_UNOBTAINABLE);
    eval 'sub TLS1_AD_UNRECOGNIZED_NAME () {112;}' unless defined(&TLS1_AD_UNRECOGNIZED_NAME);
    eval 'sub TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE () {113;}' unless defined(&TLS1_AD_BAD_CERTIFICATE_STATUS_RESPONSE);
    eval 'sub TLS1_AD_BAD_CERTIFICATE_HASH_VALUE () {114;}' unless defined(&TLS1_AD_BAD_CERTIFICATE_HASH_VALUE);
    eval 'sub TLS1_AD_UNKNOWN_PSK_IDENTITY () {115;}' unless defined(&TLS1_AD_UNKNOWN_PSK_IDENTITY);
    eval 'sub TLSEXT_TYPE_server_name () {0;}' unless defined(&TLSEXT_TYPE_server_name);
    eval 'sub TLSEXT_TYPE_max_fragment_length () {1;}' unless defined(&TLSEXT_TYPE_max_fragment_length);
    eval 'sub TLSEXT_TYPE_client_certificate_url () {2;}' unless defined(&TLSEXT_TYPE_client_certificate_url);
    eval 'sub TLSEXT_TYPE_trusted_ca_keys () {3;}' unless defined(&TLSEXT_TYPE_trusted_ca_keys);
    eval 'sub TLSEXT_TYPE_truncated_hmac () {4;}' unless defined(&TLSEXT_TYPE_truncated_hmac);
    eval 'sub TLSEXT_TYPE_status_request () {5;}' unless defined(&TLSEXT_TYPE_status_request);
    eval 'sub TLSEXT_TYPE_user_mapping () {6;}' unless defined(&TLSEXT_TYPE_user_mapping);
    eval 'sub TLSEXT_TYPE_client_authz () {7;}' unless defined(&TLSEXT_TYPE_client_authz);
    eval 'sub TLSEXT_TYPE_server_authz () {8;}' unless defined(&TLSEXT_TYPE_server_authz);
    eval 'sub TLSEXT_TYPE_cert_type () {9;}' unless defined(&TLSEXT_TYPE_cert_type);
    eval 'sub TLSEXT_TYPE_elliptic_curves () {10;}' unless defined(&TLSEXT_TYPE_elliptic_curves);
    eval 'sub TLSEXT_TYPE_ec_point_formats () {11;}' unless defined(&TLSEXT_TYPE_ec_point_formats);
    eval 'sub TLSEXT_TYPE_srp () {12;}' unless defined(&TLSEXT_TYPE_srp);
    eval 'sub TLSEXT_TYPE_signature_algorithms () {13;}' unless defined(&TLSEXT_TYPE_signature_algorithms);
    eval 'sub TLSEXT_TYPE_use_srtp () {14;}' unless defined(&TLSEXT_TYPE_use_srtp);
    eval 'sub TLSEXT_TYPE_heartbeat () {15;}' unless defined(&TLSEXT_TYPE_heartbeat);
    eval 'sub TLSEXT_TYPE_session_ticket () {35;}' unless defined(&TLSEXT_TYPE_session_ticket);
    if(0) {
	eval 'sub TLSEXT_TYPE_opaque_prf_input () {?? */;}' unless defined(&TLSEXT_TYPE_opaque_prf_input);
    }
    eval 'sub TLSEXT_TYPE_renegotiate () {0xff01;}' unless defined(&TLSEXT_TYPE_renegotiate);
    unless(defined(&OPENSSL_NO_NEXTPROTONEG)) {
	eval 'sub TLSEXT_TYPE_next_proto_neg () {13172;}' unless defined(&TLSEXT_TYPE_next_proto_neg);
    }
    eval 'sub TLSEXT_NAMETYPE_host_name () {0;}' unless defined(&TLSEXT_NAMETYPE_host_name);
    eval 'sub TLSEXT_STATUSTYPE_ocsp () {1;}' unless defined(&TLSEXT_STATUSTYPE_ocsp);
    eval 'sub TLSEXT_ECPOINTFORMAT_first () {0;}' unless defined(&TLSEXT_ECPOINTFORMAT_first);
    eval 'sub TLSEXT_ECPOINTFORMAT_uncompressed () {0;}' unless defined(&TLSEXT_ECPOINTFORMAT_uncompressed);
    eval 'sub TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime () {1;}' unless defined(&TLSEXT_ECPOINTFORMAT_ansiX962_compressed_prime);
    eval 'sub TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2 () {2;}' unless defined(&TLSEXT_ECPOINTFORMAT_ansiX962_compressed_char2);
    eval 'sub TLSEXT_ECPOINTFORMAT_last () {2;}' unless defined(&TLSEXT_ECPOINTFORMAT_last);
    eval 'sub TLSEXT_signature_anonymous () {0;}' unless defined(&TLSEXT_signature_anonymous);
    eval 'sub TLSEXT_signature_rsa () {1;}' unless defined(&TLSEXT_signature_rsa);
    eval 'sub TLSEXT_signature_dsa () {2;}' unless defined(&TLSEXT_signature_dsa);
    eval 'sub TLSEXT_signature_ecdsa () {3;}' unless defined(&TLSEXT_signature_ecdsa);
    eval 'sub TLSEXT_hash_none () {0;}' unless defined(&TLSEXT_hash_none);
    eval 'sub TLSEXT_hash_md5 () {1;}' unless defined(&TLSEXT_hash_md5);
    eval 'sub TLSEXT_hash_sha1 () {2;}' unless defined(&TLSEXT_hash_sha1);
    eval 'sub TLSEXT_hash_sha224 () {3;}' unless defined(&TLSEXT_hash_sha224);
    eval 'sub TLSEXT_hash_sha256 () {4;}' unless defined(&TLSEXT_hash_sha256);
    eval 'sub TLSEXT_hash_sha384 () {5;}' unless defined(&TLSEXT_hash_sha384);
    eval 'sub TLSEXT_hash_sha512 () {6;}' unless defined(&TLSEXT_hash_sha512);
    unless(defined(&OPENSSL_NO_TLSEXT)) {
	eval 'sub TLSEXT_MAXLEN_host_name () {255;}' unless defined(&TLSEXT_MAXLEN_host_name);
	eval 'sub SSL_set_tlsext_host_name {
	    my($s,$name) = @_;
    	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_TLSEXT_HOSTNAME, &TLSEXT_NAMETYPE_host_name,$name));
	}' unless defined(&SSL_set_tlsext_host_name);
	eval 'sub SSL_set_tlsext_debug_callback {
	    my($ssl, $cb) = @_;
    	    eval q( &SSL_callback_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_DEBUG_CB,( &void (*)( &void))$cb));
	}' unless defined(&SSL_set_tlsext_debug_callback);
	eval 'sub SSL_set_tlsext_debug_arg {
	    my($ssl, $arg) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_DEBUG_ARG,0, ( &void *)$arg));
	}' unless defined(&SSL_set_tlsext_debug_arg);
	eval 'sub SSL_set_tlsext_status_type {
	    my($ssl, $type) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_TYPE,$type,  &NULL));
	}' unless defined(&SSL_set_tlsext_status_type);
	eval 'sub SSL_get_tlsext_status_exts {
	    my($ssl, $arg) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_EXTS,0, ( &void *)$arg));
	}' unless defined(&SSL_get_tlsext_status_exts);
	eval 'sub SSL_set_tlsext_status_exts {
	    my($ssl, $arg) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_EXTS,0, ( &void *)$arg));
	}' unless defined(&SSL_set_tlsext_status_exts);
	eval 'sub SSL_get_tlsext_status_ids {
	    my($ssl, $arg) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_IDS,0, ( &void *)$arg));
	}' unless defined(&SSL_get_tlsext_status_ids);
	eval 'sub SSL_set_tlsext_status_ids {
	    my($ssl, $arg) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_IDS,0, ( &void *)$arg));
	}' unless defined(&SSL_set_tlsext_status_ids);
	eval 'sub SSL_get_tlsext_status_ocsp_resp {
	    my($ssl, $arg) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_GET_TLSEXT_STATUS_REQ_OCSP_RESP,0, ( &void *)$arg));
	}' unless defined(&SSL_get_tlsext_status_ocsp_resp);
	eval 'sub SSL_set_tlsext_status_ocsp_resp {
	    my($ssl, $arg, $arglen) = @_;
    	    eval q( &SSL_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_OCSP_RESP,$arglen, ( &void *)$arg));
	}' unless defined(&SSL_set_tlsext_status_ocsp_resp);
	eval 'sub SSL_CTX_set_tlsext_servername_callback {
	    my($ctx, $cb) = @_;
    	    eval q( &SSL_CTX_callback_ctrl($ctx, &SSL_CTRL_SET_TLSEXT_SERVERNAME_CB,( &void (*)( &void))$cb));
	}' unless defined(&SSL_CTX_set_tlsext_servername_callback);
	eval 'sub SSL_TLSEXT_ERR_OK () {0;}' unless defined(&SSL_TLSEXT_ERR_OK);
	eval 'sub SSL_TLSEXT_ERR_ALERT_WARNING () {1;}' unless defined(&SSL_TLSEXT_ERR_ALERT_WARNING);
	eval 'sub SSL_TLSEXT_ERR_ALERT_FATAL () {2;}' unless defined(&SSL_TLSEXT_ERR_ALERT_FATAL);
	eval 'sub SSL_TLSEXT_ERR_NOACK () {3;}' unless defined(&SSL_TLSEXT_ERR_NOACK);
	eval 'sub SSL_CTX_set_tlsext_servername_arg {
	    my($ctx, $arg) = @_;
    	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_TLSEXT_SERVERNAME_ARG,0, ( &void *)$arg));
	}' unless defined(&SSL_CTX_set_tlsext_servername_arg);
	eval 'sub SSL_CTX_get_tlsext_ticket_keys {
	    my($ctx, $keys, $keylen) = @_;
    	    eval q( &SSL_CTX_ctrl(($ctx), &SSL_CTRL_GET_TLSEXT_TICKET_KEYS,($keylen),($keys)));
	}' unless defined(&SSL_CTX_get_tlsext_ticket_keys);
	eval 'sub SSL_CTX_set_tlsext_ticket_keys {
	    my($ctx, $keys, $keylen) = @_;
    	    eval q( &SSL_CTX_ctrl(($ctx), &SSL_CTRL_SET_TLSEXT_TICKET_KEYS,($keylen),($keys)));
	}' unless defined(&SSL_CTX_set_tlsext_ticket_keys);
	eval 'sub SSL_CTX_set_tlsext_status_cb {
	    my($ssl, $cb) = @_;
    	    eval q( &SSL_CTX_callback_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB,( &void (*)( &void))$cb));
	}' unless defined(&SSL_CTX_set_tlsext_status_cb);
	eval 'sub SSL_CTX_set_tlsext_status_arg {
	    my($ssl, $arg) = @_;
    	    eval q( &SSL_CTX_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_STATUS_REQ_CB_ARG,0, ( &void *)$arg));
	}' unless defined(&SSL_CTX_set_tlsext_status_arg);
	eval 'sub SSL_set_tlsext_opaque_prf_input {
	    my($s, $src, $len) = @_;
    	    eval q( &SSL_ctrl($s, &SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT, $len, $src));
	}' unless defined(&SSL_set_tlsext_opaque_prf_input);
	eval 'sub SSL_CTX_set_tlsext_opaque_prf_input_callback {
	    my($ctx, $cb) = @_;
    	    eval q( &SSL_CTX_callback_ctrl($ctx, &SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT_CB, ( &void (*)( &void))$cb));
	}' unless defined(&SSL_CTX_set_tlsext_opaque_prf_input_callback);
	eval 'sub SSL_CTX_set_tlsext_opaque_prf_input_callback_arg {
	    my($ctx, $arg) = @_;
    	    eval q( &SSL_CTX_ctrl($ctx, &SSL_CTRL_SET_TLSEXT_OPAQUE_PRF_INPUT_CB_ARG, 0, $arg));
	}' unless defined(&SSL_CTX_set_tlsext_opaque_prf_input_callback_arg);
	eval 'sub SSL_CTX_set_tlsext_ticket_key_cb {
	    my($ssl, $cb) = @_;
    	    eval q( &SSL_CTX_callback_ctrl($ssl, &SSL_CTRL_SET_TLSEXT_TICKET_KEY_CB,( &void (*)( &void))$cb));
	}' unless defined(&SSL_CTX_set_tlsext_ticket_key_cb);
	unless(defined(&OPENSSL_NO_HEARTBEATS)) {
	    eval 'sub SSL_TLSEXT_HB_ENABLED () {0x1;}' unless defined(&SSL_TLSEXT_HB_ENABLED);
	    eval 'sub SSL_TLSEXT_HB_DONT_SEND_REQUESTS () {0x2;}' unless defined(&SSL_TLSEXT_HB_DONT_SEND_REQUESTS);
	    eval 'sub SSL_TLSEXT_HB_DONT_RECV_REQUESTS () {0x4;}' unless defined(&SSL_TLSEXT_HB_DONT_RECV_REQUESTS);
	    eval 'sub SSL_get_tlsext_heartbeat_pending {
	        my($ssl) = @_;
    		eval q( &SSL_ctrl(($ssl), &SSL_CTRL_GET_TLS_EXT_HEARTBEAT_PENDING,0, &NULL));
	    }' unless defined(&SSL_get_tlsext_heartbeat_pending);
	    eval 'sub SSL_set_tlsext_heartbeat_no_requests {
	        my($ssl, $arg) = @_;
    		eval q( &SSL_ctrl(($ssl), &SSL_CTRL_SET_TLS_EXT_HEARTBEAT_NO_REQUESTS,$arg, &NULL));
	    }' unless defined(&SSL_set_tlsext_heartbeat_no_requests);
	}
    }
    eval 'sub TLS1_CK_PSK_WITH_RC4_128_SHA () {0x300008a;}' unless defined(&TLS1_CK_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA () {0x300008b;}' unless defined(&TLS1_CK_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_PSK_WITH_AES_128_CBC_SHA () {0x300008c;}' unless defined(&TLS1_CK_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_PSK_WITH_AES_256_CBC_SHA () {0x300008d;}' unless defined(&TLS1_CK_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_MD5 () {0x3000060;}' unless defined(&TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_MD5);
    eval 'sub TLS1_CK_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 () {0x3000061;}' unless defined(&TLS1_CK_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5);
    eval 'sub TLS1_CK_RSA_EXPORT1024_WITH_DES_CBC_SHA () {0x3000062;}' unless defined(&TLS1_CK_RSA_EXPORT1024_WITH_DES_CBC_SHA);
    eval 'sub TLS1_CK_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA () {0x3000063;}' unless defined(&TLS1_CK_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA);
    eval 'sub TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_SHA () {0x3000064;}' unless defined(&TLS1_CK_RSA_EXPORT1024_WITH_RC4_56_SHA);
    eval 'sub TLS1_CK_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA () {0x3000065;}' unless defined(&TLS1_CK_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_RC4_128_SHA () {0x3000066;}' unless defined(&TLS1_CK_DHE_DSS_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_SHA () {0x300002f;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_128_SHA () {0x3000030;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_128_SHA () {0x3000031;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_128_SHA () {0x3000032;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_SHA () {0x3000033;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_ADH_WITH_AES_128_SHA () {0x3000034;}' unless defined(&TLS1_CK_ADH_WITH_AES_128_SHA);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_SHA () {0x3000035;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_256_SHA () {0x3000036;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_256_SHA () {0x3000037;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_256_SHA () {0x3000038;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_SHA () {0x3000039;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_ADH_WITH_AES_256_SHA () {0x300003a;}' unless defined(&TLS1_CK_ADH_WITH_AES_256_SHA);
    eval 'sub TLS1_CK_RSA_WITH_NULL_SHA256 () {0x300003b;}' unless defined(&TLS1_CK_RSA_WITH_NULL_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_SHA256 () {0x300003c;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_SHA256 () {0x300003d;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_128_SHA256 () {0x300003e;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_128_SHA256 () {0x300003f;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_128_SHA256 () {0x3000040;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA () {0x3000041;}' unless defined(&TLS1_CK_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA () {0x3000042;}' unless defined(&TLS1_CK_DH_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA () {0x3000043;}' unless defined(&TLS1_CK_DH_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA () {0x3000044;}' unless defined(&TLS1_CK_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA () {0x3000045;}' unless defined(&TLS1_CK_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA () {0x3000046;}' unless defined(&TLS1_CK_ADH_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_SHA256 () {0x3000067;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_256_SHA256 () {0x3000068;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_256_SHA256 () {0x3000069;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_256_SHA256 () {0x300006a;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_SHA256 () {0x300006b;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_AES_128_SHA256 () {0x300006c;}' unless defined(&TLS1_CK_ADH_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_AES_256_SHA256 () {0x300006d;}' unless defined(&TLS1_CK_ADH_WITH_AES_256_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA () {0x3000084;}' unless defined(&TLS1_CK_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA () {0x3000085;}' unless defined(&TLS1_CK_DH_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA () {0x3000086;}' unless defined(&TLS1_CK_DH_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA () {0x3000087;}' unless defined(&TLS1_CK_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA () {0x3000088;}' unless defined(&TLS1_CK_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA () {0x3000089;}' unless defined(&TLS1_CK_ADH_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_CK_RSA_WITH_SEED_SHA () {0x3000096;}' unless defined(&TLS1_CK_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DH_DSS_WITH_SEED_SHA () {0x3000097;}' unless defined(&TLS1_CK_DH_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DH_RSA_WITH_SEED_SHA () {0x3000098;}' unless defined(&TLS1_CK_DH_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DHE_DSS_WITH_SEED_SHA () {0x3000099;}' unless defined(&TLS1_CK_DHE_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_CK_DHE_RSA_WITH_SEED_SHA () {0x300009a;}' unless defined(&TLS1_CK_DHE_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_CK_ADH_WITH_SEED_SHA () {0x300009b;}' unless defined(&TLS1_CK_ADH_WITH_SEED_SHA);
    eval 'sub TLS1_CK_RSA_WITH_AES_128_GCM_SHA256 () {0x300009c;}' unless defined(&TLS1_CK_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_RSA_WITH_AES_256_GCM_SHA384 () {0x300009d;}' unless defined(&TLS1_CK_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256 () {0x300009e;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384 () {0x300009f;}' unless defined(&TLS1_CK_DHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256 () {0x30000a0;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384 () {0x30000a1;}' unless defined(&TLS1_CK_DH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256 () {0x30000a2;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384 () {0x30000a3;}' unless defined(&TLS1_CK_DHE_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256 () {0x30000a4;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384 () {0x30000a5;}' unless defined(&TLS1_CK_DH_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ADH_WITH_AES_128_GCM_SHA256 () {0x30000a6;}' unless defined(&TLS1_CK_ADH_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ADH_WITH_AES_256_GCM_SHA384 () {0x30000a7;}' unless defined(&TLS1_CK_ADH_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA () {0x300c001;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA () {0x300c002;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA () {0x300c003;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA () {0x300c004;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA () {0x300c005;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA () {0x300c006;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA () {0x300c007;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA () {0x300c008;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA () {0x300c009;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA () {0x300c00a;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_NULL_SHA () {0x300c00b;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA () {0x300c00c;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA () {0x300c00d;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA () {0x300c00e;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA () {0x300c00f;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_NULL_SHA () {0x300c010;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA () {0x300c011;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA () {0x300c012;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA () {0x300c013;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA () {0x300c014;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_NULL_SHA () {0x300c015;}' unless defined(&TLS1_CK_ECDH_anon_WITH_NULL_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_RC4_128_SHA () {0x300c016;}' unless defined(&TLS1_CK_ECDH_anon_WITH_RC4_128_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA () {0x300c017;}' unless defined(&TLS1_CK_ECDH_anon_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA () {0x300c018;}' unless defined(&TLS1_CK_ECDH_anon_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA () {0x300c019;}' unless defined(&TLS1_CK_ECDH_anon_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA () {0x300c01a;}' unless defined(&TLS1_CK_SRP_SHA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA () {0x300c01b;}' unless defined(&TLS1_CK_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA () {0x300c01c;}' unless defined(&TLS1_CK_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA () {0x300c01d;}' unless defined(&TLS1_CK_SRP_SHA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA () {0x300c01e;}' unless defined(&TLS1_CK_SRP_SHA_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA () {0x300c01f;}' unless defined(&TLS1_CK_SRP_SHA_DSS_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA () {0x300c020;}' unless defined(&TLS1_CK_SRP_SHA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA () {0x300c021;}' unless defined(&TLS1_CK_SRP_SHA_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA () {0x300c022;}' unless defined(&TLS1_CK_SRP_SHA_DSS_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256 () {0x300c023;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384 () {0x300c024;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256 () {0x300c025;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384 () {0x300c026;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256 () {0x300c027;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384 () {0x300c028;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256 () {0x300c029;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384 () {0x300c02a;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 () {0x300c02b;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 () {0x300c02c;}' unless defined(&TLS1_CK_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 () {0x300c02d;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 () {0x300c02e;}' unless defined(&TLS1_CK_ECDH_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256 () {0x300c02f;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384 () {0x300c030;}' unless defined(&TLS1_CK_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256 () {0x300c031;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384 () {0x300c032;}' unless defined(&TLS1_CK_ECDH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_MD5 () {"EXP1024-RC4-MD5";}' unless defined(&TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_MD5);
    eval 'sub TLS1_TXT_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5 () {"EXP1024-RC2-CBC-MD5";}' unless defined(&TLS1_TXT_RSA_EXPORT1024_WITH_RC2_CBC_56_MD5);
    eval 'sub TLS1_TXT_RSA_EXPORT1024_WITH_DES_CBC_SHA () {"EXP1024-DES-CBC-SHA";}' unless defined(&TLS1_TXT_RSA_EXPORT1024_WITH_DES_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA () {"EXP1024-DHE-DSS-DES-CBC-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_SHA () {"EXP1024-RC4-SHA";}' unless defined(&TLS1_TXT_RSA_EXPORT1024_WITH_RC4_56_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA () {"EXP1024-DHE-DSS-RC4-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA () {"DHE-DSS-RC4-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_SHA () {"AES128-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_128_SHA () {"DH-DSS-AES128-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_128_SHA () {"DH-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_128_SHA () {"DHE-DSS-AES128-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_SHA () {"DHE-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_AES_128_SHA () {"ADH-AES128-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_AES_128_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_SHA () {"AES256-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_256_SHA () {"DH-DSS-AES256-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_256_SHA () {"DH-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_256_SHA () {"DHE-DSS-AES256-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_SHA () {"DHE-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_AES_256_SHA () {"ADH-AES256-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_AES_256_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA () {"ECDH-ECDSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA () {"ECDH-ECDSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA () {"ECDH-ECDSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA () {"ECDH-ECDSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA () {"ECDH-ECDSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA () {"ECDHE-ECDSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA () {"ECDHE-ECDSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA () {"ECDHE-ECDSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA () {"ECDHE-ECDSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA () {"ECDHE-ECDSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_NULL_SHA () {"ECDH-RSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA () {"ECDH-RSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA () {"ECDH-RSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA () {"ECDH-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA () {"ECDH-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA () {"ECDHE-RSA-NULL-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA () {"ECDHE-RSA-RC4-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA () {"ECDHE-RSA-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA () {"ECDHE-RSA-AES128-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA () {"ECDHE-RSA-AES256-SHA";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_NULL_SHA () {"AECDH-NULL-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_NULL_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA () {"AECDH-RC4-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA () {"AECDH-DES-CBC3-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_DES_192_CBC3_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA () {"AECDH-AES128-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA () {"AECDH-AES256-SHA";}' unless defined(&TLS1_TXT_ECDH_anon_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_RC4_128_SHA () {"PSK-RC4-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_RC4_128_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_3DES_EDE_CBC_SHA () {"PSK-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_AES_128_CBC_SHA () {"PSK-AES128-CBC-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_PSK_WITH_AES_256_CBC_SHA () {"PSK-AES256-CBC-SHA";}' unless defined(&TLS1_TXT_PSK_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_WITH_3DES_EDE_CBC_SHA () {"SRP-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA () {"SRP-RSA-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_RSA_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA () {"SRP-DSS-3DES-EDE-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_DSS_WITH_3DES_EDE_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_WITH_AES_128_CBC_SHA () {"SRP-AES-128-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_RSA_WITH_AES_128_CBC_SHA () {"SRP-RSA-AES-128-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_RSA_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_DSS_WITH_AES_128_CBC_SHA () {"SRP-DSS-AES-128-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_DSS_WITH_AES_128_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_WITH_AES_256_CBC_SHA () {"SRP-AES-256-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_RSA_WITH_AES_256_CBC_SHA () {"SRP-RSA-AES-256-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_RSA_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_SRP_SHA_DSS_WITH_AES_256_CBC_SHA () {"SRP-DSS-AES-256-CBC-SHA";}' unless defined(&TLS1_TXT_SRP_SHA_DSS_WITH_AES_256_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA () {"CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA () {"DH-DSS-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA () {"DH-RSA-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA () {"DHE-DSS-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA () {"DHE-RSA-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA () {"ADH-CAMELLIA128-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_CAMELLIA_128_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA () {"CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA () {"DH-DSS-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA () {"DH-RSA-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA () {"DHE-DSS-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA () {"DHE-RSA-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA () {"ADH-CAMELLIA256-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_CAMELLIA_256_CBC_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_SEED_SHA () {"SEED-SHA";}' unless defined(&TLS1_TXT_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DH_DSS_WITH_SEED_SHA () {"DH-DSS-SEED-SHA";}' unless defined(&TLS1_TXT_DH_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DH_RSA_WITH_SEED_SHA () {"DH-RSA-SEED-SHA";}' unless defined(&TLS1_TXT_DH_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_SEED_SHA () {"DHE-DSS-SEED-SHA";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_SEED_SHA () {"DHE-RSA-SEED-SHA";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_ADH_WITH_SEED_SHA () {"ADH-SEED-SHA";}' unless defined(&TLS1_TXT_ADH_WITH_SEED_SHA);
    eval 'sub TLS1_TXT_RSA_WITH_NULL_SHA256 () {"NULL-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_NULL_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_SHA256 () {"AES128-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_SHA256 () {"AES256-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_128_SHA256 () {"DH-DSS-AES128-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_128_SHA256 () {"DH-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256 () {"DHE-DSS-AES128-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256 () {"DHE-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_256_SHA256 () {"DH-DSS-AES256-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_256_SHA256 () {"DH-RSA-AES256-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256 () {"DHE-DSS-AES256-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256 () {"DHE-RSA-AES256-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_AES_128_SHA256 () {"ADH-AES128-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_AES_256_SHA256 () {"ADH-AES256-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_AES_256_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256 () {"AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384 () {"AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256 () {"DHE-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384 () {"DHE-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256 () {"DH-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384 () {"DH-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256 () {"DHE-DSS-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384 () {"DHE-DSS-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DHE_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256 () {"DH-DSS-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384 () {"DH-DSS-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_DH_DSS_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256 () {"ADH-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ADH_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384 () {"ADH-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ADH_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256 () {"ECDHE-ECDSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384 () {"ECDHE-ECDSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256 () {"ECDH-ECDSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384 () {"ECDH-ECDSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256 () {"ECDHE-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384 () {"ECDHE-RSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256 () {"ECDH-RSA-AES128-SHA256";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_128_SHA256);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384 () {"ECDH-RSA-AES256-SHA384";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_256_SHA384);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 () {"ECDHE-ECDSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 () {"ECDHE-ECDSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256 () {"ECDH-ECDSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384 () {"ECDH-ECDSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDH_ECDSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256 () {"ECDHE-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384 () {"ECDHE-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDHE_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256 () {"ECDH-RSA-AES128-GCM-SHA256";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_128_GCM_SHA256);
    eval 'sub TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384 () {"ECDH-RSA-AES256-GCM-SHA384";}' unless defined(&TLS1_TXT_ECDH_RSA_WITH_AES_256_GCM_SHA384);
    eval 'sub TLS_CT_RSA_SIGN () {1;}' unless defined(&TLS_CT_RSA_SIGN);
    eval 'sub TLS_CT_DSS_SIGN () {2;}' unless defined(&TLS_CT_DSS_SIGN);
    eval 'sub TLS_CT_RSA_FIXED_DH () {3;}' unless defined(&TLS_CT_RSA_FIXED_DH);
    eval 'sub TLS_CT_DSS_FIXED_DH () {4;}' unless defined(&TLS_CT_DSS_FIXED_DH);
    eval 'sub TLS_CT_ECDSA_SIGN () {64;}' unless defined(&TLS_CT_ECDSA_SIGN);
    eval 'sub TLS_CT_RSA_FIXED_ECDH () {65;}' unless defined(&TLS_CT_RSA_FIXED_ECDH);
    eval 'sub TLS_CT_ECDSA_FIXED_ECDH () {66;}' unless defined(&TLS_CT_ECDSA_FIXED_ECDH);
    eval 'sub TLS_CT_GOST94_SIGN () {21;}' unless defined(&TLS_CT_GOST94_SIGN);
    eval 'sub TLS_CT_GOST01_SIGN () {22;}' unless defined(&TLS_CT_GOST01_SIGN);
    eval 'sub TLS_CT_NUMBER () {9;}' unless defined(&TLS_CT_NUMBER);
    eval 'sub TLS1_FINISH_MAC_LENGTH () {12;}' unless defined(&TLS1_FINISH_MAC_LENGTH);
    eval 'sub TLS_MD_MAX_CONST_SIZE () {20;}' unless defined(&TLS_MD_MAX_CONST_SIZE);
    eval 'sub TLS_MD_CLIENT_FINISH_CONST () {"client finished";}' unless defined(&TLS_MD_CLIENT_FINISH_CONST);
    eval 'sub TLS_MD_CLIENT_FINISH_CONST_SIZE () {15;}' unless defined(&TLS_MD_CLIENT_FINISH_CONST_SIZE);
    eval 'sub TLS_MD_SERVER_FINISH_CONST () {"server finished";}' unless defined(&TLS_MD_SERVER_FINISH_CONST);
    eval 'sub TLS_MD_SERVER_FINISH_CONST_SIZE () {15;}' unless defined(&TLS_MD_SERVER_FINISH_CONST_SIZE);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST () {"server write key";}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST_SIZE () {16;}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST_SIZE);
    eval 'sub TLS_MD_KEY_EXPANSION_CONST () {"key expansion";}' unless defined(&TLS_MD_KEY_EXPANSION_CONST);
    eval 'sub TLS_MD_KEY_EXPANSION_CONST_SIZE () {13;}' unless defined(&TLS_MD_KEY_EXPANSION_CONST_SIZE);
    eval 'sub TLS_MD_CLIENT_WRITE_KEY_CONST () {"client write key";}' unless defined(&TLS_MD_CLIENT_WRITE_KEY_CONST);
    eval 'sub TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE () {16;}' unless defined(&TLS_MD_CLIENT_WRITE_KEY_CONST_SIZE);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST () {"server write key";}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
    eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST_SIZE () {16;}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST_SIZE);
    eval 'sub TLS_MD_IV_BLOCK_CONST () {"IV block";}' unless defined(&TLS_MD_IV_BLOCK_CONST);
    eval 'sub TLS_MD_IV_BLOCK_CONST_SIZE () {8;}' unless defined(&TLS_MD_IV_BLOCK_CONST_SIZE);
    eval 'sub TLS_MD_MASTER_SECRET_CONST () {"master secret";}' unless defined(&TLS_MD_MASTER_SECRET_CONST);
    eval 'sub TLS_MD_MASTER_SECRET_CONST_SIZE () {13;}' unless defined(&TLS_MD_MASTER_SECRET_CONST_SIZE);
    if(defined(&CHARSET_EBCDIC)) {
	undef(&TLS_MD_CLIENT_FINISH_CONST) if defined(&TLS_MD_CLIENT_FINISH_CONST);
	eval 'sub TLS_MD_CLIENT_FINISH_CONST () {"\\x63\\x6c\\x69\\x65\\x6e\\x74\\x20\\x66\\x69\\x6e\\x69\\x73\\x68\\x65\\x64";}' unless defined(&TLS_MD_CLIENT_FINISH_CONST);
	undef(&TLS_MD_SERVER_FINISH_CONST) if defined(&TLS_MD_SERVER_FINISH_CONST);
	eval 'sub TLS_MD_SERVER_FINISH_CONST () {"\\x73\\x65\\x72\\x76\\x65\\x72\\x20\\x66\\x69\\x6e\\x69\\x73\\x68\\x65\\x64";}' unless defined(&TLS_MD_SERVER_FINISH_CONST);
	undef(&TLS_MD_SERVER_WRITE_KEY_CONST) if defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
	eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST () {"\\x73\\x65\\x72\\x76\\x65\\x72\\x20\\x77\\x72\\x69\\x74\\x65\\x20\\x6b\\x65\\x79";}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
	undef(&TLS_MD_KEY_EXPANSION_CONST) if defined(&TLS_MD_KEY_EXPANSION_CONST);
	eval 'sub TLS_MD_KEY_EXPANSION_CONST () {"\\x6b\\x65\\x79\\x20\\x65\\x78\\x70\\x61\\x6e\\x73\\x69\\x6f\\x6e";}' unless defined(&TLS_MD_KEY_EXPANSION_CONST);
	undef(&TLS_MD_CLIENT_WRITE_KEY_CONST) if defined(&TLS_MD_CLIENT_WRITE_KEY_CONST);
	eval 'sub TLS_MD_CLIENT_WRITE_KEY_CONST () {"\\x63\\x6c\\x69\\x65\\x6e\\x74\\x20\\x77\\x72\\x69\\x74\\x65\\x20\\x6b\\x65\\x79";}' unless defined(&TLS_MD_CLIENT_WRITE_KEY_CONST);
	undef(&TLS_MD_SERVER_WRITE_KEY_CONST) if defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
	eval 'sub TLS_MD_SERVER_WRITE_KEY_CONST () {"\\x73\\x65\\x72\\x76\\x65\\x72\\x20\\x77\\x72\\x69\\x74\\x65\\x20\\x6b\\x65\\x79";}' unless defined(&TLS_MD_SERVER_WRITE_KEY_CONST);
	undef(&TLS_MD_IV_BLOCK_CONST) if defined(&TLS_MD_IV_BLOCK_CONST);
	eval 'sub TLS_MD_IV_BLOCK_CONST () {"\\x49\\x56\\x20\\x62\\x6c\\x6f\\x63\\x6b";}' unless defined(&TLS_MD_IV_BLOCK_CONST);
	undef(&TLS_MD_MASTER_SECRET_CONST) if defined(&TLS_MD_MASTER_SECRET_CONST);
	eval 'sub TLS_MD_MASTER_SECRET_CONST () {"\\x6d\\x61\\x73\\x74\\x65\\x72\\x20\\x73\\x65\\x63\\x72\\x65\\x74";}' unless defined(&TLS_MD_MASTER_SECRET_CONST);
    }
    if(defined(&__cplusplus)) {
    }
}
1;
