require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&HEADER_PEM_H)) {
    eval 'sub HEADER_PEM_H () {1;}' unless defined(&HEADER_PEM_H);
    require 'openssl/e_os2.ph';
    unless(defined(&OPENSSL_NO_BIO)) {
	require 'openssl/bio.ph';
    }
    unless(defined(&OPENSSL_NO_STACK)) {
	require 'openssl/stack.ph';
    }
    require 'openssl/evp.ph';
    require 'openssl/x509.ph';
    require 'openssl/pem2.ph';
    if(defined(&__cplusplus)) {
    }
    eval 'sub PEM_BUFSIZE () {1024;}' unless defined(&PEM_BUFSIZE);
    eval 'sub PEM_OBJ_UNDEF () {0;}' unless defined(&PEM_OBJ_UNDEF);
    eval 'sub PEM_OBJ_X509 () {1;}' unless defined(&PEM_OBJ_X509);
    eval 'sub PEM_OBJ_X509_REQ () {2;}' unless defined(&PEM_OBJ_X509_REQ);
    eval 'sub PEM_OBJ_CRL () {3;}' unless defined(&PEM_OBJ_CRL);
    eval 'sub PEM_OBJ_SSL_SESSION () {4;}' unless defined(&PEM_OBJ_SSL_SESSION);
    eval 'sub PEM_OBJ_PRIV_KEY () {10;}' unless defined(&PEM_OBJ_PRIV_KEY);
    eval 'sub PEM_OBJ_PRIV_RSA () {11;}' unless defined(&PEM_OBJ_PRIV_RSA);
    eval 'sub PEM_OBJ_PRIV_DSA () {12;}' unless defined(&PEM_OBJ_PRIV_DSA);
    eval 'sub PEM_OBJ_PRIV_DH () {13;}' unless defined(&PEM_OBJ_PRIV_DH);
    eval 'sub PEM_OBJ_PUB_RSA () {14;}' unless defined(&PEM_OBJ_PUB_RSA);
    eval 'sub PEM_OBJ_PUB_DSA () {15;}' unless defined(&PEM_OBJ_PUB_DSA);
    eval 'sub PEM_OBJ_PUB_DH () {16;}' unless defined(&PEM_OBJ_PUB_DH);
    eval 'sub PEM_OBJ_DHPARAMS () {17;}' unless defined(&PEM_OBJ_DHPARAMS);
    eval 'sub PEM_OBJ_DSAPARAMS () {18;}' unless defined(&PEM_OBJ_DSAPARAMS);
    eval 'sub PEM_OBJ_PRIV_RSA_PUBLIC () {19;}' unless defined(&PEM_OBJ_PRIV_RSA_PUBLIC);
    eval 'sub PEM_OBJ_PRIV_ECDSA () {20;}' unless defined(&PEM_OBJ_PRIV_ECDSA);
    eval 'sub PEM_OBJ_PUB_ECDSA () {21;}' unless defined(&PEM_OBJ_PUB_ECDSA);
    eval 'sub PEM_OBJ_ECPARAMETERS () {22;}' unless defined(&PEM_OBJ_ECPARAMETERS);
    eval 'sub PEM_ERROR () {30;}' unless defined(&PEM_ERROR);
    eval 'sub PEM_DEK_DES_CBC () {40;}' unless defined(&PEM_DEK_DES_CBC);
    eval 'sub PEM_DEK_IDEA_CBC () {45;}' unless defined(&PEM_DEK_IDEA_CBC);
    eval 'sub PEM_DEK_DES_EDE () {50;}' unless defined(&PEM_DEK_DES_EDE);
    eval 'sub PEM_DEK_DES_ECB () {60;}' unless defined(&PEM_DEK_DES_ECB);
    eval 'sub PEM_DEK_RSA () {70;}' unless defined(&PEM_DEK_RSA);
    eval 'sub PEM_DEK_RSA_MD2 () {80;}' unless defined(&PEM_DEK_RSA_MD2);
    eval 'sub PEM_DEK_RSA_MD5 () {90;}' unless defined(&PEM_DEK_RSA_MD5);
    eval 'sub PEM_MD_MD2 () { &NID_md2;}' unless defined(&PEM_MD_MD2);
    eval 'sub PEM_MD_MD5 () { &NID_md5;}' unless defined(&PEM_MD_MD5);
    eval 'sub PEM_MD_SHA () { &NID_sha;}' unless defined(&PEM_MD_SHA);
    eval 'sub PEM_MD_MD2_RSA () { &NID_md2WithRSAEncryption;}' unless defined(&PEM_MD_MD2_RSA);
    eval 'sub PEM_MD_MD5_RSA () { &NID_md5WithRSAEncryption;}' unless defined(&PEM_MD_MD5_RSA);
    eval 'sub PEM_MD_SHA_RSA () { &NID_sha1WithRSAEncryption;}' unless defined(&PEM_MD_SHA_RSA);
    eval 'sub PEM_STRING_X509_OLD () {"X509 CERTIFICATE";}' unless defined(&PEM_STRING_X509_OLD);
    eval 'sub PEM_STRING_X509 () {"CERTIFICATE";}' unless defined(&PEM_STRING_X509);
    eval 'sub PEM_STRING_X509_PAIR () {"CERTIFICATE PAIR";}' unless defined(&PEM_STRING_X509_PAIR);
    eval 'sub PEM_STRING_X509_TRUSTED () {"TRUSTED CERTIFICATE";}' unless defined(&PEM_STRING_X509_TRUSTED);
    eval 'sub PEM_STRING_X509_REQ_OLD () {"NEW CERTIFICATE REQUEST";}' unless defined(&PEM_STRING_X509_REQ_OLD);
    eval 'sub PEM_STRING_X509_REQ () {"CERTIFICATE REQUEST";}' unless defined(&PEM_STRING_X509_REQ);
    eval 'sub PEM_STRING_X509_CRL () {"X509 CRL";}' unless defined(&PEM_STRING_X509_CRL);
    eval 'sub PEM_STRING_EVP_PKEY () {"ANY PRIVATE KEY";}' unless defined(&PEM_STRING_EVP_PKEY);
    eval 'sub PEM_STRING_PUBLIC () {"PUBLIC KEY";}' unless defined(&PEM_STRING_PUBLIC);
    eval 'sub PEM_STRING_RSA () {"RSA PRIVATE KEY";}' unless defined(&PEM_STRING_RSA);
    eval 'sub PEM_STRING_RSA_PUBLIC () {"RSA PUBLIC KEY";}' unless defined(&PEM_STRING_RSA_PUBLIC);
    eval 'sub PEM_STRING_DSA () {"DSA PRIVATE KEY";}' unless defined(&PEM_STRING_DSA);
    eval 'sub PEM_STRING_DSA_PUBLIC () {"DSA PUBLIC KEY";}' unless defined(&PEM_STRING_DSA_PUBLIC);
    eval 'sub PEM_STRING_PKCS7 () {"PKCS7";}' unless defined(&PEM_STRING_PKCS7);
    eval 'sub PEM_STRING_PKCS7_SIGNED () {"PKCS #7 SIGNED DATA";}' unless defined(&PEM_STRING_PKCS7_SIGNED);
    eval 'sub PEM_STRING_PKCS8 () {"ENCRYPTED PRIVATE KEY";}' unless defined(&PEM_STRING_PKCS8);
    eval 'sub PEM_STRING_PKCS8INF () {"PRIVATE KEY";}' unless defined(&PEM_STRING_PKCS8INF);
    eval 'sub PEM_STRING_DHPARAMS () {"DH PARAMETERS";}' unless defined(&PEM_STRING_DHPARAMS);
    eval 'sub PEM_STRING_SSL_SESSION () {"SSL SESSION PARAMETERS";}' unless defined(&PEM_STRING_SSL_SESSION);
    eval 'sub PEM_STRING_DSAPARAMS () {"DSA PARAMETERS";}' unless defined(&PEM_STRING_DSAPARAMS);
    eval 'sub PEM_STRING_ECDSA_PUBLIC () {"ECDSA PUBLIC KEY";}' unless defined(&PEM_STRING_ECDSA_PUBLIC);
    eval 'sub PEM_STRING_ECPARAMETERS () {"EC PARAMETERS";}' unless defined(&PEM_STRING_ECPARAMETERS);
    eval 'sub PEM_STRING_ECPRIVATEKEY () {"EC PRIVATE KEY";}' unless defined(&PEM_STRING_ECPRIVATEKEY);
    eval 'sub PEM_STRING_PARAMETERS () {"PARAMETERS";}' unless defined(&PEM_STRING_PARAMETERS);
    eval 'sub PEM_STRING_CMS () {"CMS";}' unless defined(&PEM_STRING_CMS);
    eval 'sub PEM_TYPE_ENCRYPTED () {10;}' unless defined(&PEM_TYPE_ENCRYPTED);
    eval 'sub PEM_TYPE_MIC_ONLY () {20;}' unless defined(&PEM_TYPE_MIC_ONLY);
    eval 'sub PEM_TYPE_MIC_CLEAR () {30;}' unless defined(&PEM_TYPE_MIC_CLEAR);
    eval 'sub PEM_TYPE_CLEAR () {40;}' unless defined(&PEM_TYPE_CLEAR);
    if(defined(&OPENSSL_NO_FP_API)) {
	eval 'sub IMPLEMENT_PEM_read_fp {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_read_fp);
	eval 'sub IMPLEMENT_PEM_write_fp {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_write_fp);
	eval 'sub IMPLEMENT_PEM_write_fp_const {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_write_fp_const);
	eval 'sub IMPLEMENT_PEM_write_cb_fp {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_write_cb_fp);
	eval 'sub IMPLEMENT_PEM_write_cb_fp_const {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q();
	}' unless defined(&IMPLEMENT_PEM_write_cb_fp_const);
    } else {
	eval 'sub IMPLEMENT_PEM_read_fp {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q($type * &PEM_read_$name(\'FILE\' * &fp, $type ** &x,  &pem_password_cb * &cb,  &void * &u){  &return  &PEM_ASN1_read(( &d2i_of_void *) &d2i_$asn1, $str, &fp,( &void **) &x, &cb, &u); });
	}' unless defined(&IMPLEMENT_PEM_read_fp);
	eval 'sub IMPLEMENT_PEM_write_fp {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x) {  &return  &PEM_ASN1_write(( &i2d_of_void *) &i2d_$asn1,$str, &fp, &x, &NULL, &NULL,0, &NULL, &NULL); });
	}' unless defined(&IMPLEMENT_PEM_write_fp);
	eval 'sub IMPLEMENT_PEM_write_fp_const {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp,  &const $type * &x) {  &return  &PEM_ASN1_write(( &i2d_of_void *) &i2d_$asn1,$str, &fp,( &void *) &x, &NULL, &NULL,0, &NULL, &NULL); });
	}' unless defined(&IMPLEMENT_PEM_write_fp_const);
	eval 'sub IMPLEMENT_PEM_write_cb_fp {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u) {  &return  &PEM_ASN1_write(( &i2d_of_void *) &i2d_$asn1,$str, &fp, &x, &enc, &kstr, &klen, &cb, &u); });
	}' unless defined(&IMPLEMENT_PEM_write_cb_fp);
	eval 'sub IMPLEMENT_PEM_write_cb_fp_const {
	    my($name, $type, $str, $asn1) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u) {  &return  &PEM_ASN1_write(( &i2d_of_void *) &i2d_$asn1,$str, &fp, &x, &enc, &kstr, &klen, &cb, &u); });
	}' unless defined(&IMPLEMENT_PEM_write_cb_fp_const);
    }
    eval 'sub IMPLEMENT_PEM_read_bio {
        my($name, $type, $str, $asn1) = @_;
	    eval q($type * &PEM_read_bio_$name( &BIO * &bp, $type ** &x,  &pem_password_cb * &cb,  &void * &u){  &return  &PEM_ASN1_read_bio(( &d2i_of_void *) &d2i_$asn1, $str, &bp,( &void **) &x, &cb, &u); });
    }' unless defined(&IMPLEMENT_PEM_read_bio);
    eval 'sub IMPLEMENT_PEM_write_bio {
        my($name, $type, $str, $asn1) = @_;
	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x) {  &return  &PEM_ASN1_write_bio(( &i2d_of_void *) &i2d_$asn1,$str, &bp, &x, &NULL, &NULL,0, &NULL, &NULL); });
    }' unless defined(&IMPLEMENT_PEM_write_bio);
    eval 'sub IMPLEMENT_PEM_write_bio_const {
        my($name, $type, $str, $asn1) = @_;
	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp,  &const $type * &x) {  &return  &PEM_ASN1_write_bio(( &i2d_of_void *) &i2d_$asn1,$str, &bp,( &void *) &x, &NULL, &NULL,0, &NULL, &NULL); });
    }' unless defined(&IMPLEMENT_PEM_write_bio_const);
    eval 'sub IMPLEMENT_PEM_write_cb_bio {
        my($name, $type, $str, $asn1) = @_;
	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u) {  &return  &PEM_ASN1_write_bio(( &i2d_of_void *) &i2d_$asn1,$str, &bp, &x, &enc, &kstr, &klen, &cb, &u); });
    }' unless defined(&IMPLEMENT_PEM_write_cb_bio);
    eval 'sub IMPLEMENT_PEM_write_cb_bio_const {
        my($name, $type, $str, $asn1) = @_;
	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u) {  &return  &PEM_ASN1_write_bio(( &i2d_of_void *) &i2d_$asn1,$str, &bp,( &void *) &x, &enc, &kstr, &klen, &cb, &u); });
    }' unless defined(&IMPLEMENT_PEM_write_cb_bio_const);
    eval 'sub IMPLEMENT_PEM_write {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_write_bio($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_fp($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_write);
    eval 'sub IMPLEMENT_PEM_write_const {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_write_bio_const($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_fp_const($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_write_const);
    eval 'sub IMPLEMENT_PEM_write_cb {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_write_cb_bio($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_cb_fp($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_write_cb);
    eval 'sub IMPLEMENT_PEM_write_cb_const {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_write_cb_bio_const($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_cb_fp_const($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_write_cb_const);
    eval 'sub IMPLEMENT_PEM_read {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_read_bio($name, $type, $str, $asn1)  &IMPLEMENT_PEM_read_fp($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_read);
    eval 'sub IMPLEMENT_PEM_rw {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_read($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_rw);
    eval 'sub IMPLEMENT_PEM_rw_const {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_read($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_const($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_rw_const);
    eval 'sub IMPLEMENT_PEM_rw_cb {
        my($name, $type, $str, $asn1) = @_;
	    eval q( &IMPLEMENT_PEM_read($name, $type, $str, $asn1)  &IMPLEMENT_PEM_write_cb($name, $type, $str, $asn1));
    }' unless defined(&IMPLEMENT_PEM_rw_cb);
    if(defined(&OPENSSL_NO_FP_API)) {
	eval 'sub DECLARE_PEM_read_fp {
	    my($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_read_fp);
	eval 'sub DECLARE_PEM_write_fp {
	    my($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_fp);
	eval 'sub DECLARE_PEM_write_cb_fp {
	    my($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_cb_fp);
    } else {
	eval 'sub DECLARE_PEM_read_fp {
	    my($name, $type) = @_;
    	    eval q($type * &PEM_read_$name(\'FILE\' * &fp, $type ** &x,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_read_fp);
	eval 'sub DECLARE_PEM_write_fp {
	    my($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x););
	}' unless defined(&DECLARE_PEM_write_fp);
	eval 'sub DECLARE_PEM_write_fp_const {
	    my($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp,  &const $type * &x););
	}' unless defined(&DECLARE_PEM_write_fp_const);
	eval 'sub DECLARE_PEM_write_cb_fp {
	    my($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_$name(\'FILE\' * &fp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_write_cb_fp);
    }
    unless(defined(&OPENSSL_NO_BIO)) {
	eval 'sub DECLARE_PEM_read_bio {
	    my($name, $type) = @_;
    	    eval q($type * &PEM_read_bio_$name( &BIO * &bp, $type ** &x,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_read_bio);
	eval 'sub DECLARE_PEM_write_bio {
	    my($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x););
	}' unless defined(&DECLARE_PEM_write_bio);
	eval 'sub DECLARE_PEM_write_bio_const {
	    my($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp,  &const $type * &x););
	}' unless defined(&DECLARE_PEM_write_bio_const);
	eval 'sub DECLARE_PEM_write_cb_bio {
	    my($name, $type) = @_;
    	    eval q(\'int\'  &PEM_write_bio_$name( &BIO * &bp, $type * &x,  &const  &EVP_CIPHER * &enc, \'unsigned char\' * &kstr, \'int\'  &klen,  &pem_password_cb * &cb,  &void * &u););
	}' unless defined(&DECLARE_PEM_write_cb_bio);
    } else {
	eval 'sub DECLARE_PEM_read_bio {
	    my($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_read_bio);
	eval 'sub DECLARE_PEM_write_bio {
	    my($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_bio);
	eval 'sub DECLARE_PEM_write_bio_const {
	    my($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_bio_const);
	eval 'sub DECLARE_PEM_write_cb_bio {
	    my($name, $type) = @_;
    	    eval q();
	}' unless defined(&DECLARE_PEM_write_cb_bio);
    }
    eval 'sub DECLARE_PEM_write {
        my($name, $type) = @_;
	    eval q( &DECLARE_PEM_write_bio($name, $type)  &DECLARE_PEM_write_fp($name, $type));
    }' unless defined(&DECLARE_PEM_write);
    eval 'sub DECLARE_PEM_write_const {
        my($name, $type) = @_;
	    eval q( &DECLARE_PEM_write_bio_const($name, $type)  &DECLARE_PEM_write_fp_const($name, $type));
    }' unless defined(&DECLARE_PEM_write_const);
    eval 'sub DECLARE_PEM_write_cb {
        my($name, $type) = @_;
	    eval q( &DECLARE_PEM_write_cb_bio($name, $type)  &DECLARE_PEM_write_cb_fp($name, $type));
    }' unless defined(&DECLARE_PEM_write_cb);
    eval 'sub DECLARE_PEM_read {
        my($name, $type) = @_;
	    eval q( &DECLARE_PEM_read_bio($name, $type)  &DECLARE_PEM_read_fp($name, $type));
    }' unless defined(&DECLARE_PEM_read);
    eval 'sub DECLARE_PEM_rw {
        my($name, $type) = @_;
	    eval q( &DECLARE_PEM_read($name, $type)  &DECLARE_PEM_write($name, $type));
    }' unless defined(&DECLARE_PEM_rw);
    eval 'sub DECLARE_PEM_rw_const {
        my($name, $type) = @_;
	    eval q( &DECLARE_PEM_read($name, $type)  &DECLARE_PEM_write_const($name, $type));
    }' unless defined(&DECLARE_PEM_rw_const);
    eval 'sub DECLARE_PEM_rw_cb {
        my($name, $type) = @_;
	    eval q( &DECLARE_PEM_read($name, $type)  &DECLARE_PEM_write_cb($name, $type));
    }' unless defined(&DECLARE_PEM_rw_cb);
    if(1) {
    } else {
    }
    unless(defined(&OPENSSL_NO_BIO)) {
    }
    require 'openssl/symhacks.ph';
    unless(defined(&OPENSSL_NO_RSA)) {
    }
    unless(defined(&OPENSSL_NO_DSA)) {
    }
    unless(defined(&OPENSSL_NO_EC)) {
    }
    unless(defined(&OPENSSL_NO_DH)) {
    }
    unless(defined(&OPENSSL_NO_RC4)) {
    }
    eval 'sub PEM_F_B2I_DSS () {127;}' unless defined(&PEM_F_B2I_DSS);
    eval 'sub PEM_F_B2I_PVK_BIO () {128;}' unless defined(&PEM_F_B2I_PVK_BIO);
    eval 'sub PEM_F_B2I_RSA () {129;}' unless defined(&PEM_F_B2I_RSA);
    eval 'sub PEM_F_CHECK_BITLEN_DSA () {130;}' unless defined(&PEM_F_CHECK_BITLEN_DSA);
    eval 'sub PEM_F_CHECK_BITLEN_RSA () {131;}' unless defined(&PEM_F_CHECK_BITLEN_RSA);
    eval 'sub PEM_F_D2I_PKCS8PRIVATEKEY_BIO () {120;}' unless defined(&PEM_F_D2I_PKCS8PRIVATEKEY_BIO);
    eval 'sub PEM_F_D2I_PKCS8PRIVATEKEY_FP () {121;}' unless defined(&PEM_F_D2I_PKCS8PRIVATEKEY_FP);
    eval 'sub PEM_F_DO_B2I () {132;}' unless defined(&PEM_F_DO_B2I);
    eval 'sub PEM_F_DO_B2I_BIO () {133;}' unless defined(&PEM_F_DO_B2I_BIO);
    eval 'sub PEM_F_DO_BLOB_HEADER () {134;}' unless defined(&PEM_F_DO_BLOB_HEADER);
    eval 'sub PEM_F_DO_PK8PKEY () {126;}' unless defined(&PEM_F_DO_PK8PKEY);
    eval 'sub PEM_F_DO_PK8PKEY_FP () {125;}' unless defined(&PEM_F_DO_PK8PKEY_FP);
    eval 'sub PEM_F_DO_PVK_BODY () {135;}' unless defined(&PEM_F_DO_PVK_BODY);
    eval 'sub PEM_F_DO_PVK_HEADER () {136;}' unless defined(&PEM_F_DO_PVK_HEADER);
    eval 'sub PEM_F_I2B_PVK () {137;}' unless defined(&PEM_F_I2B_PVK);
    eval 'sub PEM_F_I2B_PVK_BIO () {138;}' unless defined(&PEM_F_I2B_PVK_BIO);
    eval 'sub PEM_F_LOAD_IV () {101;}' unless defined(&PEM_F_LOAD_IV);
    eval 'sub PEM_F_PEM_ASN1_READ () {102;}' unless defined(&PEM_F_PEM_ASN1_READ);
    eval 'sub PEM_F_PEM_ASN1_READ_BIO () {103;}' unless defined(&PEM_F_PEM_ASN1_READ_BIO);
    eval 'sub PEM_F_PEM_ASN1_WRITE () {104;}' unless defined(&PEM_F_PEM_ASN1_WRITE);
    eval 'sub PEM_F_PEM_ASN1_WRITE_BIO () {105;}' unless defined(&PEM_F_PEM_ASN1_WRITE_BIO);
    eval 'sub PEM_F_PEM_DEF_CALLBACK () {100;}' unless defined(&PEM_F_PEM_DEF_CALLBACK);
    eval 'sub PEM_F_PEM_DO_HEADER () {106;}' unless defined(&PEM_F_PEM_DO_HEADER);
    eval 'sub PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY () {118;}' unless defined(&PEM_F_PEM_F_PEM_WRITE_PKCS8PRIVATEKEY);
    eval 'sub PEM_F_PEM_GET_EVP_CIPHER_INFO () {107;}' unless defined(&PEM_F_PEM_GET_EVP_CIPHER_INFO);
    eval 'sub PEM_F_PEM_PK8PKEY () {119;}' unless defined(&PEM_F_PEM_PK8PKEY);
    eval 'sub PEM_F_PEM_READ () {108;}' unless defined(&PEM_F_PEM_READ);
    eval 'sub PEM_F_PEM_READ_BIO () {109;}' unless defined(&PEM_F_PEM_READ_BIO);
    eval 'sub PEM_F_PEM_READ_BIO_PARAMETERS () {140;}' unless defined(&PEM_F_PEM_READ_BIO_PARAMETERS);
    eval 'sub PEM_F_PEM_READ_BIO_PRIVATEKEY () {123;}' unless defined(&PEM_F_PEM_READ_BIO_PRIVATEKEY);
    eval 'sub PEM_F_PEM_READ_PRIVATEKEY () {124;}' unless defined(&PEM_F_PEM_READ_PRIVATEKEY);
    eval 'sub PEM_F_PEM_SEALFINAL () {110;}' unless defined(&PEM_F_PEM_SEALFINAL);
    eval 'sub PEM_F_PEM_SEALINIT () {111;}' unless defined(&PEM_F_PEM_SEALINIT);
    eval 'sub PEM_F_PEM_SIGNFINAL () {112;}' unless defined(&PEM_F_PEM_SIGNFINAL);
    eval 'sub PEM_F_PEM_WRITE () {113;}' unless defined(&PEM_F_PEM_WRITE);
    eval 'sub PEM_F_PEM_WRITE_BIO () {114;}' unless defined(&PEM_F_PEM_WRITE_BIO);
    eval 'sub PEM_F_PEM_WRITE_PRIVATEKEY () {139;}' unless defined(&PEM_F_PEM_WRITE_PRIVATEKEY);
    eval 'sub PEM_F_PEM_X509_INFO_READ () {115;}' unless defined(&PEM_F_PEM_X509_INFO_READ);
    eval 'sub PEM_F_PEM_X509_INFO_READ_BIO () {116;}' unless defined(&PEM_F_PEM_X509_INFO_READ_BIO);
    eval 'sub PEM_F_PEM_X509_INFO_WRITE_BIO () {117;}' unless defined(&PEM_F_PEM_X509_INFO_WRITE_BIO);
    eval 'sub PEM_R_BAD_BASE64_DECODE () {100;}' unless defined(&PEM_R_BAD_BASE64_DECODE);
    eval 'sub PEM_R_BAD_DECRYPT () {101;}' unless defined(&PEM_R_BAD_DECRYPT);
    eval 'sub PEM_R_BAD_END_LINE () {102;}' unless defined(&PEM_R_BAD_END_LINE);
    eval 'sub PEM_R_BAD_IV_CHARS () {103;}' unless defined(&PEM_R_BAD_IV_CHARS);
    eval 'sub PEM_R_BAD_MAGIC_NUMBER () {116;}' unless defined(&PEM_R_BAD_MAGIC_NUMBER);
    eval 'sub PEM_R_BAD_PASSWORD_READ () {104;}' unless defined(&PEM_R_BAD_PASSWORD_READ);
    eval 'sub PEM_R_BAD_VERSION_NUMBER () {117;}' unless defined(&PEM_R_BAD_VERSION_NUMBER);
    eval 'sub PEM_R_BIO_WRITE_FAILURE () {118;}' unless defined(&PEM_R_BIO_WRITE_FAILURE);
    eval 'sub PEM_R_CIPHER_IS_NULL () {127;}' unless defined(&PEM_R_CIPHER_IS_NULL);
    eval 'sub PEM_R_ERROR_CONVERTING_PRIVATE_KEY () {115;}' unless defined(&PEM_R_ERROR_CONVERTING_PRIVATE_KEY);
    eval 'sub PEM_R_EXPECTING_PRIVATE_KEY_BLOB () {119;}' unless defined(&PEM_R_EXPECTING_PRIVATE_KEY_BLOB);
    eval 'sub PEM_R_EXPECTING_PUBLIC_KEY_BLOB () {120;}' unless defined(&PEM_R_EXPECTING_PUBLIC_KEY_BLOB);
    eval 'sub PEM_R_INCONSISTENT_HEADER () {121;}' unless defined(&PEM_R_INCONSISTENT_HEADER);
    eval 'sub PEM_R_KEYBLOB_HEADER_PARSE_ERROR () {122;}' unless defined(&PEM_R_KEYBLOB_HEADER_PARSE_ERROR);
    eval 'sub PEM_R_KEYBLOB_TOO_SHORT () {123;}' unless defined(&PEM_R_KEYBLOB_TOO_SHORT);
    eval 'sub PEM_R_NOT_DEK_INFO () {105;}' unless defined(&PEM_R_NOT_DEK_INFO);
    eval 'sub PEM_R_NOT_ENCRYPTED () {106;}' unless defined(&PEM_R_NOT_ENCRYPTED);
    eval 'sub PEM_R_NOT_PROC_TYPE () {107;}' unless defined(&PEM_R_NOT_PROC_TYPE);
    eval 'sub PEM_R_NO_START_LINE () {108;}' unless defined(&PEM_R_NO_START_LINE);
    eval 'sub PEM_R_PROBLEMS_GETTING_PASSWORD () {109;}' unless defined(&PEM_R_PROBLEMS_GETTING_PASSWORD);
    eval 'sub PEM_R_PUBLIC_KEY_NO_RSA () {110;}' unless defined(&PEM_R_PUBLIC_KEY_NO_RSA);
    eval 'sub PEM_R_PVK_DATA_TOO_SHORT () {124;}' unless defined(&PEM_R_PVK_DATA_TOO_SHORT);
    eval 'sub PEM_R_PVK_TOO_SHORT () {125;}' unless defined(&PEM_R_PVK_TOO_SHORT);
    eval 'sub PEM_R_READ_KEY () {111;}' unless defined(&PEM_R_READ_KEY);
    eval 'sub PEM_R_SHORT_HEADER () {112;}' unless defined(&PEM_R_SHORT_HEADER);
    eval 'sub PEM_R_UNSUPPORTED_CIPHER () {113;}' unless defined(&PEM_R_UNSUPPORTED_CIPHER);
    eval 'sub PEM_R_UNSUPPORTED_ENCRYPTION () {114;}' unless defined(&PEM_R_UNSUPPORTED_ENCRYPTION);
    eval 'sub PEM_R_UNSUPPORTED_KEY_COMPONENTS () {126;}' unless defined(&PEM_R_UNSUPPORTED_KEY_COMPONENTS);
    if(defined(&__cplusplus)) {
    }
}
1;
