/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.FixedField;
import org.apache.poi.util.LittleEndian;

public class ByteField
implements FixedField {
    private static final byte _default_value = 0;
    private byte _value;
    private final int _offset;

    public ByteField(int n) throws ArrayIndexOutOfBoundsException {
        this(n, 0);
    }

    public ByteField(int n, byte by) throws ArrayIndexOutOfBoundsException {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("offset cannot be negative");
        }
        this._offset = n;
        this.set(by);
    }

    public ByteField(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.readFromBytes(byArray);
    }

    public ByteField(int n, byte by, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n, by);
        this.writeToBytes(byArray);
    }

    public byte get() {
        return this._value;
    }

    public void set(byte by) {
        this._value = by;
    }

    public void set(byte by, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this.set(by);
        this.writeToBytes(byArray);
    }

    public void readFromBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = byArray[this._offset];
    }

    public void readFromStream(InputStream inputStream) throws LittleEndian.BufferUnderrunException, IOException {
        this._value = LittleEndian.readFromStream(inputStream, 1)[0];
    }

    public void writeToBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        byArray[this._offset] = this._value;
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

