/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.io.amf;

import flex.messaging.io.MessageSerializer;
import flex.messaging.io.SerializationContext;
import flex.messaging.io.amf.ActionMessage;
import flex.messaging.io.amf.Amf0Output;
import flex.messaging.io.amf.AmfTrace;
import flex.messaging.io.amf.MessageBody;
import flex.messaging.io.amf.MessageHeader;
import java.io.IOException;
import java.io.OutputStream;

public class AmfMessageSerializer
implements MessageSerializer {
    public static final int UNKNOWN_CONTENT_LENGTH = -1;
    protected Amf0Output amfOut;
    protected boolean isDebug;
    protected AmfTrace debugTrace;
    protected int version;

    public void setVersion(int value) {
        this.version = value;
    }

    public void initialize(SerializationContext context, OutputStream out, AmfTrace trace) {
        this.amfOut = new Amf0Output(context);
        this.amfOut.setOutputStream(out);
        this.amfOut.setAvmPlus(this.version > 0);
        this.debugTrace = trace;
        this.isDebug = trace != null;
        this.amfOut.setDebugTrace(this.debugTrace);
    }

    public void writeMessage(ActionMessage m) throws IOException {
        int version;
        if (this.isDebug) {
            this.debugTrace.startResponse("Serializing AMF/HTTP response");
        }
        this.amfOut.setAvmPlus((version = m.getVersion()) > 0);
        this.amfOut.writeShort(version);
        if (this.isDebug) {
            this.debugTrace.version(version);
        }
        int headerCount = m.getHeaderCount();
        this.amfOut.writeShort(headerCount);
        for (int i = 0; i < headerCount; ++i) {
            MessageHeader header = m.getHeader(i);
            if (this.isDebug) {
                this.debugTrace.startHeader(header.getName(), header.getMustUnderstand(), i);
            }
            this.writeHeader(header);
            if (!this.isDebug) continue;
            this.debugTrace.endHeader();
        }
        int bodyCount = m.getBodyCount();
        this.amfOut.writeShort(bodyCount);
        for (int i = 0; i < bodyCount; ++i) {
            MessageBody body = m.getBody(i);
            if (this.isDebug) {
                this.debugTrace.startMessage(body.getTargetURI(), body.getResponseURI(), i);
            }
            this.writeBody(body);
            if (!this.isDebug) continue;
            this.debugTrace.endMessage();
        }
    }

    public void writeHeader(MessageHeader h) throws IOException {
        this.amfOut.writeUTF(h.getName());
        this.amfOut.writeBoolean(h.getMustUnderstand());
        this.amfOut.writeInt(-1);
        this.amfOut.reset();
        this.writeObject(h.getData());
    }

    public void writeBody(MessageBody b) throws IOException {
        if (b.getTargetURI() == null) {
            this.amfOut.writeUTF("null");
        } else {
            this.amfOut.writeUTF(b.getTargetURI());
        }
        if (b.getResponseURI() == null) {
            this.amfOut.writeUTF("null");
        } else {
            this.amfOut.writeUTF(b.getResponseURI());
        }
        this.amfOut.writeInt(-1);
        this.amfOut.reset();
        Object data = b.getData();
        this.writeObject(data);
    }

    public void writeObject(Object value) throws IOException {
        this.amfOut.writeObject(value);
    }
}

