/*
 * Decompiled with CFR 0.152.
 */
package org.h2.test.synth;

import java.sql.SQLException;
import java.util.HashMap;
import org.h2.test.synth.Column;
import org.h2.test.synth.DbInterface;
import org.h2.test.synth.Expression;
import org.h2.test.synth.Index;
import org.h2.test.synth.Result;
import org.h2.test.synth.Table;
import org.h2.test.synth.TestSynth;
import org.h2.test.synth.Value;

class Command {
    TestSynth config;
    static final int CONNECT = 0;
    static final int RESET = 1;
    static final int DISCONNECT = 2;
    static final int CREATE_TABLE = 3;
    static final int INSERT = 4;
    static final int DROP_TABLE = 5;
    static final int SELECT = 6;
    static final int DELETE = 7;
    static final int UPDATE = 8;
    static final int COMMIT = 9;
    static final int ROLLBACK = 10;
    static final int AUTOCOMMIT_ON = 11;
    static final int AUTOCOMMIT_OFF = 12;
    static final int CREATE_INDEX = 13;
    static final int DROP_INDEX = 14;
    static final int END = 15;
    private int type;
    private Table table;
    private HashMap tables;
    private Index index;
    private Column[] columns;
    private Value[] values;
    private String condition;
    private int nextAlias;
    private String order;
    String[] selectList;
    private String join = "";
    private Result result;

    static Command getDropTable(TestSynth config, Table table) {
        return new Command(config, 5, table);
    }

    Command getCommit(TestSynth config) {
        return new Command(config, 9);
    }

    Command getRollback(TestSynth config) {
        return new Command(config, 10);
    }

    Command getSetAutoCommit(TestSynth config, boolean auto) {
        int type = auto ? 11 : 12;
        return new Command(config, type);
    }

    static Command getConnect(TestSynth config) {
        return new Command(config, 0);
    }

    static Command getReset(TestSynth config) {
        return new Command(config, 1);
    }

    static Command getDisconnect(TestSynth config) {
        return new Command(config, 2);
    }

    static Command getEnd(TestSynth config) {
        return new Command(config, 15);
    }

    static Command getCreateTable(TestSynth config, Table table) {
        return new Command(config, 3, table);
    }

    static Command getCreateIndex(TestSynth config, Index index) {
        return new Command(config, 13, index);
    }

    static Command getRandomSelect(TestSynth config, Table table) {
        Command command = new Command(config, 6, table, "M");
        command.selectList = Expression.getRandomSelectList(config, command);
        command.condition = Expression.getRandomCondition(config, command).getSQL();
        command.order = Expression.getRandomOrder(config, command);
        return command;
    }

    static Command getRandomSelectJoin(TestSynth config, Table table) {
        Command command = new Command(config, 6, table, "M");
        int len = config.random().getLog(5) + 1;
        String globalJoinCondition = "";
        for (int i = 0; i < len; ++i) {
            Table t2 = config.randomTable();
            String alias = "J" + i;
            command.addSubqueryTable(alias, t2);
            Expression joinOn = Expression.getRandomJoinOn(config, command, alias);
            if (config.random().getBoolean(50)) {
                if (globalJoinCondition.length() > 0) {
                    globalJoinCondition = globalJoinCondition + " AND ";
                }
                globalJoinCondition = globalJoinCondition + " (" + joinOn.getSQL() + ") ";
                command.addJoin(", " + t2.getName() + " " + alias);
                continue;
            }
            String join = " JOIN " + t2.getName() + " " + alias + " ON " + joinOn.getSQL();
            if (config.random().getBoolean(20)) {
                command.addJoin(" LEFT OUTER" + join);
                continue;
            }
            command.addJoin(" INNER" + join);
        }
        command.selectList = Expression.getRandomSelectList(config, command);
        String cond = Expression.getRandomCondition(config, command).getSQL();
        if (globalJoinCondition.length() > 0) {
            cond = cond != null ? "(" + globalJoinCondition + " ) AND (" + cond + ")" : globalJoinCondition;
        }
        command.condition = cond;
        command.order = Expression.getRandomOrder(config, command);
        return command;
    }

    static Command getRandomDelete(TestSynth config, Table table) {
        Command command = new Command(config, 7, table);
        command.condition = Expression.getRandomCondition(config, command).getSQL();
        return command;
    }

    static Command getRandomUpdate(TestSynth config, Table table) {
        Command command = new Command(config, 8, table);
        command.prepareUpdate();
        return command;
    }

    static Command getRandomInsert(TestSynth config, Table table) {
        Command command = new Command(config, 4, table);
        command.prepareInsert();
        return command;
    }

    private Command(TestSynth config, int type) {
        this.config = config;
        this.type = type;
    }

    private Command(TestSynth config, int type, Table table) {
        this.config = config;
        this.type = type;
        this.table = table;
    }

    private Command(TestSynth config, int type, Table table, String alias) {
        this.config = config;
        this.type = type;
        this.table = table;
        this.tables = new HashMap();
        this.tables.put(alias, table);
    }

    private Command(TestSynth config, int type, Index index) {
        this.config = config;
        this.type = type;
        this.index = index;
    }

    Command(int type, String alias, Table table) {
        this.type = type;
        if (alias == null) {
            alias = table.getName();
        }
        this.addSubqueryTable(alias, table);
        this.table = table;
    }

    void addSubqueryTable(String alias, Table t) {
        this.tables.put(alias, t);
    }

    void removeSubqueryTable(String alias) {
        this.tables.remove(alias);
    }

    void prepareInsert() {
        Column[] c;
        if (this.config.random().getBoolean(70)) {
            c = this.table.getColumns();
        } else {
            int len = this.config.random().getInt(this.table.getColumnCount() - 1) + 1;
            this.columns = this.table.getRandomColumns(len);
            c = this.columns;
        }
        this.values = new Value[c.length];
        for (int i = 0; i < c.length; ++i) {
            this.values[i] = c[i].getRandomValue();
        }
    }

    void prepareUpdate() {
        int len = this.config.random().getLog(this.table.getColumnCount() - 1) + 1;
        this.columns = this.table.getRandomColumns(len);
        Column[] c = this.columns;
        this.values = new Value[c.length];
        for (int i = 0; i < c.length; ++i) {
            this.values[i] = c[i].getRandomValue();
        }
        this.condition = Expression.getRandomCondition(this.config, this).getSQL();
    }

    private Result select(DbInterface db) throws SQLException {
        String sql = "SELECT ";
        for (int i = 0; i < this.selectList.length; ++i) {
            if (i > 0) {
                sql = sql + ", ";
            }
            sql = sql + this.selectList[i];
        }
        sql = sql + "  FROM " + this.table.getName() + " M";
        sql = sql + " " + this.join;
        if (this.condition != null) {
            sql = sql + "  WHERE " + this.condition;
        }
        if (this.order.trim().length() > 0) {
            sql = sql + "  ORDER BY " + this.order;
        }
        return db.select(sql);
    }

    Result run(DbInterface db) throws Exception {
        try {
            switch (this.type) {
                case 0: {
                    db.connect();
                    this.result = new Result("connect");
                    break;
                }
                case 1: {
                    db.reset();
                    this.result = new Result("reset");
                    break;
                }
                case 2: {
                    db.disconnect();
                    this.result = new Result("disconnect");
                    break;
                }
                case 15: {
                    db.end();
                    this.result = new Result("disconnect");
                    break;
                }
                case 3: {
                    db.createTable(this.table);
                    this.result = new Result("createTable");
                    break;
                }
                case 5: {
                    db.dropTable(this.table);
                    this.result = new Result("dropTable");
                    break;
                }
                case 13: {
                    db.createIndex(this.index);
                    this.result = new Result("createIndex");
                    break;
                }
                case 14: {
                    db.dropIndex(this.index);
                    this.result = new Result("dropIndex");
                    break;
                }
                case 4: {
                    this.result = db.insert(this.table, this.columns, this.values);
                    break;
                }
                case 6: {
                    this.result = this.select(db);
                    break;
                }
                case 7: {
                    this.result = db.delete(this.table, this.condition);
                    break;
                }
                case 8: {
                    this.result = db.update(this.table, this.columns, this.values, this.condition);
                    break;
                }
                case 11: {
                    db.setAutoCommit(true);
                    this.result = new Result("setAutoCommit true");
                    break;
                }
                case 12: {
                    db.setAutoCommit(false);
                    this.result = new Result("setAutoCommit false");
                    break;
                }
                case 9: {
                    db.commit();
                    this.result = new Result("commit");
                    break;
                }
                case 10: {
                    db.rollback();
                    this.result = new Result("rollback");
                    break;
                }
                default: {
                    throw new Error("internal");
                }
            }
        }
        catch (SQLException e) {
            this.result = new Result("", e);
        }
        return this.result;
    }

    public String getNextTableAlias() {
        return "S" + this.nextAlias++;
    }

    public String getRandomTableAlias() {
        if (this.tables == null) {
            return null;
        }
        Object[] list = this.tables.keySet().toArray();
        int i = this.config.random().getInt(list.length);
        return (String)list[i];
    }

    public Table getTable(String alias) {
        if (alias == null) {
            return this.table;
        }
        return (Table)this.tables.get(alias);
    }

    public void addJoin(String string) {
        this.join = this.join + string;
    }

    static Command getSelectAll(TestSynth config, Table table) {
        Command command = new Command(config, 6, table, "M");
        command.selectList = new String[]{"*"};
        command.order = "";
        return command;
    }
}

