/*
 * Decompiled with CFR 0.152.
 */
package org.h2.engine;

import java.sql.SQLException;
import org.h2.api.Trigger;
import org.h2.command.Parser;
import org.h2.engine.Schema;
import org.h2.engine.SchemaObject;
import org.h2.engine.Session;
import org.h2.jdbc.JdbcConnection;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.table.Table;
import org.h2.value.Value;

public class TriggerObject
extends SchemaObject {
    public static final int INSERT = 0;
    public static final int UPDATE = 1;
    public static final int DELETE = 2;
    public static final int DEFAULT_QUEUE_SIZE = 1024;
    private boolean before;
    private int type;
    private boolean rowBased;
    private int queueSize = 1024;
    private boolean noWait;
    private Table table;
    private String triggerClassName;
    private Trigger triggerCallback;

    public TriggerObject(Schema schema, int id, String name, Table table) {
        super(schema, id, name, "trigger");
        this.table = table;
        this.setTemporary(table.getTemporary());
    }

    public void setBefore(boolean before) {
        this.before = before;
    }

    public void setTriggerClassName(String triggerClassName) throws SQLException {
        this.triggerClassName = triggerClassName;
        try {
            Object obj = Class.forName(triggerClassName).newInstance();
            this.triggerCallback = (Trigger)obj;
            this.triggerCallback.init(this.getName(), this.table.getName());
        }
        catch (Throwable e) {
            throw Message.getSQLException(90043, new String[]{this.getName(), triggerClassName}, e);
        }
    }

    public void fire(Session session, boolean beforeAction) throws SQLException {
        if (this.rowBased || this.before != beforeAction) {
            return;
        }
        JdbcConnection c2 = new JdbcConnection(session, session.getUser().getName());
        try {
            this.triggerCallback.fire(c2, null, null);
        }
        catch (Throwable e) {
            throw Message.getSQLException(90044, new String[]{this.getName(), this.triggerClassName}, e);
        }
    }

    private Object[] convertToObjectList(Row row) throws SQLException {
        int len = row.getColumnCount();
        Object[] list = new Object[len];
        for (int i = 0; i < len; ++i) {
            list[i] = row.getValue(i).getObject();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void fireRow(Session session, Row oldRow, Row newRow, boolean beforeAction) throws SQLException {
        Object[] newListBackup;
        void var6_6;
        if (!this.rowBased || this.before != beforeAction) {
            return;
        }
        switch (this.type) {
            case 0: {
                if (oldRow != null || newRow == null) {
                    return;
                }
                Object[] oldList = null;
                Object[] newList = this.convertToObjectList(newRow);
                break;
            }
            case 1: {
                if (oldRow == null || newRow == null) {
                    return;
                }
                Object[] oldList = this.convertToObjectList(oldRow);
                Object[] newList = this.convertToObjectList(newRow);
                break;
            }
            case 2: {
                if (oldRow == null || newRow != null) {
                    return;
                }
                Object[] oldList = this.convertToObjectList(oldRow);
                Object[] newList = null;
                break;
            }
            default: {
                throw Message.internal("type=" + this.type);
            }
        }
        if (this.before && var6_6 != null) {
            newListBackup = new Object[((void)var6_6).length];
            for (int i = 0; i < ((void)var6_6).length; ++i) {
                newListBackup[i] = var6_6[i];
            }
        } else {
            newListBackup = null;
        }
        JdbcConnection c2 = new JdbcConnection(session, session.getUser().getName());
        boolean old = session.getAutoCommit();
        try {
            void var5_5;
            session.setAutoCommit(false);
            this.triggerCallback.fire(c2, (Object[])var5_5, (Object[])var6_6);
            if (newListBackup != null) {
                for (int i = 0; i < ((void)var6_6).length; ++i) {
                    void o = var6_6[i];
                    if (o == newListBackup[i]) continue;
                    Value v = session.convertToValue(o);
                    newRow.setValue(i, v);
                }
            }
        }
        finally {
            session.setAutoCommit(old);
        }
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setRowBased(boolean rowBased) {
        this.rowBased = rowBased;
    }

    public void setQueueSize(int size) {
        this.queueSize = size;
    }

    public void setNoWait(boolean noWait) {
        this.noWait = noWait;
    }

    public String getCreateSQLForCopy(Table table, String quotedTable, String quotedName) {
        StringBuffer buff = new StringBuffer();
        buff.append("CREATE TRIGGER ");
        buff.append(this.getSQL());
        if (this.before) {
            buff.append(" BEFORE");
        } else {
            buff.append(" AFTER");
        }
        switch (this.type) {
            case 0: {
                buff.append(" INSERT");
                break;
            }
            case 1: {
                buff.append(" UPDATE");
                break;
            }
            case 2: {
                buff.append(" DELETE");
                break;
            }
            default: {
                throw Message.internal("type=" + this.type);
            }
        }
        buff.append(" ON ");
        buff.append(table.getSQL());
        if (this.rowBased) {
            buff.append(" FOR EACH ROW");
        }
        if (this.noWait) {
            buff.append(" NOWAIT");
        } else {
            buff.append(" QUEUE ");
            buff.append(this.queueSize);
        }
        buff.append(" CALL ");
        buff.append(Parser.quoteIdentifier(this.triggerClassName));
        return buff.toString();
    }

    public String getCreateSQL() {
        return this.getCreateSQLForCopy(this.table, this.table.getSQL(), this.getSQL());
    }

    public int getType() {
        return 4;
    }

    public void removeChildrenAndResources(Session session) {
        this.table.removeTrigger(session, this);
        this.table = null;
        this.triggerClassName = null;
        this.triggerCallback = null;
        this.invalidate();
    }

    public void checkRename() {
    }

    public Table getTable() {
        return this.table;
    }
}

