/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.dml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.engine.Database;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.store.DataHandler;
import org.h2.store.FileStore;
import org.h2.store.FileStoreInputStream;
import org.h2.store.FileStoreOutputStream;
import org.h2.util.FileUtils;

public class ScriptBase
extends Prepared
implements DataHandler {
    private String cipher;
    private byte[] key;
    private FileStore store;
    private FileOutputStream outStream;
    private FileInputStream inStream;
    protected OutputStream out;
    protected InputStream in;
    protected String fileName;

    public ScriptBase(Parser parser) {
        super(parser);
    }

    public void setCipher(String c) {
        this.cipher = c;
    }

    protected boolean isEncrypted() {
        return this.cipher != null;
    }

    public void setPassword(char[] password) {
        SHA256 sha = new SHA256();
        this.key = sha.getKeyPasswordHash("script", password);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean isTransactional() {
        return false;
    }

    protected void deleteStore() throws SQLException {
        if (this.fileName != null) {
            FileUtils.delete(this.fileName);
        }
    }

    private void initStore() throws SQLException {
        byte[] magic = Database.getMagic(true);
        Database db = this.session.getDatabase();
        this.store = FileStore.open(db, this.fileName, magic, this.cipher, this.key);
        this.store.init();
    }

    protected void openOutput() throws SQLException {
        if (this.fileName == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.out = new FileStoreOutputStream(this.store, this);
        } else {
            try {
                this.outStream = FileUtils.openFileOutputStream(new File(this.fileName));
            }
            catch (IOException e) {
                throw Message.convert(e);
            }
            this.out = new BufferedOutputStream(this.outStream, 4096);
        }
    }

    protected void openInput() throws SQLException {
        if (this.fileName == null) {
            return;
        }
        if (this.isEncrypted()) {
            this.initStore();
            this.in = new FileStoreInputStream(this.store, this);
        } else {
            try {
                this.inStream = new FileInputStream(this.fileName);
            }
            catch (IOException e) {
                throw Message.convert(e);
            }
            this.in = new BufferedInputStream(this.inStream, 4096);
        }
    }

    protected void closeIO() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.out = null;
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.in = null;
        }
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.store = null;
        }
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.inStream = null;
        }
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outStream = null;
        }
    }

    public boolean needRecompile() {
        return false;
    }

    public boolean getTextStorage() {
        return true;
    }

    public String getDatabasePath() {
        return null;
    }

    public FileStore openFile(String name) throws SQLException {
        return null;
    }

    public int getChecksum(byte[] data, int start, int end) {
        return this.session.getDatabase().getChecksum(data, start, end);
    }

    public void checkPowerOff() throws SQLException {
        this.session.getDatabase().checkPowerOff();
    }

    public void checkWritingAllowed() throws SQLException {
        this.session.getDatabase().checkWritingAllowed();
    }

    public void freeUpDiskSpace() throws SQLException {
        this.session.getDatabase().checkWritingAllowed();
    }

    public void handleInvalidChecksum() throws SQLException {
        this.session.getDatabase().handleInvalidChecksum();
    }
}

