/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.Prepared;
import org.h2.command.ddl.CreateIndex;
import org.h2.command.ddl.SchemaCommand;
import org.h2.engine.Database;
import org.h2.engine.Schema;
import org.h2.engine.Sequence;
import org.h2.index.IndexType;
import org.h2.message.Message;
import org.h2.table.Column;
import org.h2.table.TableData;
import org.h2.util.ObjectArray;

public class CreateTable
extends SchemaCommand {
    private String tableName;
    private ObjectArray constraintCommands = new ObjectArray();
    private ObjectArray columns = new ObjectArray();
    private String[] pkColumnNames;
    private boolean ifNotExists;
    private boolean persistent = true;
    private boolean hashPrimaryKey;
    private ObjectArray sequences;
    private boolean temporary;
    private boolean globalTemporary;
    private boolean onCommitDrop;
    private boolean onCommitTruncate;

    public CreateTable(Parser parser, Schema schema) {
        super(parser, schema);
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void addColumn(Column column) {
        this.columns.add(column);
    }

    public void addConstraintCommand(Prepared command) throws SQLException {
        if (command instanceof CreateIndex) {
            CreateIndex create = (CreateIndex)command;
            if (create.getPrimaryKey()) {
                this.setPrimaryKeyColumnNames(create.getColumnNames());
                this.setHashPrimaryKey(create.getHash());
            } else {
                this.constraintCommands.add(command);
            }
        } else {
            this.constraintCommands.add(command);
        }
    }

    public void setIfNotExists(boolean ifNotExists) {
        this.ifNotExists = ifNotExists;
    }

    public int update() throws SQLException {
        int i;
        this.session.commit();
        Database db = this.session.getDatabase();
        if (!db.isPersistent()) {
            this.persistent = false;
        }
        if (this.getSchema().findTableOrView(this.session, this.tableName) != null) {
            if (this.ifNotExists) {
                return 0;
            }
            throw Message.getSQLException(42101, this.tableName);
        }
        if (this.pkColumnNames != null) {
            int len = this.pkColumnNames.length;
            for (int i2 = 0; i2 < this.columns.size(); ++i2) {
                Column c = (Column)this.columns.get(i2);
                for (int j = 0; j < len; ++j) {
                    if (!c.getName().equals(this.pkColumnNames[j])) continue;
                    c.setNullable(false);
                }
            }
        }
        this.sequences = new ObjectArray();
        for (int i3 = 0; i3 < this.columns.size(); ++i3) {
            Sequence seq;
            Column c = (Column)this.columns.get(i3);
            if (c.getAutoIncrement()) {
                int objId = this.getObjectId(true, true);
                c.convertAutoIncrementToSequence(this.session, this.getSchema(), objId);
            }
            if ((seq = c.getSequence()) == null) continue;
            this.sequences.add(seq);
        }
        int id = this.getObjectId(true, true);
        TableData table = new TableData(this.getSchema(), this.tableName, id, this.columns, this.persistent);
        table.setTemporary(this.temporary);
        table.setGlobalTemporary(this.globalTemporary);
        if (this.temporary && !this.globalTemporary) {
            if (this.onCommitDrop) {
                table.setOnCommitDrop(true);
            }
            if (this.onCommitTruncate) {
                table.setOnCommitTruncate(true);
            }
            this.session.addLocalTempTable(table);
        } else {
            db.addSchemaObject(this.session, table);
        }
        if (this.pkColumnNames != null) {
            Column[] pk = table.getColumns(this.pkColumnNames);
            int indexId = this.getObjectId(true, false);
            table.addIndex(this.session, null, indexId, pk, IndexType.createPrimaryKey(this.persistent, this.hashPrimaryKey), -1);
        }
        for (i = 0; i < this.sequences.size(); ++i) {
            Sequence sequence = (Sequence)this.sequences.get(i);
            table.addSequence(sequence);
        }
        for (i = 0; i < this.constraintCommands.size(); ++i) {
            Prepared command = (Prepared)this.constraintCommands.get(i);
            command.update();
        }
        return 0;
    }

    public void setPrimaryKeyColumnNames(String[] colNames) throws SQLException {
        if (this.pkColumnNames != null) {
            if (colNames.length != this.pkColumnNames.length) {
                throw Message.getSQLException(90017);
            }
            for (int i = 0; i < colNames.length; ++i) {
                if (colNames[i].equals(this.pkColumnNames[i])) continue;
                throw Message.getSQLException(90017);
            }
        }
        this.pkColumnNames = colNames;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public void setHashPrimaryKey(boolean b) {
        this.hashPrimaryKey = b;
    }

    public void setGlobalTemporary(boolean globalTemporary) {
        this.globalTemporary = globalTemporary;
    }

    public void setOnCommitDrop() {
        this.onCommitDrop = true;
    }

    public void setOnCommitTruncate() {
        this.onCommitTruncate = true;
    }
}

