/*
 * Decompiled with CFR 0.152.
 */
package org.h2.command.ddl;

import java.sql.SQLException;
import org.h2.command.Parser;
import org.h2.command.ddl.DefineCommand;
import org.h2.engine.Database;
import org.h2.engine.User;
import org.h2.message.Message;
import org.h2.security.SHA256;
import org.h2.util.ByteUtils;

public class AlterUser
extends DefineCommand {
    public static final int SET_PASSWORD = 0;
    public static final int RENAME = 1;
    public static final int ADMIN = 2;
    private int type;
    private User user;
    private String newName;
    private byte[] userPasswordHash;
    private byte[] salt;
    private byte[] hash;
    private boolean admin;

    public AlterUser(Parser parser) {
        super(parser);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public void setAdmin(boolean admin) {
        this.admin = admin;
    }

    public void setSalt(String s) throws SQLException {
        this.salt = ByteUtils.convertStringToBytes(s);
    }

    public void setHash(String s) throws SQLException {
        this.hash = ByteUtils.convertStringToBytes(s);
    }

    public void setPassword(String password) {
        SHA256 sha = new SHA256();
        String name = this.newName == null ? this.user.getName() : this.newName;
        this.userPasswordHash = sha.getKeyPasswordHash(name, password.toCharArray());
    }

    public int update() throws SQLException {
        this.session.commit();
        Database db = this.session.getDatabase();
        switch (this.type) {
            case 0: {
                if (this.user != this.session.getUser()) {
                    this.session.getUser().checkAdmin();
                }
                if (this.hash != null && this.salt != null) {
                    this.user.setSaltAndHash(this.salt, this.hash);
                    break;
                }
                this.user.setUserPasswordHash(this.userPasswordHash);
                break;
            }
            case 1: {
                this.session.getUser().checkAdmin();
                if (db.findUser(this.newName) != null || this.newName.equals(this.user.getName())) {
                    throw Message.getSQLException(90033, this.newName);
                }
                db.renameDatabaseObject(this.session, this.user, this.newName);
                break;
            }
            case 2: {
                this.session.getUser().checkAdmin();
                this.user.setAdmin(this.admin);
                break;
            }
            default: {
                throw Message.internal("type=" + this.type);
            }
        }
        db.update(this.session, this.user);
        return 0;
    }
}

