# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Author: Fernando Casanova <fcasanova@fluendo.com>

from twisted.trial.unittest import TestCase
from elisa.plugins.lastfm.resource_provider import LASTFMWS_SERVER,\
                                        get_lastfm_albumgetinfo_url
from elisa.plugins.lastfm.key import LASTFMWS_KEY

class TestLastFMAPI(TestCase):

    def test_generate_api_request_a_simple(self):
        album_name = 'Els millors professors europeus'
        artist = 'Manel'
        expected = 'http://%s/2.0/?method=album.getinfo&api_key=%s' %\
                    (LASTFMWS_SERVER, LASTFMWS_KEY)\
                   + '&artist=manel&album=els%20millors%20professors%20europeus'
        self.failUnlessEqual(get_lastfm_albumgetinfo_url(artist, album_name),\
                             expected)

    def test_generate_api_request_b_medium(self):
        album_name = "Rock 'n' Roll"
        artist = 'Motörhead'
        expected = 'http://%s/2.0/?method=album.getinfo&api_key=%s' %\
                    (LASTFMWS_SERVER, LASTFMWS_KEY)\
                   + '&artist=mot%C3%B6rhead&album=rock%20%27n%27%20roll'
        self.failUnlessEqual(get_lastfm_albumgetinfo_url(artist, album_name),\
                             expected)

#    def test_generate_api_request_c_really_fuckedup(self):
#        album_name = "Rock 'n' Roll"
#        artist = 'Motörhead'
#        expected = 'http://%s/2.0/?method=album.getinfo&api_key=%s' %\
#                    (LASTFMWS_SERVER, LASTFMWS_KEY)\
#                   + '&artist=mot%C3%B6rhead&album=rock%20%27n%27%20roll'
#        self.failUnlessEqual(get_lastfm_albumgetinfo_url(artist, album_name),\
#                             expected)
#http://www.lastfm.pl/music/Bia%C5%82a+Gor%C4%85czka/Niepos%C5%82usze%C5%84stwo
