/*
 * Decompiled with CFR 0.152.
 */
package msfgui;

import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import msfgui.Base64;
import msfgui.RpcConnection;
import msfgui.SessionsTable;
import org.jdesktop.swingworker.SwingWorker;

public class SessionCommand {
    protected String command;
    protected String outputPrefix;
    protected JLabel label;

    public SessionCommand() {
        this.command = null;
        this.outputPrefix = null;
        this.label = null;
    }

    public SessionCommand(String cmd, String output, JLabel outputLabel) {
        this.command = cmd;
        this.outputPrefix = output;
        this.label = outputLabel;
    }

    public String getCommand(Map session, SwingWorker parent) {
        return this.command;
    }

    public void processResult(Map m) {
        this.label.setText("Running " + this.outputPrefix + " on " + m.get("tunnel_peer") + ", session " + m.get("id"));
    }

    public static void runOnAllMeterpreters(final SessionsTable sessionsTableModel, String cmd, String output, JLabel outputLabel, final RpcConnection rpcConn) {
        final SessionCommand sess = new SessionCommand(cmd, output, outputLabel);
        new SwingWorker(){

            protected Object doInBackground() throws Exception {
                block3: {
                    try {
                        List currentSessions = sessionsTableModel.getSessionList();
                        for (Object o : currentSessions) {
                            Map session = (Map)o;
                            if (!session.get("type").equals("meterpreter")) continue;
                            this.publish(session);
                            rpcConn.execute("session.meterpreter_write", session.get("id"), Base64.encode(("\n" + sess.getCommand(session, this) + "\n").getBytes()));
                        }
                    }
                    catch (RuntimeException rex) {
                        if (rex.getMessage().equals("cancelled")) break block3;
                        throw rex;
                    }
                }
                return null;
            }

            protected void process(List l) {
                for (Object o : l) {
                    sess.processResult((Map)o);
                }
            }
        }.execute();
    }
}

