/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Entry;
import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.Messages;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Creator
extends Action {
    JarOutputStream outputStream;
    HashSet<String> writtenItems = new HashSet();
    Manifest manifest;

    private long copyFile(CRC32 crc, InputStream is, OutputStream output) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        long size = 0L;
        while ((len = is.read(buffer)) != -1) {
            size += (long)len;
            output.write(buffer, 0, len);
            crc.update(buffer, 0, len);
        }
        output.close();
        return size;
    }

    protected void writeFile(boolean isDirectory, InputStream inputFile, String filename, boolean verbose) throws IOException {
        if (this.writtenItems.contains(filename)) {
            if (verbose) {
                String msg = MessageFormat.format(Messages.getString("Creator.Ignoring"), filename);
                System.err.println(msg);
            }
            return;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CRC32 crc = new CRC32();
        long size = isDirectory ? 0L : this.copyFile(crc, inputFile, out);
        ZipEntry entry = new ZipEntry(filename);
        entry.setCrc(crc.getValue());
        entry.setSize(size);
        this.outputStream.putNextEntry(entry);
        out.writeTo(this.outputStream);
        this.outputStream.closeEntry();
        this.writtenItems.add(filename);
        if (verbose) {
            long csize = entry.getCompressedSize();
            long perc = size == 0L ? 0L : 100L - 100L * csize / size;
            String msg = MessageFormat.format(Messages.getString("Creator.Adding"), filename, size, entry.getSize(), perc);
            System.err.println(msg);
        }
    }

    protected void writeFile(File file, String filename, boolean verbose) throws IOException {
        boolean isDirectory = file.isDirectory();
        if (isDirectory) {
            if (filename.charAt(filename.length() - 1) != '/') {
                filename = String.valueOf(filename) + '/';
            }
            this.writeFile(isDirectory, null, filename, verbose);
        } else {
            FileInputStream inputStream = new FileInputStream(file);
            this.writeFile(isDirectory, inputStream, filename, verbose);
            ((InputStream)inputStream).close();
        }
    }

    private void addEntries(ArrayList<Entry> result, Entry entry) {
        if (entry.file.isDirectory()) {
            String name = entry.name;
            if (name.charAt(name.length() - 1) != '/') {
                name = String.valueOf(name) + '/';
                entry = new Entry(entry.file, name);
            }
            result.add(entry);
            String[] files = entry.file.list();
            int i = 0;
            while (i < files.length) {
                this.addEntries(result, new Entry(new File(entry.file, files[i]), String.valueOf(entry.name) + files[i]));
                ++i;
            }
        } else {
            result.add(entry);
        }
    }

    private ArrayList<Entry> getAllEntries(Main parameters) {
        ArrayList<Entry> allEntries = new ArrayList<Entry>();
        for (Entry entry : parameters.entries) {
            this.addEntries(allEntries, entry);
        }
        return allEntries;
    }

    private void writeCommandLineEntries(Main parameters) throws IOException {
        this.writtenItems.add("META-INF/");
        this.writtenItems.add("META-INF/MANIFEST.MF");
        ArrayList<Entry> allEntries = this.getAllEntries(parameters);
        for (Entry entry : allEntries) {
            this.writeFile(entry.file, entry.name, parameters.verbose);
        }
    }

    protected Manifest createManifest(Main parameters) throws IOException {
        if (!parameters.wantManifest) {
            return null;
        }
        if (parameters.manifestFile != null) {
            FileInputStream contents = new FileInputStream(parameters.manifestFile);
            return new Manifest(contents);
        }
        return new Manifest();
    }

    protected void writeCommandLineEntries(Main parameters, OutputStream os) throws IOException {
        this.manifest = this.createManifest(parameters);
        if (parameters.wantManifest) {
            Attributes attr = this.manifest.getMainAttributes();
            if (attr.getValue(Attributes.Name.MANIFEST_VERSION) == null) {
                attr.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
            }
            attr.putValue("Created-By", String.valueOf(System.getProperty("java.version")) + " (" + System.getProperty("java.vendor") + ")");
        }
        this.outputStream = new JarOutputStream(os, this.manifest);
        this.outputStream.setMethod(parameters.storageMode);
        this.writeCommandLineEntries(parameters);
    }

    protected void close() throws IOException {
        this.outputStream.finish();
        this.outputStream.close();
    }

    @Override
    public void run(Main parameters) throws IOException {
        if (parameters.archiveFile == null || parameters.archiveFile.equals("-")) {
            this.writeCommandLineEntries(parameters, System.out);
        } else {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(parameters.archiveFile));
            this.writeCommandLineEntries(parameters, os);
        }
        this.close();
    }
}

