/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import gnu.classpath.tools.IOToolkit;
import gnu.classpath.tools.MalformedInputEvent;
import gnu.classpath.tools.MalformedInputListener;
import gnu.classpath.tools.NotifyingInputStreamReader;
import gnu.classpath.tools.gjdoc.BracketClose;
import gnu.classpath.tools.gjdoc.ClassComponent;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.ClassDocProxy;
import gnu.classpath.tools.gjdoc.CommentComponent;
import gnu.classpath.tools.gjdoc.Debug;
import gnu.classpath.tools.gjdoc.EmptyStatementComponent;
import gnu.classpath.tools.gjdoc.FieldComponent;
import gnu.classpath.tools.gjdoc.FunctionComponent;
import gnu.classpath.tools.gjdoc.IgnoredFileParseException;
import gnu.classpath.tools.gjdoc.ImportComponent;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.PackageComponent;
import gnu.classpath.tools.gjdoc.PackageDocImpl;
import gnu.classpath.tools.gjdoc.ParseException;
import gnu.classpath.tools.gjdoc.SlashSlashCommentComponent;
import gnu.classpath.tools.gjdoc.SourceComponent;
import gnu.classpath.tools.gjdoc.StaticBlockComponent;
import gnu.classpath.tools.gjdoc.Whitespace;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class Parser {
    private boolean addComments = false;
    public static final String WHITESPACE = " \t\r\n\f";
    private int currentLine;
    private SourceComponent[] sourceLevelComponents;
    private SourceComponent[] classLevelComponents;
    static Set processedFiles = new HashSet();
    Context ctx = null;
    Stack contextStack = new Stack();
    File currentFile = null;
    String lastComment = null;
    String expectedPackageName = null;
    String currentPackageName = null;
    PackageDocImpl currentPackage = null;
    ClassDocImpl currentClass = null;
    ClassDocImpl outerClass = null;
    List ordinaryClassesList = new LinkedList();
    List allClassesList = new LinkedList();
    List interfacesList = new LinkedList();
    List importedClassesList = new LinkedList();
    List importedStringList = new LinkedList();
    List importedPackagesList = new LinkedList();
    List importedStatementList = new LinkedList();
    List referencedClassesList = new LinkedList();
    String boilerplateComment = null;

    static int skipExpression(char[] source, int endIndex, int level, char delimiter) throws ParseException {
        int orgEndIndex = endIndex;
        int state = 1;
        char prev = '\u0000';
        while ((level != 0 || state != 1 || delimiter != '\u0000' && source[endIndex] != delimiter) && endIndex < source.length) {
            char c = source[endIndex];
            if (state == 1) {
                if (c == '}') {
                    --level;
                } else if (c == '{') {
                    ++level;
                } else if (c == '/' && prev == '/') {
                    state = 3;
                    c = '\u0000';
                } else if (c == '*' && prev == '/') {
                    state = 2;
                    c = '\u0000';
                } else if (c == '\'' && prev != '\\') {
                    state = 4;
                    c = '\u0000';
                } else if (c == '\"' && prev != '\\') {
                    state = 5;
                    c = '\u0000';
                }
            } else if (state == 3) {
                if (c == '\n') {
                    state = 1;
                }
            } else if (state == 4) {
                if (c == '\'' && prev != '\\') {
                    state = 1;
                } else if (c == '\\' && prev == '\\') {
                    c = '\u0000';
                }
            } else if (state == 5) {
                if (c == '\"' && prev != '\\') {
                    state = 1;
                } else if (c == '\\' && prev == '\\') {
                    c = '\u0000';
                }
            } else if (c == '/' && prev == '*') {
                state = 1;
                c = '\u0000';
            }
            prev = c;
            ++endIndex;
        }
        if (level > 0) {
            throw new ParseException("Unexpected end of source.");
        }
        new String(source, orgEndIndex, endIndex - orgEndIndex);
        return endIndex;
    }

    public boolean getAddComments() {
        return this.addComments;
    }

    public static final boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    static char[] loadFile(final File file, String encoding) throws IOException {
        FileInputStream in = new FileInputStream(file);
        NotifyingInputStreamReader notifyingInput = new NotifyingInputStreamReader((InputStream)in, encoding);
        notifyingInput.addMalformedInputListener(new MalformedInputListener(){

            public void malformedInputEncountered(MalformedInputEvent event) {
                Main.getRootDoc().printWarning("Illegal character in file " + file + ", line " + event.getLineNumber() + ", column " + event.getColumnNumber());
                try {
                    Main.getRootDoc().printWarning(IOToolkit.getLineFromFile(file, event.getLineNumber()));
                    Main.getRootDoc().printWarning(IOToolkit.getColumnDisplayLine(event.getColumnNumber()));
                }
                catch (IOException iOException) {}
            }
        });
        BufferedReader reader = new BufferedReader(notifyingInput);
        char[] result = IOToolkit.readFully(reader);
        ((Reader)reader).close();
        return result;
    }

    public SourceComponent[] getClassLevelComponents() {
        return this.classLevelComponents;
    }

    public Parser() {
        try {
            this.sourceLevelComponents = new SourceComponent[]{new Whitespace(), new CommentComponent(), new SlashSlashCommentComponent(), new PackageComponent(), new EmptyStatementComponent(), new ImportComponent(), new ClassComponent()};
            this.classLevelComponents = new SourceComponent[]{new Whitespace(), new BracketClose(), new CommentComponent(), new SlashSlashCommentComponent(), new FunctionComponent(), new StaticBlockComponent(), new ImportComponent(), new ClassComponent(), new FieldComponent()};
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getNumberOfProcessedFiles() {
        return processedFiles.size();
    }

    ClassDocImpl processSourceFile(File file, boolean addComments, String encoding, String expectedPackageName) throws IOException, ParseException {
        this.currentFile = file;
        this.currentPackage = null;
        this.currentPackageName = null;
        this.expectedPackageName = expectedPackageName;
        this.outerClass = null;
        this.boilerplateComment = null;
        this.addComments = addComments;
        if (processedFiles.contains(file)) {
            return null;
        }
        processedFiles.add(file);
        Debug.log(1, "Processing file " + file);
        this.contextStack.clear();
        this.ctx = null;
        this.importedClassesList.clear();
        this.importedStringList.clear();
        this.importedPackagesList.clear();
        this.importedStatementList.clear();
        this.currentLine = 1;
        char[] source = Parser.loadFile(file, encoding);
        try {
            this.parse(source, 0, this.sourceLevelComponents);
            ClassDoc[] importedClasses = this.importedClassesList.toArray(new ClassDoc[0]);
            this.importedPackagesList.toArray(new PackageDoc[0]);
            int i = 0;
            while (i < importedClasses.length) {
                Main.getRootDoc().scheduleClass(this.currentClass, importedClasses[i].qualifiedName());
                ++i;
            }
            if (this.contextStack.size() > 0) {
                Debug.log(1, "-->contextStack not empty! size is " + this.contextStack.size());
            }
            return this.outerClass;
        }
        catch (IgnoredFileParseException ignore) {
            Debug.log(1, "File ignored: " + ignore);
            return null;
        }
    }

    int parse(char[] source, int index, SourceComponent[] componentTypes) throws ParseException, IOException {
        while (index < source.length) {
            int match = -1;
            int i = 0;
            while (i < componentTypes.length) {
                match = componentTypes[i].match(source, index);
                if (match >= 0) break;
                ++i;
            }
            if (i < componentTypes.length) {
                int endIndex = componentTypes[i].getEndIndex(source, match);
                Debug.log(9, "Processing " + new String(source, index, endIndex - index) + " with " + componentTypes[i]);
                index = componentTypes[i].process(this, source, index, endIndex);
                if (index >= 0) continue;
                return endIndex;
            }
            throw new ParseException("unmatched input in line " + this.currentLine + ": " + new String(source, index, Math.min(50, source.length - index)));
        }
        return index;
    }

    private static int countNewLines(String source) {
        int i = 0;
        int rc = 0;
        while ((i = source.indexOf(10, i) + 1) > 0) {
            ++rc;
        }
        return rc;
    }

    public void processSourceDir(File dir, String encoding, String expectedPackageName) throws IOException, ParseException {
        Debug.log(9, "Processing " + dir.getParentFile().getName() + "." + dir.getName());
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().toLowerCase().endsWith(".java")) {
                    this.processSourceFile(files[i], true, encoding, expectedPackageName);
                }
                ++i;
            }
        }
    }

    void classOpened(char[] source, int startIndex, int endIndex) throws ParseException, IOException {
        this.referencedClassesList.clear();
        if (this.currentPackage == null) {
            if (!(this.expectedPackageName == null || this.currentPackageName != null && this.currentPackageName.equals(this.expectedPackageName))) {
                Main.getRootDoc().printWarning("Ignoring file " + this.currentFile + ": (wrong package, " + this.currentPackageName + "!=" + this.expectedPackageName + ")");
                throw new IgnoredFileParseException();
            }
            this.currentPackage = this.currentPackageName != null ? Main.getRootDoc().findOrCreatePackageDoc(this.currentPackageName) : Main.getRootDoc().findOrCreatePackageDoc("");
        }
        if (this.currentPackageName != null) {
            this.importedStatementList.add(String.valueOf(this.currentPackageName) + ".*");
        }
        this.importedStatementList.add("java.lang.*");
        ClassDocImpl classDoc = ClassDocImpl.createInstance(this.ctx != null ? this.ctx.classDoc : null, this.currentPackage, null, this.importedPackagesList.toArray(new PackageDoc[0]), source, startIndex, endIndex, this.importedStatementList);
        if (this.ctx != null) {
            this.ctx.innerClassesList.add(classDoc);
            if (classDoc.isIncluded()) {
                this.ctx.filteredInnerClassesList.add(classDoc);
            }
        }
        if (this.importedClassesList.isEmpty()) {
            Iterator it = this.importedStringList.iterator();
            while (it.hasNext()) {
                this.importedClassesList.add(new ClassDocProxy((String)it.next(), classDoc));
            }
        }
        classDoc.setImportedClasses(this.importedClassesList.toArray(new ClassDoc[0]));
        this.currentPackage.addClass(classDoc);
        this.currentClass = classDoc;
        if (this.outerClass == null) {
            this.outerClass = classDoc;
        }
        if (classDoc.superclass() != null) {
            this.referencedClassesList.add(classDoc.superclass());
        }
        Debug.log(1, "classOpened " + classDoc + ", adding superclass " + classDoc.superclass());
        Debug.log(1, "Pushing " + this.ctx);
        this.contextStack.push(this.ctx);
        this.ctx = new Context(classDoc);
    }

    private Doc[] toArray(List list, Doc[] template) {
        Doc[] result = list.toArray(template);
        return result;
    }

    void classClosed() throws ParseException, IOException {
        this.ctx.classDoc.setFields((FieldDoc[])this.toArray(this.ctx.fieldList, new FieldDoc[0]));
        this.ctx.classDoc.setFilteredFields((FieldDoc[])this.toArray(this.ctx.filteredFieldList, new FieldDoc[0]));
        this.ctx.classDoc.setSerializableFields((FieldDoc[])this.toArray(this.ctx.sfieldList, new FieldDoc[0]));
        this.ctx.classDoc.setMethods((MethodDoc[])this.toArray(this.ctx.methodList, new MethodDoc[0]));
        this.ctx.classDoc.setFilteredMethods((MethodDoc[])this.toArray(this.ctx.filteredMethodList, new MethodDoc[0]));
        this.ctx.classDoc.setMaybeSerMethodList(this.ctx.maybeSerMethodList);
        this.ctx.classDoc.setConstructors((ConstructorDoc[])this.toArray(this.ctx.constructorList, new ConstructorDoc[0]));
        this.ctx.classDoc.setFilteredConstructors((ConstructorDoc[])this.toArray(this.ctx.filteredConstructorList, new ConstructorDoc[0]));
        this.ctx.classDoc.setInnerClasses((ClassDocImpl[])this.toArray(this.ctx.innerClassesList, new ClassDocImpl[0]));
        this.ctx.classDoc.setFilteredInnerClasses((ClassDocImpl[])this.toArray(this.ctx.filteredInnerClassesList, new ClassDocImpl[0]));
        this.ctx.classDoc.setBoilerplateComment(this.boilerplateComment);
        Main.getRootDoc().addClassDoc(this.ctx.classDoc);
        Debug.log(1, "classClosed: " + this.ctx.classDoc);
        this.ctx = (Context)this.contextStack.pop();
        Debug.log(1, "Popping " + this.ctx);
        ClassDoc[] referencedClasses = this.referencedClassesList.toArray(new ClassDoc[0]);
        int i = 0;
        while (i < referencedClasses.length) {
            Main.getRootDoc().scheduleClass(this.currentClass, referencedClasses[i].qualifiedName());
            ++i;
        }
    }

    void packageOpened(String packageName) {
        this.currentPackageName = packageName;
    }

    void importEncountered(String importString) throws ParseException, IOException {
        this.importedStatementList.add(importString);
        if (importString.endsWith(".*")) {
            this.importedPackagesList.add(Main.getRootDoc().findOrCreatePackageDoc(importString.substring(0, importString.length() - 2)));
        } else {
            this.importedStringList.add(importString);
        }
    }

    void setLastComment(String lastComment) {
        this.lastComment = lastComment;
    }

    String getLastComment() {
        return this.lastComment;
    }

    void setBoilerplateComment(String boilerplateComment) {
        this.boilerplateComment = boilerplateComment;
    }

    String getBoilerplateComment() {
        return this.boilerplateComment;
    }

    class Context {
        ClassDocImpl classDoc = null;
        List fieldList = new LinkedList();
        List filteredFieldList = new LinkedList();
        List sfieldList = new LinkedList();
        List methodList = new LinkedList();
        List filteredMethodList = new LinkedList();
        List maybeSerMethodList = new LinkedList();
        List constructorList = new LinkedList();
        List filteredConstructorList = new LinkedList();
        List innerClassesList = new LinkedList();
        List filteredInnerClassesList = new LinkedList();

        Context(ClassDocImpl classDoc) {
            this.classDoc = classDoc;
        }
    }
}

