/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.gjdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ParamTag;
import com.sun.javadoc.SeeTag;
import com.sun.javadoc.SerialFieldTag;
import com.sun.javadoc.SourcePosition;
import com.sun.javadoc.Tag;
import com.sun.javadoc.ThrowsTag;
import gnu.classpath.tools.gjdoc.AbstractTagImpl;
import gnu.classpath.tools.gjdoc.ArrayCharacterIterator;
import gnu.classpath.tools.gjdoc.ClassDocImpl;
import gnu.classpath.tools.gjdoc.GjdocPackageDoc;
import gnu.classpath.tools.gjdoc.InheritDocTagImpl;
import gnu.classpath.tools.gjdoc.LinkTagImpl;
import gnu.classpath.tools.gjdoc.Main;
import gnu.classpath.tools.gjdoc.MemberDocImpl;
import gnu.classpath.tools.gjdoc.ParamTagImpl;
import gnu.classpath.tools.gjdoc.Parser;
import gnu.classpath.tools.gjdoc.SeeTagImpl;
import gnu.classpath.tools.gjdoc.SerialFieldTagImpl;
import gnu.classpath.tools.gjdoc.SourcePositionImpl;
import gnu.classpath.tools.gjdoc.TagContainer;
import gnu.classpath.tools.gjdoc.TagImpl;
import gnu.classpath.tools.gjdoc.TextTagImpl;
import gnu.classpath.tools.gjdoc.ThrowsTagImpl;
import gnu.classpath.tools.gjdoc.ValueTagImpl;
import java.io.File;
import java.text.BreakIterator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.text.Segment;

public abstract class DocImpl
implements Doc,
TagContainer {
    protected static Tag[] seeTagEmptyArr = new SeeTagImpl[0];
    protected static Tag[] linkTagEmptyArr = new LinkTagImpl[0];
    protected static Tag[] paramTagEmptyArr = new ParamTagImpl[0];
    protected static Tag[] throwsTagEmptyArr = new ThrowsTagImpl[0];
    protected SourcePosition position;
    private String boilerplateComment;
    private static final StringBuffer whitespaceBuf = new StringBuffer();
    private static char[] charBuf = new char[60000];
    private static int bufPos = 0;
    protected String rawDocumentation;
    protected long rawDocOffset = -1L;
    protected Map tagMap = new HashMap();
    private static Map classDocToFileMap = new HashMap();

    public String commentText() {
        StringBuffer rc = new StringBuffer();
        Tag[] textTags = (Tag[])this.tagMap.get("text");
        if (textTags != null) {
            int i = 0;
            while (i < textTags.length) {
                rc.append(textTags[i].text());
                ++i;
            }
        }
        return rc.toString();
    }

    public int compareTo(Object o) {
        return Main.getInstance().getCollator().compare(this.name(), ((Doc)o).name());
    }

    public Tag[] firstSentenceTags() {
        Tag[] rc = (Tag[])this.tagMap.get("first");
        if (rc == null) {
            rc = new Tag[]{};
        }
        return rc;
    }

    public String getRawCommentText() {
        if (this.rawDocumentation != null) {
            return this.rawDocumentation;
        }
        if (this.rawDocOffset >= 0L) {
            return Main.getRootDoc().readRawComment(this.rawDocOffset);
        }
        return null;
    }

    public Tag[] inlineTags() {
        Tag[] rc = (Tag[])this.tagMap.get("inline");
        if (rc == null) {
            rc = new Tag[]{};
        }
        return rc;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isError() {
        return false;
    }

    public boolean isException() {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isIncluded() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isPackage() {
        return false;
    }

    public boolean isOrdinaryClass() {
        return false;
    }

    public SeeTag[] seeTags() {
        return (SeeTag[])this.getTagArr("see", seeTagEmptyArr);
    }

    protected Tag[] getTagArr(String kindOfTag, Tag[] defaultRc) {
        Tag[] rc = (Tag[])this.tagMap.get(kindOfTag);
        if (rc == null) {
            rc = defaultRc;
        }
        return rc;
    }

    public void setRawCommentText(String rawDocumentation) {
        this.rawDocumentation = rawDocumentation;
    }

    public void resolveComments() {
        if (this.rawDocumentation != null && this.tagMap.isEmpty()) {
            char[] charArray = this.rawDocumentation.toCharArray();
            int length = this.rawDocumentation.length();
            int startOffset = 0;
            int endOffset = 0;
            if (charArray[0] == '/' && charArray[1] == '*' && charArray[2] == '*' && charArray[length - 2] == '*' && charArray[length - 1] == '/') {
                startOffset = 3;
                endOffset = 2;
            }
            this.tagMap = DocImpl.parseCommentTags(charArray, startOffset, length - endOffset, this.getContextClass(), this.getContextMember(), null, this.boilerplateComment);
            if (Main.getInstance().isCacheRawComments()) {
                this.rawDocOffset = Main.getRootDoc().writeRawComment(this.rawDocumentation);
                this.rawDocumentation = null;
            }
            this.resolveTags();
        } else if (this.tagMap.isEmpty() && this.boilerplateComment != null) {
            this.tagMap.put("all", new Tag[]{new TagImpl("@boilerplate", this.boilerplateComment, this.getContextClass(), null)});
            this.tagMap.put("@boilerplate", new Tag[]{new TagImpl("@boilerplate", this.boilerplateComment, this.getContextClass(), null)});
        }
    }

    public static int skipHtmlWhitespace(char[] buffer, int startIndex) {
        while (startIndex < buffer.length) {
            char c = buffer[startIndex];
            if (!Parser.isWhitespace(c)) break;
            ++startIndex;
        }
        return startIndex;
    }

    /*
     * Unable to fully structure code
     */
    private static int findEndOfSentence(char[] text, int startIndex, int endIndex) {
        if (!Main.getInstance().isUseBreakIterator()) ** GOTO lbl12
        segment = new Segment(text, startIndex, endIndex - startIndex);
        breakIterator = BreakIterator.getSentenceInstance(Main.getInstance().getLocale());
        breakIterator.setText(segment);
        result = breakIterator.next();
        if (-1 == result) {
            return endIndex;
        }
        return result;
lbl-1000:
        // 1 sources

        {
            if (text[startIndex] == '.' && (startIndex + 1 == endIndex || Character.isWhitespace(text[startIndex + 1]) || DocImpl.isHTMLBreakTag(text, startIndex + 1, endIndex))) {
                return startIndex;
            }
            ++startIndex;
lbl12:
            // 2 sources

            ** while (startIndex < endIndex)
        }
lbl13:
        // 1 sources

        return endIndex;
    }

    private static boolean isHTMLBreakTag(char[] text, int start, int end) {
        String[] breakTags = new String[]{"p>", "/p>", "h1>", "h2>", "h3>", "h4>", "h5>", "h6>", "hr>", "pre>", "/pre>"};
        if (text[start] == '<') {
            int i = 0;
            while (i < breakTags.length) {
                block5: {
                    String tag = breakTags[i];
                    int len = tag.length();
                    if (start + len < end) {
                        int j = 0;
                        while (j < len) {
                            char c = tag.charAt(j);
                            if (Character.toLowerCase(text[start + 1 + j]) == c) {
                                ++j;
                                continue;
                            }
                            break block5;
                        }
                        return true;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    private static void appendToBuf(char c) {
        if (bufPos < charBuf.length) {
            DocImpl.charBuf[DocImpl.bufPos++] = c;
        }
    }

    private static void appendToBuf(StringBuffer s) {
        if (bufPos + s.length() <= charBuf.length) {
            s.getChars(0, s.length(), charBuf, bufPos);
            bufPos += s.length();
        }
    }

    private static void setBufLength(int length) {
        bufPos = 0;
    }

    private static String bufToString() {
        return new String(charBuf, 0, bufPos);
    }

    private static int bufLength() {
        return bufPos;
    }

    public static Map parseCommentTags(char[] comment, int startIndex, int endIndex, ClassDocImpl contextClass, MemberDocImpl contextMember, AbstractTagImpl contextTag, String boilerplateComment) {
        int rawDocStart = DocImpl.skipHtmlWhitespace(comment, startIndex);
        int firstSentenceEnd = 0;
        if (comment.length > rawDocStart) {
            firstSentenceEnd = DocImpl.findEndOfSentence(comment, rawDocStart, comment.length);
            if (firstSentenceEnd < 0) {
                BreakIterator boundary = BreakIterator.getSentenceInstance(Locale.ENGLISH);
                boundary.setText(new ArrayCharacterIterator(comment, rawDocStart));
                boundary.first();
                boundary.next();
                firstSentenceEnd = boundary.current();
            }
            if (firstSentenceEnd < comment.length && '.' == comment[firstSentenceEnd]) {
                ++firstSentenceEnd;
            }
        }
        int state = 1;
        int prevState = 2;
        DocImpl.setBufLength(0);
        whitespaceBuf.setLength(0);
        String paramName = "";
        String paramValue = "";
        HashMap tags = new HashMap();
        tags.put("inline", new LinkedList());
        tags.put("first", new LinkedList());
        tags.put("all", new LinkedList());
        int i = rawDocStart;
        while (i <= endIndex) {
            char c = i < endIndex ? comment[i] : (char)'\uffff';
            int peek = i < endIndex - 1 ? comment[i + 1] : 65535;
            switch (state) {
                case 1: {
                    AbstractTagImpl newTag;
                    if (i == firstSentenceEnd) {
                        newTag = DocImpl.addTag(tags, "text", DocImpl.bufToString(), true, contextClass, contextMember, contextTag, false);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        DocImpl.setBufLength(0);
                    }
                    if (Parser.isWhitespace(c)) break;
                    if (c == '*') {
                        if (peek == 42 || peek == 64 || peek == 65535) break;
                        state = 8;
                        break;
                    }
                    if (c == '@' || c == '{' && peek == 64 || c == '\uffff') {
                        if (DocImpl.bufLength() > 0) {
                            DocImpl.addTag(tags, "text", DocImpl.bufToString(), i < firstSentenceEnd, contextClass, contextMember, contextTag, false);
                            DocImpl.setBufLength(0);
                        }
                        if (c == '{') {
                            ++i;
                            state = 6;
                            break;
                        }
                        state = 3;
                        break;
                    }
                    state = 2;
                    DocImpl.appendToBuf(whitespaceBuf);
                    whitespaceBuf.setLength(0);
                    DocImpl.appendToBuf(c);
                    break;
                }
                case 8: {
                    AbstractTagImpl newTag;
                    if (i == firstSentenceEnd) {
                        newTag = DocImpl.addTag(tags, "text", DocImpl.bufToString(), true, contextClass, contextMember, contextTag, false);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        DocImpl.setBufLength(0);
                    }
                    if (c == '\n') {
                        whitespaceBuf.append(c);
                        state = 1;
                        break;
                    }
                    if (Parser.isWhitespace(c)) {
                        whitespaceBuf.append(c);
                        break;
                    }
                    if (c == '@' || c == '{' && peek == 64 || c == '\uffff') {
                        if (DocImpl.bufLength() > 0) {
                            newTag = DocImpl.addTag(tags, "text", DocImpl.bufToString(), i < firstSentenceEnd, contextClass, contextMember, contextTag, false);
                            if (newTag != null) {
                                contextTag = newTag;
                            }
                            DocImpl.setBufLength(0);
                        }
                        if (c == '{') {
                            ++i;
                            state = 6;
                            break;
                        }
                        state = 3;
                        break;
                    }
                    DocImpl.appendToBuf(whitespaceBuf);
                    whitespaceBuf.setLength(0);
                    DocImpl.appendToBuf(c);
                    state = 2;
                    break;
                }
                case 5: {
                    AbstractTagImpl newTag;
                    if (c == '\n') {
                        DocImpl.appendToBuf(c);
                        break;
                    }
                    if (Parser.isWhitespace(c) || c == 42) break;
                    if (c == '@' || c == '\uffff') {
                        paramValue = DocImpl.bufToString();
                        newTag = DocImpl.addTag(tags, paramName, paramValue, i < firstSentenceEnd, contextClass, contextMember, contextTag, false);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        DocImpl.setBufLength(0);
                        if (c == '{') {
                            ++i;
                            state = 6;
                            break;
                        }
                        state = 3;
                        break;
                    }
                    state = 4;
                    DocImpl.appendToBuf(c);
                    break;
                }
                case 3: {
                    if (c != '\uffff' && !Parser.isWhitespace(c)) {
                        DocImpl.appendToBuf(c);
                        break;
                    }
                    if (c == '\n') {
                        paramName = DocImpl.bufToString();
                        DocImpl.setBufLength(0);
                        state = 5;
                        break;
                    }
                    paramName = DocImpl.bufToString();
                    DocImpl.setBufLength(0);
                    state = 4;
                    break;
                }
                case 6: {
                    AbstractTagImpl newTag;
                    if (c == '}') {
                        paramName = DocImpl.bufToString();
                        newTag = DocImpl.addTag(tags, paramName, "", i < firstSentenceEnd, contextClass, contextMember, contextTag, true);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        state = prevState;
                        DocImpl.setBufLength(0);
                        break;
                    }
                    if (c != '\uffff' && !Parser.isWhitespace(c)) {
                        DocImpl.appendToBuf(c);
                        break;
                    }
                    if (c == '\n') {
                        paramName = DocImpl.bufToString();
                        DocImpl.setBufLength(0);
                        state = 9;
                        break;
                    }
                    paramName = DocImpl.bufToString();
                    DocImpl.setBufLength(0);
                    state = 7;
                    break;
                }
                case 4: {
                    AbstractTagImpl newTag;
                    if (c == '\uffff') {
                        paramValue = DocImpl.bufToString();
                        newTag = DocImpl.addTag(tags, paramName, paramValue, i < firstSentenceEnd, contextClass, contextMember, contextTag, false);
                        if (newTag == null) break;
                        contextTag = newTag;
                        break;
                    }
                    if (c == '\n') {
                        DocImpl.appendToBuf(c);
                        state = 5;
                        break;
                    }
                    DocImpl.appendToBuf(c);
                    break;
                }
                case 7: {
                    AbstractTagImpl newTag;
                    if (c == '\n') {
                        DocImpl.appendToBuf(c);
                        state = 9;
                        break;
                    }
                    if (c == '\uffff' || c == '}') {
                        paramValue = DocImpl.bufToString();
                        newTag = DocImpl.addTag(tags, paramName, paramValue, i < firstSentenceEnd, contextClass, contextMember, contextTag, true);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        state = prevState;
                        DocImpl.setBufLength(0);
                        break;
                    }
                    DocImpl.appendToBuf(c);
                    break;
                }
                case 9: {
                    AbstractTagImpl newTag;
                    if (Parser.isWhitespace(c)) break;
                    if (c == '*') {
                        if (i >= endIndex || peek == 42) break;
                        state = 10;
                        break;
                    }
                    if (c == '\uffff') {
                        if (DocImpl.bufLength() <= 0 || (newTag = DocImpl.addTag(tags, "text", DocImpl.bufToString(), i < firstSentenceEnd, contextClass, contextMember, contextTag, false)) == null) break;
                        contextTag = newTag;
                        break;
                    }
                    state = 7;
                    DocImpl.appendToBuf(whitespaceBuf);
                    whitespaceBuf.setLength(0);
                    DocImpl.appendToBuf(c);
                    break;
                }
                case 10: {
                    AbstractTagImpl newTag;
                    if (c == '\n') {
                        whitespaceBuf.append(c);
                        state = 9;
                        break;
                    }
                    if (Parser.isWhitespace(c)) {
                        whitespaceBuf.append(c);
                        break;
                    }
                    if (c == '\uffff') {
                        if (DocImpl.bufLength() <= 0) break;
                        newTag = DocImpl.addTag(tags, "text", DocImpl.bufToString(), i < firstSentenceEnd, contextClass, contextMember, contextTag, false);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        DocImpl.setBufLength(0);
                        break;
                    }
                    DocImpl.appendToBuf(whitespaceBuf);
                    whitespaceBuf.setLength(0);
                    DocImpl.appendToBuf(c);
                    state = 7;
                    break;
                }
                case 2: {
                    AbstractTagImpl newTag;
                    if (i == firstSentenceEnd) {
                        newTag = DocImpl.addTag(tags, "text", DocImpl.bufToString(), true, contextClass, contextMember, contextTag, false);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        DocImpl.setBufLength(0);
                    }
                    if (c == '\uffff') {
                        paramValue = DocImpl.bufToString();
                        newTag = DocImpl.addTag(tags, "text", paramValue, i < firstSentenceEnd, contextClass, contextMember, contextTag, false);
                        if (newTag == null) break;
                        contextTag = newTag;
                        break;
                    }
                    if (c == '\n') {
                        DocImpl.appendToBuf(c);
                        state = 1;
                        break;
                    }
                    if (c == '{' && peek == 64) {
                        paramValue = DocImpl.bufToString();
                        newTag = DocImpl.addTag(tags, "text", paramValue, i < firstSentenceEnd, contextClass, contextMember, contextTag, false);
                        if (newTag != null) {
                            contextTag = newTag;
                        }
                        ++i;
                        DocImpl.setBufLength(0);
                        state = 6;
                        break;
                    }
                    DocImpl.appendToBuf(c);
                    break;
                }
                default: {
                    throw new Error("illegal state " + state);
                }
            }
            ++i;
        }
        if (contextMember == null && boilerplateComment != null && Main.getInstance().isCopyLicenseText()) {
            DocImpl.addTag(tags, "@boilerplate", boilerplateComment, false, contextClass, null, null, false);
        }
        HashMap<String, Tag[]> rc = new HashMap<String, Tag[]>();
        for (String key : tags.keySet()) {
            List list = (List)tags.get(key);
            Tag[] templateArr = "see".equals(key) ? new SeeTag[list.size()] : ("param".equals(key) ? new ParamTag[list.size()] : ("serialField".equals(key) ? new SerialFieldTag[list.size()] : ("throws".equals(key) || "exception".equals(key) ? new ThrowsTag[list.size()] : new Tag[list.size()])));
            rc.put(key, list.toArray(templateArr));
        }
        return rc;
    }

    private ClassDocImpl getContextClass() {
        if (this.isClass() || this.isInterface()) {
            return (ClassDocImpl)this;
        }
        if (this.isField() || this.isMethod() || this.isConstructor()) {
            return (ClassDocImpl)((MemberDocImpl)this).containingClass();
        }
        return null;
    }

    private MemberDocImpl getContextMember() {
        if (this.isField() || this.isMethod() || this.isConstructor()) {
            return (MemberDocImpl)this;
        }
        return null;
    }

    protected static AbstractTagImpl addTag(Map tags, String name, String value, boolean isFirstSentence, ClassDocImpl contextClass, MemberDocImpl contextMember, AbstractTagImpl contextTag, boolean isInline) {
        AbstractTagImpl tag = null;
        boolean haveValue = value.trim().length() != 0;
        String cfr_ignored_0 = "Empty @" + name + " tag.";
        if (name.equals("param")) {
            if (haveValue) {
                tag = new ParamTagImpl(value, contextClass, contextMember);
            }
        } else if (name.equals("see")) {
            if (haveValue) {
                tag = new SeeTagImpl(value, contextClass);
            }
        } else if (name.equals("link") || name.equals("linkplain")) {
            if (haveValue) {
                tag = new LinkTagImpl("@" + name, value, contextClass);
                isInline = true;
            }
        } else if (name.equals("value")) {
            if (haveValue) {
                tag = new ValueTagImpl(value, contextClass);
                isInline = true;
            }
        } else if (name.equals("inheritDoc")) {
            tag = new InheritDocTagImpl(contextClass, contextMember, contextTag);
            isInline = true;
        } else if (name.equals("serialField")) {
            if (haveValue) {
                tag = new SerialFieldTagImpl(value, contextClass, contextMember);
            }
        } else if (name.equals("throws") || name.equals("exception")) {
            if (haveValue) {
                tag = new ThrowsTagImpl(value, contextClass, contextMember);
            }
            name = "throws";
        } else if (name.equals("text")) {
            tag = new TextTagImpl(value);
            isInline = true;
        } else {
            tag = new TagImpl("@" + name, value.trim(), contextClass, contextMember);
        }
        if (tag != null) {
            LinkedList<ParamTagImpl> l;
            if (isInline) {
                ((List)tags.get("inline")).add(tag);
                if (isFirstSentence) {
                    if (name.equals("text")) {
                        String txt = ((TextTagImpl)tag).getText();
                        AbstractTagImpl newTag = txt.startsWith("<p>") ? new TextTagImpl(txt.substring(3)) : (txt.endsWith("</p>") ? new TextTagImpl(txt.substring(0, txt.length() - 4)) : tag);
                        ((List)tags.get("first")).add(newTag);
                    } else {
                        ((List)tags.get("first")).add(tag);
                    }
                }
            } else {
                ((List)tags.get("all")).add(tag);
            }
            if ((l = (LinkedList<ParamTagImpl>)tags.get(name)) == null) {
                l = new LinkedList<ParamTagImpl>();
                tags.put(name, l);
            }
            l.add((ParamTagImpl)tag);
            return isInline ? tag : contextTag;
        }
        return null;
    }

    public Tag[] tags() {
        Tag[] rc = (Tag[])this.tagMap.get("all");
        if (rc == null) {
            rc = new Tag[]{};
        }
        return rc;
    }

    public Tag[] tags(String tagname) {
        Tag[] rc = (Tag[])this.tagMap.get(tagname);
        if (rc == null) {
            rc = new Tag[]{};
        }
        return rc;
    }

    public Map getTagMap() {
        return this.tagMap;
    }

    protected void resolveTags() {
        Tag[] tags = this.tags();
        int i = 0;
        while (i < tags.length) {
            ((AbstractTagImpl)tags[i]).resolve();
            ++i;
        }
        Tag[] inlineTags = this.inlineTags();
        int i2 = 0;
        while (i2 < inlineTags.length) {
            ((AbstractTagImpl)inlineTags[i2]).resolve();
            ++i2;
        }
    }

    private static File getFile(ClassDoc classDoc) {
        File result = (File)classDocToFileMap.get(classDoc);
        if (result == null) {
            result = new File(((GjdocPackageDoc)classDoc.containingPackage()).packageDirectory(), String.valueOf(classDoc.name()) + ".java");
            classDocToFileMap.put(classDoc, result);
        }
        return result;
    }

    public static SourcePosition getPosition(ClassDoc classDoc) {
        return new SourcePositionImpl(DocImpl.getFile(classDoc), 0, 0);
    }

    public static SourcePosition getPosition(ClassDoc classDoc, char[] source, int startIndex) {
        ClassDoc containingClassDoc;
        int column = 0;
        int line = 0;
        int i = 0;
        while (i < startIndex) {
            if ('\n' == source[i]) {
                ++line;
                column = 0;
            } else if ('\r' != source[i]) {
                ++column;
            }
            ++i;
        }
        while ((containingClassDoc = classDoc.containingClass()) != null) {
            classDoc = containingClassDoc;
        }
        File file = DocImpl.getFile(classDoc);
        return new SourcePositionImpl(file, line + 1, column + 1);
    }

    public SourcePosition position() {
        return this.position;
    }

    public DocImpl(SourcePosition position) {
        this.position = position;
    }

    public void setPosition(SourcePosition position) {
        this.position = position;
    }

    private static TagContainer checkForInheritedDoc(ClassDoc classDoc, MemberDocImpl memberDoc, AbstractTagImpl tag) {
        DocImpl result;
        if (!(classDoc instanceof ClassDocImpl)) {
            result = null;
        } else if (memberDoc == null) {
            result = (DocImpl)((Object)classDoc);
        } else if (memberDoc.isField()) {
            result = (DocImpl)((Object)((ClassDocImpl)classDoc).getFieldDoc(memberDoc.name()));
        } else if (memberDoc.isMethod()) {
            result = (DocImpl)((Object)((ClassDocImpl)classDoc).getMethodDoc(memberDoc.name(), ((MethodDoc)((Object)memberDoc)).signature()));
        } else if (memberDoc.isConstructor()) {
            result = (DocImpl)((Object)((ClassDocImpl)classDoc).getConstructorDoc(((ConstructorDoc)((Object)memberDoc)).signature()));
        } else {
            throw new RuntimeException("memberDoc is supposed to be field, method or constructor");
        }
        if (result != null && memberDoc != null && tag != null) {
            TagContainer tagDoc = null;
            Tag[] tags = result.tags();
            int i = 0;
            while (i < tags.length) {
                if (tags[i].kind().equals(tag.kind())) {
                    if ("@param".equals(tag.kind())) {
                        if (((ParamTagImpl)tags[i]).parameterName().equals(((ParamTagImpl)tag).parameterName())) {
                            tagDoc = (TagContainer)((Object)tags[i]);
                            break;
                        }
                    } else if ("@throws".equals(tag.kind())) {
                        if (((ThrowsTagImpl)tags[i]).exceptionName().equals(((ThrowsTagImpl)tag).exceptionName())) {
                            tagDoc = (TagContainer)((Object)tags[i]);
                            break;
                        }
                    } else if ("@return".equals(tag.kind())) {
                        tagDoc = (TagContainer)((Object)tags[i]);
                    }
                }
                ++i;
            }
            return tagDoc;
        }
        if (result == null || result.isEmptyDoc()) {
            return null;
        }
        return result;
    }

    public static TagContainer findInheritedDoc(ClassDoc classDoc, MemberDocImpl memberDoc, AbstractTagImpl tag) {
        TagContainer result;
        int i;
        ClassDoc[] interfaces = classDoc.interfaces();
        if (interfaces != null) {
            i = 0;
            while (i < interfaces.length) {
                result = DocImpl.checkForInheritedDoc(interfaces[i], memberDoc, tag);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        if (interfaces != null) {
            i = 0;
            while (i < interfaces.length) {
                result = DocImpl.findInheritedDoc(interfaces[i], memberDoc, tag);
                if (result != null) {
                    return result;
                }
                ++i;
            }
        }
        ClassDoc superclassDoc = classDoc.superclass();
        if (!classDoc.isInterface() && superclassDoc != null && !"java.lang.Object".equals(classDoc.qualifiedTypeName())) {
            result = DocImpl.checkForInheritedDoc(superclassDoc, memberDoc, tag);
            if (result != null) {
                return result;
            }
            return DocImpl.findInheritedDoc(superclassDoc, memberDoc, tag);
        }
        return null;
    }

    public boolean isEmptyDoc() {
        return this.tagMap.isEmpty();
    }

    void setBoilerplateComment(String boilerplateComment) {
        this.boilerplateComment = boilerplateComment;
    }
}

