/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.doclets.xmldoclet.doctranslet;

import com.sun.javadoc.DocErrorReporter;
import gnu.classpath.tools.IOToolkit;
import gnu.classpath.tools.doclets.xmldoclet.doctranslet.DocTransletConfigurationException;
import gnu.classpath.tools.doclets.xmldoclet.doctranslet.DocTransletException;
import gnu.classpath.tools.doclets.xmldoclet.doctranslet.DocTransletOptions;
import gnu.classpath.tools.doclets.xmldoclet.doctranslet.JarClassLoader;
import gnu.classpath.tools.doclets.xmldoclet.doctranslet.OutputFileInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocTranslet
implements ErrorListener {
    private String mainResourceFilename;
    private ClassLoader classLoader;
    private Map transformerMap = new HashMap();
    private DocTransletOptions options;
    private static boolean cacheXSLTSheets = true;

    protected DocTranslet(String mainResourceFilename, ClassLoader classLoader) throws DocTransletConfigurationException {
        if (mainResourceFilename.length() > 0 && mainResourceFilename.charAt(0) == '/') {
            mainResourceFilename = mainResourceFilename.substring(1);
        }
        this.mainResourceFilename = mainResourceFilename;
        this.classLoader = classLoader;
    }

    private static boolean equalsFile(File file1, File file2) {
        return file1.getAbsolutePath().equals(file2.getAbsolutePath());
    }

    private static File getParentFile(File file) {
        int lastSlash;
        String filename = file.getAbsolutePath();
        if (filename.endsWith(File.separator)) {
            filename = filename.substring(0, filename.length() - 1);
        }
        filename = (lastSlash = filename.lastIndexOf(File.separatorChar)) > 0 ? filename.substring(0, lastSlash) : File.separator;
        return new File(filename);
    }

    public void apply(File xmlSourceDirectory, File targetDirectory, DocErrorReporter reporter) throws DocTransletException {
        PrintStream err = System.err;
        try {
            try {
                URL mainResourceURL;
                URL uRL = mainResourceURL = this.classLoader == null ? ClassLoader.getSystemResource(this.mainResourceFilename) : this.classLoader.getResource(this.mainResourceFilename);
                if (mainResourceURL == null) {
                    throw new DocTransletException("Cannot find resource '" + this.mainResourceFilename + "'");
                }
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("gjdoc.xmldoclet.version", "0.6.1");
                parameters.put("gjdoc.option.nonavbar", DocTranslet.xsltBoolean(this.options.nonavbar));
                parameters.put("gjdoc.option.noindex", DocTranslet.xsltBoolean(this.options.noindex));
                parameters.put("gjdoc.option.notree", DocTranslet.xsltBoolean(this.options.notree));
                parameters.put("gjdoc.option.nocomment", DocTranslet.xsltBoolean(this.options.nocomment));
                parameters.put("gjdoc.option.nohelp", DocTranslet.xsltBoolean(this.options.nohelp));
                parameters.put("gjdoc.option.splitindex", DocTranslet.xsltBoolean(this.options.splitindex));
                parameters.put("gjdoc.option.linksource", DocTranslet.xsltBoolean(this.options.linksource));
                parameters.put("gjdoc.option.nodeprecatedlist", DocTranslet.xsltBoolean(this.options.nodeprecatedlist));
                parameters.put("gjdoc.option.uses", DocTranslet.xsltBoolean(this.options.uses));
                parameters.put("gjdoc.option.windowtitle", this.options.windowtitle);
                parameters.put("gjdoc.option.helpfile", this.options.helpfile);
                parameters.put("gjdoc.option.stylesheetfile", this.options.stylesheetfile);
                parameters.put("gjdoc.option.header", this.options.header);
                parameters.put("gjdoc.option.footer", this.options.footer);
                parameters.put("gjdoc.option.bottom", this.options.bottom);
                parameters.put("gjdoc.option.doctitle", this.options.doctitle);
                List outputFileList = this.getOutputFileList(mainResourceURL, xmlSourceDirectory, parameters);
                reporter.printNotice("Running DocTranslet...");
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                transformerFactory.setErrorListener(this);
                boolean isLibxmlJ = transformerFactory.getClass().getName().equals("gnu.xml.libxmlj.transform.TransformerFactoryImpl");
                Iterator it = outputFileList.iterator();
                while (it.hasNext()) {
                    Object out;
                    File usesTargetDirectory;
                    File usesTargetFile;
                    File usesPackageTargetDir;
                    File sourceTargetDirectory;
                    File sourceTargetFile;
                    File sourcePackageTargetDir;
                    OutputFileInfo fileInfo;
                    File targetFile;
                    File packageTargetDir;
                    if (isLibxmlJ) {
                        System.gc();
                        Runtime.getRuntime().runFinalization();
                    }
                    if (!(packageTargetDir = DocTranslet.getParentFile(targetFile = new File(targetDirectory, (fileInfo = (OutputFileInfo)it.next()).getName()))).exists() && !packageTargetDir.mkdirs()) {
                        throw new DocTransletException("Target directory " + packageTargetDir + " does not exist and cannot be created.");
                    }
                    if (this.options.linksource && !(sourcePackageTargetDir = DocTranslet.getParentFile(sourceTargetFile = new File(sourceTargetDirectory = new File(targetDirectory, "src-html"), fileInfo.getName()))).exists() && !sourcePackageTargetDir.mkdirs()) {
                        throw new DocTransletException("Target directory " + packageTargetDir + " does not exist and cannot be created.");
                    }
                    if (this.options.uses && !(usesPackageTargetDir = DocTranslet.getParentFile(usesTargetFile = new File(usesTargetDirectory = new File(targetDirectory, "class-use"), fileInfo.getName()))).exists() && !usesPackageTargetDir.mkdirs()) {
                        throw new DocTransletException("Target directory " + packageTargetDir + " does not exist and cannot be created.");
                    }
                    if (fileInfo.getSource() != null) {
                        reporter.printNotice("Copying " + fileInfo.getComment() + "...");
                        InputStream in = new URL(mainResourceURL, fileInfo.getSource()).openStream();
                        out = new FileOutputStream(targetFile.getAbsolutePath());
                        IOToolkit.copyStream(in, (OutputStream)out);
                        in.close();
                        ((FileOutputStream)out).close();
                        continue;
                    }
                    reporter.printNotice("Generating " + fileInfo.getComment() + "...");
                    String pathToRoot = "";
                    File file = DocTranslet.getParentFile(targetFile);
                    while (!DocTranslet.equalsFile(file, targetDirectory)) {
                        pathToRoot = String.valueOf(pathToRoot) + "../";
                        file = DocTranslet.getParentFile(file);
                    }
                    out = new StreamResult(targetFile.getAbsolutePath());
                    StreamSource in = new StreamSource(new File(xmlSourceDirectory, "index.xml").getAbsolutePath());
                    URL resource = new URL(mainResourceURL, fileInfo.getSheet());
                    StreamSource xsltSource = new StreamSource(resource.toExternalForm());
                    if (fileInfo.getInfo() != null) {
                        parameters.put("gjdoc.outputfile.info", fileInfo.getInfo());
                    }
                    parameters.put("gjdoc.pathtoroot", pathToRoot);
                    Transformer transformer = (Transformer)this.transformerMap.get(xsltSource.getSystemId());
                    if (transformer == null) {
                        transformer = transformerFactory.newTransformer(xsltSource);
                        if (cacheXSLTSheets) {
                            this.transformerMap.put(xsltSource.getSystemId(), transformer);
                        }
                    }
                    transformer.clearParameters();
                    for (String key : parameters.keySet()) {
                        String value = (String)parameters.get(key);
                        transformer.setParameter(key, value);
                    }
                    transformer.setErrorListener(this);
                    DocErrorReporterOutputStream errorReporterOut = new DocErrorReporterOutputStream(reporter);
                    System.setErr(new PrintStream(errorReporterOut));
                    transformer.transform(in, (Result)out);
                    errorReporterOut.flush();
                }
            }
            catch (MalformedURLException e) {
                throw new DocTransletException(e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new DocTransletException(e);
            }
            catch (TransformerException e) {
                throw new DocTransletException(e.getMessageAndLocation(), e);
            }
            catch (IOException e) {
                throw new DocTransletException(e);
            }
        }
        finally {
            System.setErr(err);
        }
    }

    private List getOutputFileList(URL resource, File xmlSourceDirectory, Map parameters) throws DocTransletException {
        try {
            new ByteArrayOutputStream();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DOMResult domResult = new DOMResult(document);
            StreamSource source = new StreamSource(resource.toExternalForm());
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(source);
            transformer.clearParameters();
            for (String key : parameters.keySet()) {
                String value = (String)parameters.get(key);
                transformer.setParameter(key, value);
            }
            transformer.transform(new StreamSource(new File(xmlSourceDirectory, "index.xml").getAbsolutePath()), domResult);
            NodeList nodeList = document.getElementsByTagName("outputfile");
            ArrayList<OutputFileInfo> result = new ArrayList<OutputFileInfo>(nodeList.getLength());
            int i = 0;
            while (i < nodeList.getLength()) {
                Element elem = (Element)nodeList.item(i);
                String name = this.getTextContent(elem.getElementsByTagName("name").item(0));
                String source2 = elem.getElementsByTagName("source").item(0) != null ? this.getTextContent(elem.getElementsByTagName("source").item(0)) : null;
                String sheet = elem.getElementsByTagName("sheet").item(0) != null ? this.getTextContent(elem.getElementsByTagName("sheet").item(0)) : null;
                String comment = this.getTextContent(elem.getElementsByTagName("comment").item(0));
                String info = null;
                if (elem.getElementsByTagName("info").getLength() > 0) {
                    info = elem.getElementsByTagName("info").item(0).getFirstChild() != null ? this.getTextContent(elem.getElementsByTagName("info").item(0)) : "";
                }
                result.add(new OutputFileInfo(name, source2, sheet, comment, info));
                ++i;
            }
            return result;
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new DocTransletException(e);
        }
        catch (TransformerException e) {
            throw new DocTransletException(e.getMessageAndLocation(), e);
        }
        catch (ParserConfigurationException e) {
            throw new DocTransletException(e);
        }
    }

    private String getTextContent(Node elem) {
        StringBuffer result = new StringBuffer();
        NodeList children = elem.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String value;
            Node item = children.item(i);
            if (item != null && (value = item.getNodeValue()) != null) {
                result.append(value);
            }
            ++i;
        }
        return result.toString();
    }

    public void setOptions(DocTransletOptions options) {
        this.options = options;
    }

    public static DocTranslet fromClasspath(String resourceName) throws DocTransletConfigurationException {
        return new DocTranslet(resourceName, DocTranslet.class.getClassLoader());
    }

    public static DocTranslet fromJarFile(File jarFile) throws DocTransletConfigurationException {
        try {
            JarFile inputJarFile = new JarFile(jarFile, false, 1);
            Manifest manifest = inputJarFile.getManifest();
            if (manifest == null) {
                throw new DocTransletConfigurationException("Jar file '" + jarFile + "' doesn't contain a manifest.");
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String docTransletMainEntry = mainAttributes.getValue("doctranslet-main-entry");
            if (docTransletMainEntry == null) {
                throw new DocTransletConfigurationException("Manifest in Jar file '" + jarFile + "' doesn't contain a doctranslet-main-entry specification.");
            }
            return new DocTranslet(docTransletMainEntry, new JarClassLoader(inputJarFile));
        }
        catch (IOException e) {
            throw new DocTransletConfigurationException(e);
        }
    }

    private static String xsltBoolean(boolean b) {
        return b ? "1" : "";
    }

    public void error(TransformerException exception) throws TransformerException {
        throw exception;
    }

    public void fatalError(TransformerException exception) throws TransformerException {
        throw exception;
    }

    public void warning(TransformerException exception) throws TransformerException {
        System.err.println("WWW: " + exception.getMessage());
    }

    private static class DocErrorReporterOutputStream
    extends OutputStream {
        private ByteArrayOutputStream out = new ByteArrayOutputStream();
        private DocErrorReporter reporter;

        public DocErrorReporterOutputStream(DocErrorReporter reporter) {
            this.reporter = reporter;
        }

        public void write(int ch) {
            this.out.write(ch);
            if (ch == 10) {
                this.reporter.printNotice(this.out.toString());
                this.out.reset();
            }
        }
    }
}

