/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.common;

import gnu.classpath.tools.common.Messages;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.Parser;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.ArrayList;

public class ClasspathToolParser
extends Parser {
    private static String getVersionString(String programName) {
        String fmt = Messages.getString("ClasspathToolParser.VersionFormat");
        return MessageFormat.format(fmt, programName, "0.98");
    }

    public ClasspathToolParser(String programName) {
        this(programName, false);
    }

    public ClasspathToolParser(String programName, boolean longOnly) {
        super(programName, ClasspathToolParser.getVersionString(programName), longOnly);
        this.addFinal(new Option('J', Messages.getString("ClasspathToolParser.JArgument"), Messages.getString("ClasspathToolParser.JName"), true){

            public void parsed(String argument) throws OptionException {
            }
        });
    }

    public void parse(String[] inArgs, FileArgumentCallback files, boolean handleFileLists) {
        FileArgumentCallback cb = handleFileLists ? new AtFileArgumentCallback(files) : files;
        this.parse(inArgs, cb);
    }

    public String[] parse(String[] inArgs, boolean handleFileLists) {
        final ArrayList fileResult = new ArrayList();
        FileArgumentCallback cb = new FileArgumentCallback(){

            public void notifyFile(String fileArgument) {
                fileResult.add(fileArgument);
            }
        };
        if (handleFileLists) {
            this.parse(inArgs, new AtFileArgumentCallback(cb));
        } else {
            this.parse(inArgs, cb);
        }
        return fileResult.toArray(new String[fileResult.size()]);
    }

    public void parseFileList(Reader reader, FileArgumentCallback cb) throws OptionException {
        BufferedReader breader = new BufferedReader(reader);
        String line = null;
        try {
            while ((line = breader.readLine()) != null) {
                this.parseLine(line, cb);
            }
            reader.close();
        }
        catch (IOException ioe) {
            throw new OptionException("I/O error while reading a file list", ioe);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseLine(String line, FileArgumentCallback cb) throws IOException, OptionException {
        length = line.length();
        start = 0;
        end = 0;
        ** GOTO lbl15
        {
            if (++start == length) {
                return;
            }
            do {
                if (Character.isWhitespace(line.codePointAt(start))) continue block0;
                end = start + 1;
                while (end < length && !Character.isWhitespace(line.codePointAt(end))) {
                    ++end;
                }
                cb.notifyFile(line.substring(start, end));
                start = end + 1;
lbl15:
                // 2 sources

            } while (start < length);
        }
    }

    class AtFileArgumentCallback
    extends FileArgumentCallback {
        FileArgumentCallback cb;

        AtFileArgumentCallback(FileArgumentCallback cb) {
            this.cb = cb;
        }

        public void notifyFile(String fileArgument) throws OptionException {
            if (fileArgument.codePointAt(0) == 64) {
                FileReader fr = null;
                try {
                    fr = new FileReader(fileArgument.substring(1));
                }
                catch (FileNotFoundException fnfe) {
                    throw new OptionException("File not found: " + fileArgument.substring(1), fnfe);
                }
                ClasspathToolParser.this.parseFileList(fr, this.cb);
            } else {
                this.cb.notifyFile(fileArgument);
            }
        }
    }
}

