/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import gnu.javax.swing.text.html.css.Length;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.BlockView;
import javax.swing.text.html.CSS;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.ParagraphView;
import javax.swing.text.html.StyleSheet;

class TableView
extends BlockView
implements ViewFactory {
    private AttributeSet attributes;
    SizeRequirements[] columnRequirements;
    SizeRequirements totalColumnRequirements = new SizeRequirements();
    int[] columnOffsets;
    int[] columnSpans;
    Length[] columnWidths;
    int numColumns;
    private Length width;
    boolean gridValid = false;
    int cellSpacing;
    private Rectangle tmpRect = new Rectangle();

    public TableView(Element el) {
        super(el, 1);
    }

    public View create(Element elem) {
        View view = null;
        AttributeSet atts = elem.getAttributes();
        Object name = atts.getAttribute(StyleConstants.NameAttribute);
        AttributeSet pAtts = elem.getParentElement().getAttributes();
        Object pName = pAtts.getAttribute(StyleConstants.NameAttribute);
        if (name == HTML.Tag.TR && pName == HTML.Tag.TABLE) {
            view = new RowView(elem);
        } else if ((name == HTML.Tag.TD || name == HTML.Tag.TH) && pName == HTML.Tag.TR) {
            view = new CellView(elem);
        } else if (name == HTML.Tag.CAPTION) {
            view = new ParagraphView(elem);
        } else {
            ViewFactory vf;
            View parent = this.getParent();
            if (parent != null && (vf = parent.getViewFactory()) != null) {
                view = vf.create(elem);
            }
        }
        return view;
    }

    public ViewFactory getViewFactory() {
        return this;
    }

    public AttributeSet getAttributes() {
        if (this.attributes == null) {
            this.attributes = this.getStyleSheet().getViewAttributes(this);
        }
        return this.attributes;
    }

    protected StyleSheet getStyleSheet() {
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        int w;
        this.updateGrid();
        this.calculateColumnRequirements();
        r = super.calculateMinorAxisRequirements(axis, r);
        if (this.width != null && r.minimum < (w = (int)this.width.getValue())) {
            r.minimum = w;
        }
        int adjust = (this.columnRequirements.length + 1) * this.cellSpacing;
        r.minimum += adjust;
        r.preferred += adjust;
        AttributeSet atts = this.getAttributes();
        Object o = atts.getAttribute(CSS.Attribute.TEXT_ALIGN);
        r.alignment = 0.0f;
        if (o != null) {
            String al = o.toString();
            if (al.equals("left")) {
                r.alignment = 0.0f;
            } else if (al.equals("center")) {
                r.alignment = 0.5f;
            } else if (al.equals("right")) {
                r.alignment = 1.0f;
            }
        }
        r.maximum = r.preferred;
        return r;
    }

    protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        this.updateGrid();
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View row = this.getView(i);
            if (row instanceof RowView) {
                ((RowView)row).layoutChanged(axis);
            }
            ++i;
        }
        this.layoutColumns(targetSpan);
        super.layoutMinorAxis(targetSpan, axis, offsets, spans);
    }

    private void calculateColumnRequirements() {
        int numRows = this.getViewCount();
        this.totalColumnRequirements.minimum = 0;
        this.totalColumnRequirements.preferred = 0;
        this.totalColumnRequirements.maximum = 0;
        int r = 0;
        while (r < numRows) {
            View rowView = this.getView(r);
            int numCols = rowView instanceof RowView ? ((RowView)rowView).getViewCount() : 0;
            SizeRequirements total = new SizeRequirements();
            SizeRequirements relTotal = new SizeRequirements();
            float totalPercent = 0.0f;
            int realCol = 0;
            int c = 0;
            while (c < numCols) {
                View v = rowView.getView(c);
                if (v instanceof CellView) {
                    CellView cellView = (CellView)v;
                    int colSpan = cellView.colSpan;
                    if (colSpan > 1) {
                        int cellMin = (int)cellView.getMinimumSpan(0);
                        int cellPref = (int)cellView.getPreferredSpan(0);
                        int cellMax = (int)cellView.getMaximumSpan(0);
                        int currentMin = 0;
                        int currentPref = 0;
                        long currentMax = 0L;
                        int i = 0;
                        while (i < colSpan) {
                            SizeRequirements req = this.columnRequirements[realCol];
                            currentMin += req.minimum;
                            currentPref += req.preferred;
                            currentMax += (long)req.maximum;
                            ++i;
                        }
                        int deltaMin = cellMin - currentMin;
                        int deltaPref = cellPref - currentPref;
                        int deltaMax = (int)((long)cellMax - currentMax);
                        int i2 = 0;
                        while (i2 < colSpan) {
                            SizeRequirements req = this.columnRequirements[realCol];
                            if (deltaMin > 0) {
                                req.minimum += deltaMin / colSpan;
                            }
                            if (deltaPref > 0) {
                                req.preferred += deltaPref / colSpan;
                            }
                            if (deltaMax > 0) {
                                req.maximum += deltaMax / colSpan;
                            }
                            if (this.columnWidths[realCol] == null || !this.columnWidths[realCol].isPercentage()) {
                                total.minimum += req.minimum;
                                total.preferred += req.preferred;
                                total.maximum += req.maximum;
                            } else {
                                relTotal.minimum = Math.max(relTotal.minimum, (int)((float)req.minimum * this.columnWidths[realCol].getValue()));
                                relTotal.preferred = Math.max(relTotal.preferred, (int)((float)req.preferred * this.columnWidths[realCol].getValue()));
                                relTotal.maximum = Math.max(relTotal.maximum, (int)((float)req.maximum * this.columnWidths[realCol].getValue()));
                                totalPercent += this.columnWidths[realCol].getValue();
                            }
                            ++i2;
                        }
                        realCol += colSpan;
                    } else {
                        SizeRequirements req = this.columnRequirements[realCol];
                        req.minimum = Math.max(req.minimum, (int)cellView.getMinimumSpan(0));
                        req.preferred = Math.max(req.preferred, (int)cellView.getPreferredSpan(0));
                        req.maximum = Math.max(req.maximum, (int)cellView.getMaximumSpan(0));
                        if (this.columnWidths[realCol] == null || !this.columnWidths[realCol].isPercentage()) {
                            total.minimum += this.columnRequirements[realCol].minimum;
                            total.preferred += this.columnRequirements[realCol].preferred;
                            total.maximum += this.columnRequirements[realCol].maximum;
                        } else {
                            relTotal.minimum = Math.max(relTotal.minimum, (int)((float)req.minimum / this.columnWidths[c].getValue()));
                            relTotal.preferred = Math.max(relTotal.preferred, (int)((float)req.preferred / this.columnWidths[c].getValue()));
                            relTotal.maximum = Math.max(relTotal.maximum, (int)((float)req.maximum / this.columnWidths[c].getValue()));
                            totalPercent += this.columnWidths[c].getValue();
                        }
                        ++realCol;
                    }
                }
                ++c;
            }
            total.minimum = (int)((float)total.minimum * (1.0f / (1.0f - totalPercent)));
            total.preferred = (int)((float)total.preferred * (1.0f / (1.0f - totalPercent)));
            total.maximum = (int)((float)total.maximum * (1.0f / (1.0f - totalPercent)));
            int rowTotalMin = Math.max(total.minimum, relTotal.minimum);
            int rowTotalPref = Math.max(total.preferred, relTotal.preferred);
            int rowTotalMax = Math.max(total.maximum, relTotal.maximum);
            this.totalColumnRequirements.minimum = Math.max(this.totalColumnRequirements.minimum, rowTotalMin);
            this.totalColumnRequirements.preferred = Math.max(this.totalColumnRequirements.preferred, rowTotalPref);
            this.totalColumnRequirements.maximum = Math.max(this.totalColumnRequirements.maximum, rowTotalMax);
            ++r;
        }
        int numCols = this.columnRequirements.length;
        int i = 0;
        while (i < numCols) {
            if (this.columnWidths[i] != null) {
                this.columnRequirements[i].minimum = (int)this.columnWidths[i].getValue(this.totalColumnRequirements.minimum);
                this.columnRequirements[i].preferred = (int)this.columnWidths[i].getValue(this.totalColumnRequirements.preferred);
                this.columnRequirements[i].maximum = (int)this.columnWidths[i].getValue(this.totalColumnRequirements.maximum);
            }
            ++i;
        }
    }

    private void layoutColumns(int targetSpan) {
        long sumPref = 0L;
        int n = this.columnRequirements.length;
        int i = 0;
        while (i < n) {
            SizeRequirements col = this.columnRequirements[i];
            this.columnSpans[i] = this.columnWidths[i] != null ? (int)this.columnWidths[i].getValue(targetSpan) : col.preferred;
            sumPref += (long)this.columnSpans[i];
            ++i;
        }
        long diff = (long)(targetSpan - (n + 1) * this.cellSpacing) - sumPref;
        float factor = 0.0f;
        int[] diffs = null;
        if (diff != 0L) {
            long total = 0L;
            diffs = new int[n];
            int i2 = 0;
            while (i2 < n) {
                if (this.columnWidths[i2] == null) {
                    int span;
                    SizeRequirements col = this.columnRequirements[i2];
                    if (diff < 0L) {
                        span = col.minimum;
                        diffs[i2] = this.columnSpans[i2] - span;
                    } else {
                        span = col.maximum;
                        diffs[i2] = span - this.columnSpans[i2];
                    }
                    total += (long)span;
                } else {
                    total += (long)this.columnSpans[i2];
                }
                ++i2;
            }
            float maxAdjust = Math.abs(total - sumPref);
            factor = (float)diff / maxAdjust;
            factor = Math.min(factor, 1.0f);
            factor = Math.max(factor, -1.0f);
        }
        int totalOffs = this.cellSpacing;
        int i3 = 0;
        while (i3 < n) {
            this.columnOffsets[i3] = totalOffs;
            if (diff != 0L) {
                float adjust = factor * (float)diffs[i3];
                int n2 = i3;
                this.columnSpans[n2] = this.columnSpans[n2] + Math.round(adjust);
            }
            totalOffs = (int)Math.min((long)totalOffs + (long)this.columnSpans[i3] + (long)this.cellSpacing, Integer.MAX_VALUE);
            ++i3;
        }
    }

    void updateGrid() {
        if (!this.gridValid) {
            AttributeSet atts = this.getAttributes();
            StyleSheet ss = this.getStyleSheet();
            float emBase = ss.getEMBase(atts);
            float exBase = ss.getEXBase(atts);
            int maxColumns = 0;
            int numRows = this.getViewCount();
            int r = 0;
            while (r < numRows) {
                View rowView = this.getView(r);
                int numCols = 0;
                if (rowView instanceof RowView) {
                    int numCells = ((RowView)rowView).getViewCount();
                    int i = 0;
                    while (i < numCells) {
                        View v = rowView.getView(i);
                        if (v instanceof CellView) {
                            numCols += ((CellView)v).colSpan;
                        }
                        ++i;
                    }
                }
                maxColumns = Math.max(numCols, maxColumns);
                ++r;
            }
            this.numColumns = maxColumns;
            this.columnWidths = new Length[maxColumns];
            int[] rowSpans = new int[maxColumns];
            int r2 = 0;
            while (r2 < numRows) {
                View view = this.getView(r2);
                if (view instanceof RowView) {
                    RowView rowView = (RowView)view;
                    rowView.rowIndex = r2;
                    rowView.overlap = new boolean[maxColumns];
                    int colIndex = 0;
                    int colCount = rowView.getViewCount();
                    int c = 0;
                    while (c < maxColumns) {
                        if (rowSpans[c] > 0) {
                            int n = c;
                            rowSpans[n] = rowSpans[n] - 1;
                            rowView.overlap[c] = true;
                            ++c;
                            continue;
                        }
                        if (colIndex < colCount) {
                            View v = rowView.getView(colIndex);
                            ++colIndex;
                            if (!(v instanceof CellView)) continue;
                            CellView cv = (CellView)v;
                            Object o = cv.getAttributes().getAttribute(CSS.Attribute.WIDTH);
                            if (o != null && this.columnWidths[c] == null && o instanceof Length) {
                                this.columnWidths[c] = (Length)o;
                                this.columnWidths[c].setFontBases(emBase, exBase);
                            }
                            int rs = cv.rowSpan - 1;
                            int col = cv.colSpan - 1;
                            while (col >= 0) {
                                rowSpans[c] = rs;
                                ++c;
                                --col;
                            }
                            continue;
                        }
                        ++c;
                    }
                }
                ++r2;
            }
            this.columnRequirements = new SizeRequirements[maxColumns];
            int i = 0;
            while (i < maxColumns) {
                this.columnRequirements[i] = new SizeRequirements();
                ++i;
            }
            this.columnOffsets = new int[maxColumns];
            this.columnSpans = new int[maxColumns];
            this.gridValid = true;
        }
    }

    public float getMaximumSpan(int axis) {
        float span = axis == 0 ? super.getPreferredSpan(axis) : super.getMaximumSpan(axis);
        return span;
    }

    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet atts = this.getAttributes();
        StyleSheet ss = this.getStyleSheet();
        float emBase = ss.getEMBase(atts);
        float exBase = ss.getEXBase(atts);
        Object o = atts.getAttribute(CSS.Attribute.BORDER_SPACING);
        if (o != null && o instanceof Length) {
            Length l = (Length)o;
            l.setFontBases(emBase, exBase);
            this.cellSpacing = (int)l.getValue();
        }
        if ((o = atts.getAttribute(CSS.Attribute.WIDTH)) != null && o instanceof Length) {
            this.width = (Length)o;
            this.width.setFontBases(emBase, exBase);
        }
    }

    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        r = super.calculateMajorAxisRequirements(axis, r);
        int adjust = (this.getViewCount() + 1) * this.cellSpacing;
        r.minimum += adjust;
        r.preferred += adjust;
        r.maximum += adjust;
        return r;
    }

    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View row = this.getView(i);
            if (row instanceof RowView) {
                ((RowView)row).layoutChanged(axis);
            }
            ++i;
        }
        int adjust = (this.getViewCount() + 1) * this.cellSpacing;
        super.layoutMajorAxis(targetSpan - adjust, axis, offsets, spans);
        int i2 = 0;
        while (i2 < offsets.length) {
            int n2 = i2;
            offsets[n2] = offsets[n2] + (i2 + 1) * this.cellSpacing;
            ++i2;
        }
    }

    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, this);
    }

    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, this);
    }

    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, this);
    }

    public void replace(int offset, int len, View[] views) {
        this.gridValid = false;
        super.replace(offset, len, views);
    }

    public void paint(Graphics g, Shape a) {
        Rectangle rect = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.painter.paint(g, rect.x, rect.y, rect.width, rect.height, this);
        int nRows = this.getViewCount();
        Rectangle inside = this.getInsideAllocation(a);
        int r = 0;
        while (r < nRows) {
            this.tmpRect.setBounds(inside);
            this.childAllocation(r, this.tmpRect);
            this.paintChild(g, this.tmpRect, r);
            ++r;
        }
    }

    class CellView
    extends BlockView {
        int colSpan;
        int rowSpan;

        CellView(Element el) {
            super(el, 1);
        }

        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            r = super.calculateMajorAxisRequirements(axis, r);
            r.maximum = Integer.MAX_VALUE;
            return r;
        }

        protected void setPropertiesFromAttributes() {
            super.setPropertiesFromAttributes();
            this.colSpan = 1;
            AttributeSet atts = this.getAttributes();
            Object o = atts.getAttribute(HTML.Attribute.COLSPAN);
            if (o != null) {
                try {
                    this.colSpan = Integer.parseInt(o.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.colSpan = 1;
                }
            }
            this.rowSpan = 1;
            o = atts.getAttribute(HTML.Attribute.ROWSPAN);
            if (o != null) {
                try {
                    this.rowSpan = Integer.parseInt(o.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    this.rowSpan = 1;
                }
            }
        }
    }

    class RowView
    extends BlockView {
        boolean[] overlap;
        int rowIndex;

        RowView(Element el) {
            super(el, 0);
        }

        public void replace(int offset, int len, View[] views) {
            TableView.this.gridValid = false;
            super.replace(offset, len, views);
        }

        public float getMaximumSpan(int axis) {
            float span = axis == 1 ? super.getPreferredSpan(axis) : 2.1474836E9f;
            return span;
        }

        public float getMinimumSpan(int axis) {
            float span = axis == 0 ? (float)TableView.this.totalColumnRequirements.minimum : super.getMinimumSpan(axis);
            return span;
        }

        public float getPreferredSpan(int axis) {
            float span = axis == 0 ? (float)TableView.this.totalColumnRequirements.preferred : super.getPreferredSpan(axis);
            return span;
        }

        protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
            if (r == null) {
                r = new SizeRequirements();
            }
            int adjust = (TableView.this.columnRequirements.length + 1) * TableView.this.cellSpacing;
            r.minimum = TableView.this.totalColumnRequirements.minimum + adjust;
            r.preferred = TableView.this.totalColumnRequirements.preferred + adjust;
            r.maximum = TableView.this.totalColumnRequirements.maximum + adjust;
            r.alignment = 0.0f;
            return r;
        }

        protected void layoutMinorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            super.layoutMinorAxis(targetSpan, axis, offsets, spans);
            int numCols = this.getViewCount();
            int i = 0;
            while (i < numCols) {
                View v = this.getView(i);
                if (v instanceof CellView) {
                    CellView cell = (CellView)v;
                    if (cell.rowSpan > 1) {
                        int r = 1;
                        while (r < cell.rowSpan) {
                            int n = i;
                            spans[n] = spans[n] + TableView.this.getSpan(axis, this.rowIndex + r);
                            int n2 = i;
                            spans[n2] = spans[n2] + TableView.this.cellSpacing;
                            ++r;
                        }
                    }
                }
                ++i;
            }
        }

        protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
            TableView.this.updateGrid();
            int realColumn = 0;
            int colCount = this.getViewCount();
            int i = 0;
            while (i < TableView.this.numColumns) {
                if (!this.overlap[i] && realColumn < colCount) {
                    View v = this.getView(realColumn);
                    if (v instanceof CellView) {
                        CellView cv = (CellView)v;
                        offsets[realColumn] = TableView.this.columnOffsets[i];
                        spans[realColumn] = 0;
                        int j = 0;
                        while (j < cv.colSpan) {
                            int n = realColumn;
                            spans[n] = spans[n] + TableView.this.columnSpans[i];
                            if (j < cv.colSpan - 1) {
                                int n2 = realColumn;
                                spans[n2] = spans[n2] + TableView.this.cellSpacing;
                            }
                            ++j;
                            ++i;
                        }
                    }
                    ++realColumn;
                    continue;
                }
                ++i;
            }
        }
    }
}

