/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.View;

public class DefaultHighlighter
extends LayeredHighlighter {
    public static final LayeredHighlighter.LayerPainter DefaultPainter = new DefaultHighlightPainter(null);
    private JTextComponent textComponent;
    private ArrayList highlights = new ArrayList();
    private boolean drawsLayeredHighlights = true;

    public boolean getDrawsLayeredHighlights() {
        return this.drawsLayeredHighlights;
    }

    public void setDrawsLayeredHighlights(boolean newValue) {
        this.drawsLayeredHighlights = newValue;
    }

    private void checkPositions(int p0, int p1) throws BadLocationException {
        if (p0 < 0) {
            throw new BadLocationException("DefaultHighlighter", p0);
        }
        if (p1 < p0) {
            throw new BadLocationException("DefaultHighlighter", p1);
        }
    }

    public void install(JTextComponent c) {
        this.textComponent = c;
        this.removeAllHighlights();
    }

    public void deinstall(JTextComponent c) {
        this.textComponent = null;
    }

    public Object addHighlight(int p0, int p1, Highlighter.HighlightPainter painter) throws BadLocationException {
        this.checkPositions(p0, p1);
        Document doc = this.textComponent.getDocument();
        Position pos0 = doc.createPosition(p0);
        Position pos1 = doc.createPosition(p1);
        HighlightEntry entry = this.getDrawsLayeredHighlights() && painter instanceof LayeredHighlighter.LayerPainter ? new LayerHighlightEntry(pos0, pos1, painter) : new HighlightEntry(pos0, pos1, painter);
        this.highlights.add(entry);
        this.textComponent.getUI().damageRange(this.textComponent, p0, p1);
        return entry;
    }

    public void removeHighlight(Object tag) {
        HighlightEntry entry = (HighlightEntry)tag;
        if (entry instanceof LayerHighlightEntry) {
            LayerHighlightEntry lEntry = (LayerHighlightEntry)entry;
            Rectangle paintRect = lEntry.paintRect;
            this.textComponent.repaint(paintRect.x, paintRect.y, paintRect.width, paintRect.height);
        } else {
            this.textComponent.getUI().damageRange(this.textComponent, entry.getStartOffset(), entry.getEndOffset());
        }
        this.highlights.remove(tag);
    }

    public void removeAllHighlights() {
        int minX = 0;
        int maxX = 0;
        int minY = 0;
        int maxY = 0;
        int p0 = -1;
        int p1 = -1;
        for (HighlightEntry e : this.highlights) {
            if (e instanceof LayerHighlightEntry) {
                LayerHighlightEntry le = (LayerHighlightEntry)e;
                Rectangle r = le.paintRect;
                minX = Math.min(r.x, minX);
                maxX = Math.max(r.x + r.width, maxX);
                minY = Math.min(r.y, minY);
                maxY = Math.max(r.y + r.height, maxY);
            } else if (p0 == -1 || p1 == -1) {
                p0 = e.getStartOffset();
                p1 = e.getEndOffset();
            } else {
                p0 = Math.min(p0, e.getStartOffset());
                p1 = Math.max(p1, e.getEndOffset());
            }
            if (minX != maxX && minY != maxY) {
                this.textComponent.repaint(minX, minY, maxX - minX, maxY - minY);
            }
            if (p0 == -1 || p1 == -1) continue;
            TextUI ui = this.textComponent.getUI();
            ui.damageRange(this.textComponent, p0, p1);
        }
        this.highlights.clear();
    }

    public Highlighter.Highlight[] getHighlights() {
        return this.highlights.toArray(new Highlighter.Highlight[this.highlights.size()]);
    }

    public void changeHighlight(Object tag, int n0, int n1) throws BadLocationException {
        Document doc = this.textComponent.getDocument();
        TextUI ui = this.textComponent.getUI();
        if (tag instanceof LayerHighlightEntry) {
            LayerHighlightEntry le = (LayerHighlightEntry)tag;
            Rectangle r = le.paintRect;
            if (r.width > 0 && r.height > 0) {
                this.textComponent.repaint(r.x, r.y, r.width, r.height);
            }
            r.width = 0;
            r.height = 0;
            le.p0 = doc.createPosition(n0);
            le.p1 = doc.createPosition(n1);
            ui.damageRange(this.textComponent, Math.min(n0, n1), Math.max(n0, n1));
        } else if (tag instanceof HighlightEntry) {
            HighlightEntry e = (HighlightEntry)tag;
            int p0 = e.getStartOffset();
            int p1 = e.getEndOffset();
            if (p0 == n0) {
                ui.damageRange(this.textComponent, Math.min(p1, n1), Math.max(p1, n1));
            } else if (n1 == p1) {
                ui.damageRange(this.textComponent, Math.min(p0, n0), Math.max(p0, n0));
            } else {
                ui.damageRange(this.textComponent, p0, p1);
                ui.damageRange(this.textComponent, n0, n1);
            }
            e.p0 = doc.createPosition(n0);
            e.p1 = doc.createPosition(n1);
        }
    }

    public void paintLayeredHighlights(Graphics g, int p0, int p1, Shape viewBounds, JTextComponent editor, View view) {
        for (Object o : this.highlights) {
            if (!(o instanceof LayerHighlightEntry)) continue;
            LayerHighlightEntry entry = (LayerHighlightEntry)o;
            int start = entry.getStartOffset();
            int end = entry.getEndOffset();
            if ((p0 >= start || p1 <= start) && (p0 < start || p0 >= end)) continue;
            entry.paintLayeredHighlight(g, p0, p1, viewBounds, editor, view);
        }
    }

    public void paint(Graphics g) {
        int size = this.highlights.size();
        if (size == 0) {
            return;
        }
        Insets insets = this.textComponent.getInsets();
        Rectangle bounds = new Rectangle(insets.left, insets.top, this.textComponent.getWidth() - insets.left - insets.right, this.textComponent.getHeight() - insets.top - insets.bottom);
        int index = 0;
        while (index < size) {
            HighlightEntry entry = (HighlightEntry)this.highlights.get(index);
            if (!(entry instanceof LayerHighlightEntry)) {
                entry.painter.paint(g, entry.getStartOffset(), entry.getEndOffset(), bounds, this.textComponent);
            }
            ++index;
        }
    }

    public static class DefaultHighlightPainter
    extends LayeredHighlighter.LayerPainter {
        private Color color;

        public DefaultHighlightPainter(Color c) {
            this.color = c;
        }

        public Color getColor() {
            return this.color;
        }

        public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent t) {
            if (p0 == p1) {
                return;
            }
            Rectangle rect = bounds.getBounds();
            Color col = this.getColor();
            if (col == null) {
                col = t.getSelectionColor();
            }
            g.setColor(col);
            TextUI ui = t.getUI();
            try {
                Rectangle l0 = ui.modelToView(t, p0, null);
                Rectangle l1 = ui.modelToView(t, p1, null);
                if (l0.y == l1.y) {
                    SwingUtilities.computeUnion(l0.x, l0.y, l0.width, l0.height, l1);
                    SwingUtilities.computeIntersection(rect.x, rect.y, rect.width, rect.height, l1);
                    g.fillRect(l1.x, l1.y, l1.width, l1.height);
                } else {
                    int firstLineWidth = rect.x + rect.width - l0.x;
                    g.fillRect(l0.x, l0.y, firstLineWidth, l0.height);
                    if (l0.y + l0.height != l1.y) {
                        g.fillRect(rect.x, l0.y + l0.height, rect.width, l1.y - l0.y - l0.height);
                    }
                    g.fillRect(rect.x, l1.y, l1.x - rect.x, l1.height);
                }
            }
            catch (BadLocationException badLocationException) {}
        }

        public Shape paintLayer(Graphics g, int p0, int p1, Shape bounds, JTextComponent c, View view) {
            Color col = this.getColor();
            if (col == null) {
                col = c.getSelectionColor();
            }
            g.setColor(col);
            Rectangle rect = null;
            if (p0 == view.getStartOffset() && p1 == view.getEndOffset()) {
                rect = bounds instanceof Rectangle ? (Rectangle)bounds : bounds.getBounds();
            } else {
                try {
                    Shape s = view.modelToView(p0, Position.Bias.Forward, p1, Position.Bias.Backward, bounds);
                    rect = s instanceof Rectangle ? (Rectangle)s : s.getBounds();
                }
                catch (BadLocationException badLocationException) {}
            }
            if (rect != null) {
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
            return rect;
        }
    }

    private class HighlightEntry
    implements Highlighter.Highlight {
        Position p0;
        Position p1;
        Highlighter.HighlightPainter painter;

        public HighlightEntry(Position p0, Position p1, Highlighter.HighlightPainter painter) {
            this.p0 = p0;
            this.p1 = p1;
            this.painter = painter;
        }

        public int getStartOffset() {
            return this.p0.getOffset();
        }

        public int getEndOffset() {
            return this.p1.getOffset();
        }

        public Highlighter.HighlightPainter getPainter() {
            return this.painter;
        }
    }

    private class LayerHighlightEntry
    extends HighlightEntry {
        Rectangle paintRect;

        LayerHighlightEntry(Position p0, Position p1, Highlighter.HighlightPainter p) {
            super(p0, p1, p);
            this.paintRect = new Rectangle();
        }

        void paintLayeredHighlight(Graphics g, int p0, int p1, Shape bounds, JTextComponent tc, View view) {
            p0 = Math.max(this.getStartOffset(), p0);
            p1 = Math.min(this.getEndOffset(), p1);
            Highlighter.HighlightPainter painter = this.getPainter();
            if (painter instanceof LayeredHighlighter.LayerPainter) {
                LayeredHighlighter.LayerPainter layerPainter = (LayeredHighlighter.LayerPainter)painter;
                Shape area = layerPainter.paintLayer(g, p0, p1, bounds, tc, view);
                Rectangle rect = area instanceof Rectangle && this.paintRect != null ? (Rectangle)area : area.getBounds();
                this.paintRect = this.paintRect.width == 0 || this.paintRect.height == 0 ? rect.getBounds() : SwingUtilities.computeUnion(rect.x, rect.y, rect.width, rect.height, this.paintRect);
            }
        }
    }
}

