/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;

public class ComponentView
extends View {
    private Component comp;
    private Interceptor interceptor;

    public ComponentView(Element elem) {
        super(elem);
    }

    protected Component createComponent() {
        return StyleConstants.getComponent(this.getElement().getAttributes());
    }

    public float getAlignment(int axis) {
        float align = 0.0f;
        if (this.interceptor != null && (axis == 0 || axis == 1)) {
            if (axis == 0) {
                align = this.interceptor.getAlignmentX();
            } else if (axis == 1) {
                align = this.interceptor.getAlignmentY();
            } else assert (false) : "Must not reach here";
        } else {
            align = super.getAlignment(axis);
        }
        return align;
    }

    public final Component getComponent() {
        return this.comp;
    }

    public float getMaximumSpan(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Illegal axis");
        }
        float span = 0.0f;
        if (this.interceptor != null) {
            if (axis == 0) {
                span = this.interceptor.getMaximumSize().width;
            } else if (axis == 1) {
                span = this.interceptor.getMaximumSize().height;
            } else assert (false) : "Must not reach here";
        }
        return span;
    }

    public float getMinimumSpan(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Illegal axis");
        }
        float span = 0.0f;
        if (this.interceptor != null) {
            if (axis == 0) {
                span = this.interceptor.getMinimumSize().width;
            } else if (axis == 1) {
                span = this.interceptor.getMinimumSize().height;
            } else assert (false) : "Must not reach here";
        }
        return span;
    }

    public float getPreferredSpan(int axis) {
        if (axis != 0 && axis != 1) {
            throw new IllegalArgumentException("Illegal axis");
        }
        float span = 0.0f;
        if (this.interceptor != null) {
            if (axis == 0) {
                span = this.interceptor.getPreferredSize().width;
            } else if (axis == 1) {
                span = this.interceptor.getPreferredSize().height;
            } else assert (false) : "Must not reach here";
        }
        return span;
    }

    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle viewRect = a.getBounds();
            if (pos == p1) {
                viewRect.x += viewRect.width;
            }
            viewRect.width = 0;
            return viewRect;
        }
        throw new BadLocationException("Illegal position", pos);
    }

    public void paint(Graphics g, Shape a) {
        if (this.interceptor != null) {
            Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            this.interceptor.setBounds(r.x, r.y, r.width, r.height);
        }
    }

    public void setParent(View p) {
        super.setParent(p);
        if (SwingUtilities.isEventDispatchThread()) {
            this.setParentImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Document doc = ComponentView.this.getDocument();
                    try {
                        if (doc instanceof AbstractDocument) {
                            ((AbstractDocument)doc).readLock();
                        }
                        ComponentView.this.setParentImpl();
                        Container host = ComponentView.this.getContainer();
                        if (host != null) {
                            ComponentView.this.preferenceChanged(null, true, true);
                            host.repaint();
                        }
                    }
                    finally {
                        if (doc instanceof AbstractDocument) {
                            ((AbstractDocument)doc).readUnlock();
                        }
                    }
                }
            });
        }
    }

    void setParentImpl() {
        Container parent;
        View p = this.getParent();
        if (p != null) {
            Container c = this.getContainer();
            if (c != null) {
                Component created;
                if (this.interceptor == null && (created = this.createComponent()) != null) {
                    this.comp = created;
                    this.interceptor = new Interceptor(this.comp);
                }
                if (this.interceptor != null && this.interceptor.getParent() == null) {
                    c.add((Component)this.interceptor, this);
                }
            }
        } else if (this.interceptor != null && (parent = this.interceptor.getParent()) != null) {
            parent.remove(this.interceptor);
        }
    }

    public int viewToModel(float x, float y, Shape a, Position.Bias[] b) {
        int pos;
        Rectangle r = (Rectangle)a;
        if (x < (float)(r.x + r.width / 2)) {
            b[0] = Position.Bias.Forward;
            pos = this.getStartOffset();
        } else {
            b[0] = Position.Bias.Backward;
            pos = this.getEndOffset();
        }
        return pos;
    }

    private class Interceptor
    extends Container {
        Dimension min;
        Dimension pref;
        Dimension max;
        float alignX;
        float alignY;

        Interceptor(Component c) {
            this.setLayout(null);
            this.add(c);
            this.cacheComponentSizes();
        }

        public void invalidate() {
            super.invalidate();
            if (this.getParent() != null) {
                ComponentView.this.preferenceChanged(null, true, true);
            }
        }

        public void doLayout() {
            this.cacheComponentSizes();
        }

        public void reshape(int x, int y, int w, int h) {
            super.reshape(x, y, w, h);
            if (this.getComponentCount() > 0) {
                this.getComponent(0).setSize(w, h);
            }
            this.cacheComponentSizes();
        }

        public void show() {
            super.show();
            if (this.getComponentCount() > 0) {
                this.getComponent(0).setVisible(true);
            }
        }

        public void hide() {
            super.hide();
            if (this.getComponentCount() > 0) {
                this.getComponent(0).setVisible(false);
            }
        }

        public Dimension getMinimumSize() {
            this.maybeValidate();
            return this.min;
        }

        public Dimension getPreferredSize() {
            this.maybeValidate();
            return this.pref;
        }

        public Dimension getMaximumSize() {
            this.maybeValidate();
            return this.max;
        }

        public float getAlignmentX() {
            this.maybeValidate();
            return this.alignX;
        }

        public float getAlignmentY() {
            this.maybeValidate();
            return this.alignY;
        }

        private void maybeValidate() {
            if (!this.isValid()) {
                this.validate();
            }
        }

        private void cacheComponentSizes() {
            if (this.getComponentCount() > 0) {
                Component c = this.getComponent(0);
                this.min = c.getMinimumSize();
                this.pref = c.getPreferredSize();
                this.max = c.getMaximumSize();
                this.alignX = c.getAlignmentX();
                this.alignY = c.getAlignmentY();
            }
        }
    }
}

