/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    static final long serialVersionUID = 1463404307042803342L;
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler = new MouseHandler();
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;
    transient int currentDividerLocation = 1;
    boolean centerOneTouchButtons;

    public BasicSplitPaneDivider(BasicSplitPaneUI ui) {
        this.setLayout(new DividerLayout());
        this.setBasicSplitPaneUI(ui);
        this.setDividerSize(this.splitPane.getDividerSize());
        this.centerOneTouchButtons = UIManager.getBoolean("SplitPane.centerOneTouchButtons");
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI newUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            this.removeMouseListener(this.mouseHandler);
            this.removeMouseMotionListener(this.mouseHandler);
            this.splitPane = null;
            this.hiddenDivider = null;
        }
        this.splitPaneUI = newUI;
        if (this.splitPaneUI != null) {
            this.splitPane = newUI.getSplitPane();
        }
        if (this.splitPane != null) {
            this.splitPane.addPropertyChangeListener(this);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            this.hiddenDivider = this.splitPaneUI.getNonContinuousLayoutDivider();
            this.orientation = this.splitPane.getOrientation();
            if (this.splitPane.isOneTouchExpandable()) {
                this.oneTouchExpandableChanged();
            }
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int newSize) {
        this.dividerSize = newSize;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        if (border != this.border) {
            Border oldValue = this.border;
            this.border = border;
            this.firePropertyChange("border", oldValue, border);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Dimension getPreferredSize() {
        Dimension d = this.orientation == 1 ? new Dimension(this.getDividerSize(), 1) : new Dimension(1, this.getDividerSize());
        return d;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("oneTouchExpandable")) {
            this.oneTouchExpandableChanged();
        } else if (e.getPropertyName().equals("orientation")) {
            this.orientation = this.splitPane.getOrientation();
            this.invalidate();
            if (this.splitPane != null) {
                this.splitPane.revalidate();
            }
        } else if (e.getPropertyName().equals("dividerSize")) {
            this.dividerSize = this.splitPane.getDividerSize();
        }
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.border != null) {
            Dimension dividerSize = this.getSize();
            this.border.paintBorder(this, g, 0, 0, dividerSize.width, dividerSize.height);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable()) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchAction());
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchAction());
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.invalidate();
        if (this.splitPane != null) {
            this.splitPane.revalidate();
        }
    }

    protected JButton createLeftOneTouchButton() {
        BasicOneTouchButton button = new BasicOneTouchButton(0);
        button.setMinimumSize(new Dimension(6, 6));
        button.setRequestFocusEnabled(false);
        return button;
    }

    protected JButton createRightOneTouchButton() {
        BasicOneTouchButton button = new BasicOneTouchButton(1);
        button.setMinimumSize(new Dimension(6, 6));
        button.setRequestFocusEnabled(false);
        return button;
    }

    protected void prepareForDragging() {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.startDragging();
        }
    }

    protected void dragDividerTo(int location) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.dragDividerTo(location);
        }
    }

    protected void finishDraggingTo(int location) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.finishDraggingTo(location);
        }
    }

    void moveDividerTo(int locationIndex) {
        Insets insets = this.splitPane.getInsets();
        switch (locationIndex) {
            case 1: {
                this.splitPane.setDividerLocation(this.splitPane.getLastDividerLocation());
                break;
            }
            case 0: {
                int top = this.orientation == 1 ? insets.left : insets.top;
                this.splitPane.setDividerLocation(top);
                break;
            }
            case 2: {
                int bottom = this.orientation == 1 ? this.splitPane.getBounds().width - insets.right - this.dividerSize : this.splitPane.getBounds().height - insets.bottom - this.dividerSize;
                this.splitPane.setDividerLocation(bottom);
            }
        }
    }

    private class BasicOneTouchButton
    extends JButton {
        static final int LEFT = 0;
        static final int RIGHT = 1;
        private int[] xpoints;
        private int[] ypoints;
        private int direction;

        BasicOneTouchButton(int dir) {
            this.direction = dir;
            this.xpoints = new int[3];
            this.ypoints = new int[3];
        }

        public void setBorder(Border b) {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paint(Graphics g) {
            if (BasicSplitPaneDivider.this.splitPane != null) {
                g.setColor(BasicSplitPaneDivider.this.splitPane.getBackground());
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
                if (this.direction == 0) {
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int size = Math.min(this.getHeight(), 6);
                        this.xpoints[0] = 0;
                        this.xpoints[1] = size / 2;
                        this.xpoints[2] = size;
                        this.ypoints[0] = size;
                        this.ypoints[1] = 0;
                        this.ypoints[2] = size;
                    } else {
                        int size;
                        this.xpoints[0] = size = Math.min(this.getWidth(), 6);
                        this.xpoints[1] = 0;
                        this.xpoints[2] = size;
                        this.ypoints[0] = 0;
                        this.ypoints[1] = size / 2;
                        this.ypoints[2] = size;
                    }
                } else if (BasicSplitPaneDivider.this.orientation == 0) {
                    int size = Math.min(this.getHeight(), 6);
                    this.xpoints[0] = 0;
                    this.xpoints[1] = size / 2;
                    this.xpoints[2] = size;
                    this.ypoints[0] = 0;
                    this.ypoints[1] = size;
                    this.ypoints[2] = 0;
                } else {
                    int size = Math.min(this.getWidth(), 6);
                    this.xpoints[0] = 0;
                    this.xpoints[1] = size;
                    this.xpoints[2] = 0;
                    this.ypoints[0] = 0;
                    this.ypoints[1] = size / 2;
                    this.ypoints[2] = size;
                }
                g.setColor(Color.BLACK);
                g.fillPolygon(this.xpoints, this.ypoints, 3);
            }
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        public void addLayoutComponent(String string, Component c) {
        }

        public void layoutContainer(Container c) {
            if (BasicSplitPaneDivider.this.leftButton != null && BasicSplitPaneDivider.this.rightButton != null && c == BasicSplitPaneDivider.this) {
                if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = BasicSplitPaneDivider.this.getInsets();
                    if (BasicSplitPaneDivider.this.orientation == 1) {
                        int x;
                        int y;
                        int size = BasicSplitPaneDivider.this.getWidth() - insets.left - insets.right;
                        size = Math.max(size, 0);
                        size = Math.min(size, 6);
                        if (BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            y = insets.top;
                            x = (BasicSplitPaneDivider.this.getWidth() - size) / 2;
                        } else {
                            x = insets.left;
                            y = 0;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(x, y + 2, size, size * 2);
                        BasicSplitPaneDivider.this.rightButton.setBounds(x, y + 2 + 12, size, size * 2);
                    } else {
                        int y;
                        int x;
                        int size = BasicSplitPaneDivider.this.getHeight() - insets.top - insets.bottom;
                        size = Math.max(size, 0);
                        size = Math.min(size, 6);
                        if (BasicSplitPaneDivider.this.centerOneTouchButtons) {
                            x = insets.left;
                            y = (BasicSplitPaneDivider.this.getHeight() - size) / 2;
                        } else {
                            x = 0;
                            y = insets.top;
                        }
                        BasicSplitPaneDivider.this.leftButton.setBounds(x + 2, y, size * 2, size);
                        BasicSplitPaneDivider.this.rightButton.setBounds(x + 2 + 12, y, size * 2, size);
                    }
                } else {
                    BasicSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    BasicSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        public Dimension preferredLayoutSize(Container c) {
            return new Dimension(BasicSplitPaneDivider.this.dividerSize, BasicSplitPaneDivider.this.dividerSize);
        }

        public void removeLayoutComponent(Component c) {
        }
    }

    protected class DragController {
        transient int offset;

        protected DragController(MouseEvent e) {
            this.offset = e.getX();
        }

        protected boolean isValid() {
            return true;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            return e.getX() + BasicSplitPaneDivider.this.getX() - this.offset;
        }

        protected int getNeededLocation(int x, int y) {
            return x;
        }

        protected void continueDrag(int newX, int newY) {
            if (this.isValid()) {
                BasicSplitPaneDivider.this.dragDividerTo(this.adjust(newX, newY));
            }
        }

        protected void continueDrag(MouseEvent e) {
            if (this.isValid()) {
                BasicSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(e));
            }
        }

        protected void completeDrag(int x, int y) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.adjust(x, y));
        }

        protected void completeDrag(MouseEvent e) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(e));
        }

        int adjust(int x, int y) {
            return this.getNeededLocation(x, y) + BasicSplitPaneDivider.this.getX() - this.offset;
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private transient boolean isDragging;

        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent e) {
            this.isDragging = true;
            BasicSplitPaneDivider.this.currentDividerLocation = 1;
            BasicSplitPaneDivider.this.dragger = BasicSplitPaneDivider.this.orientation == 1 ? new DragController(e) : new VerticalDragController(e);
            BasicSplitPaneDivider.this.prepareForDragging();
        }

        public void mouseReleased(MouseEvent e) {
            if (this.isDragging) {
                BasicSplitPaneDivider.this.dragger.completeDrag(e);
            }
            this.isDragging = false;
        }

        public void mouseDragged(MouseEvent e) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                BasicSplitPaneDivider.this.dragger.continueDrag(e);
            }
        }

        public void mouseMoved(MouseEvent e) {
        }
    }

    private class OneTouchAction
    implements ActionListener {
        private OneTouchAction() {
        }

        public void actionPerformed(ActionEvent ev) {
            Insets insets = BasicSplitPaneDivider.this.splitPane.getInsets();
            int lastLoc = BasicSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int currentLoc = BasicSplitPaneDivider.this.splitPaneUI.getDividerLocation(BasicSplitPaneDivider.this.splitPane);
            int newLoc = ev.getSource() == BasicSplitPaneDivider.this.leftButton ? (BasicSplitPaneDivider.this.orientation == 0 ? (currentLoc >= BasicSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - BasicSplitPaneDivider.this.getHeight() ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), lastLoc) : insets.top) : (currentLoc >= BasicSplitPaneDivider.this.splitPane.getWidth() - insets.right - BasicSplitPaneDivider.this.getWidth() ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), lastLoc) : insets.left)) : (BasicSplitPaneDivider.this.orientation == 0 ? (currentLoc == insets.top ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), lastLoc) : BasicSplitPaneDivider.this.splitPane.getHeight() - insets.top - BasicSplitPaneDivider.this.getHeight()) : (currentLoc == insets.left ? Math.min(BasicSplitPaneDivider.this.splitPane.getMaximumDividerLocation(), lastLoc) : BasicSplitPaneDivider.this.splitPane.getWidth() - insets.left - BasicSplitPaneDivider.this.getWidth()));
            if (currentLoc != newLoc) {
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(newLoc);
                BasicSplitPaneDivider.this.splitPane.setLastDividerLocation(currentLoc);
            }
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent e) {
            super(e);
            this.offset = e.getY();
        }

        protected int getNeededLocation(int x, int y) {
            return y;
        }

        protected int positionForMouseEvent(MouseEvent e) {
            return e.getY() + BasicSplitPaneDivider.this.getY() - this.offset;
        }

        int adjust(int x, int y) {
            return this.getNeededLocation(x, y) + BasicSplitPaneDivider.this.getY() - this.offset;
        }
    }
}

