/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import gnu.javax.management.ListenerData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;

public class NotificationBroadcasterSupport
implements NotificationEmitter {
    private Executor executor;
    private MBeanNotificationInfo[] info;
    private final List<ListenerData> listeners = new ArrayList<ListenerData>();

    public NotificationBroadcasterSupport() {
        this((Executor)null, (MBeanNotificationInfo[])null);
    }

    public NotificationBroadcasterSupport(Executor executor) {
        this(executor, new MBeanNotificationInfo[]{null});
    }

    public NotificationBroadcasterSupport(MBeanNotificationInfo ... info) {
        this((Executor)null, info);
    }

    public NotificationBroadcasterSupport(Executor executor, MBeanNotificationInfo ... info) {
        this.executor = executor;
        this.info = info;
    }

    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object passback) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("Null listener added to bean.");
        }
        this.listeners.add(new ListenerData(listener, filter, passback));
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.info == null || this.info.length == 0) {
            return new MBeanNotificationInfo[0];
        }
        return (MBeanNotificationInfo[])this.info.clone();
    }

    protected void handleNotification(NotificationListener listener, Notification notif, Object passback) {
        listener.handleNotification(notif, passback);
    }

    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        Iterator<ListenerData> it = this.listeners.iterator();
        boolean foundOne = false;
        while (it.hasNext()) {
            if (it.next().getListener() != listener) continue;
            it.remove();
            foundOne = true;
        }
        if (!foundOne) {
            throw new ListenerNotFoundException("The specified listener, " + listener + "is not registered with this bean.");
        }
    }

    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object passback) throws ListenerNotFoundException {
        if (!this.listeners.remove(new ListenerData(listener, filter, passback))) {
            throw new ListenerNotFoundException("The specified listener, " + listener + " with filter " + filter + "and passback " + passback + ", is not registered with this bean.");
        }
    }

    public void sendNotification(Notification notif) {
        for (ListenerData ldata : this.listeners) {
            NotificationFilter filter = ldata.getFilter();
            if (filter != null && !filter.isNotificationEnabled(notif)) continue;
            if (this.executor == null) {
                try {
                    this.handleNotification(ldata.getListener(), notif, ldata.getPassback());
                }
                catch (Exception exception) {}
                continue;
            }
            this.executor.execute(new DispatchTask(ldata, notif));
        }
    }

    private final class DispatchTask
    implements Runnable {
        private ListenerData ldata;
        private Notification notif;

        public DispatchTask(ListenerData ldata, Notification notif) {
            this.ldata = ldata;
            this.notif = notif;
        }

        public void run() {
            try {
                NotificationBroadcasterSupport.this.handleNotification(this.ldata.getListener(), this.notif, this.ldata.getPassback());
            }
            catch (Exception exception) {}
        }
    }
}

