/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DeleteFileHelper;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class File
implements Serializable,
Comparable<File> {
    private static final long serialVersionUID = 301077366599181567L;
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int EXISTS = 2;
    private static final int EXEC = 3;
    private static final int DIRECTORY = 0;
    private static final int ISFILE = 1;
    private static final int ISHIDDEN = 2;
    private static final int MODIFIED = 0;
    private static final int LENGTH = 1;
    public static final String separator = System.getProperty("file.separator");
    private static final String dupSeparator = String.valueOf(separator) + separator;
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    static final String tmpdir = System.getProperty("java.io.tmpdir");
    static int maxPathLen;
    static boolean caseSensitive;
    private String path;
    private static long counter;

    static {
        File.init_native();
        counter = Double.doubleToLongBits(Math.random());
    }

    private final native long attr(int var1);

    private final native boolean _access(int var1);

    private final native boolean _stat(int var1);

    private static native void init_native();

    public boolean canRead() {
        this.checkRead();
        return this._access(0);
    }

    public boolean canWrite() {
        this.checkWrite();
        return this._access(1);
    }

    public boolean canExecute() {
        if (!this.exists()) {
            return false;
        }
        this.checkExec();
        return this._access(3);
    }

    private native boolean performCreate() throws IOException;

    public boolean createNewFile() throws IOException {
        this.checkWrite();
        return this.performCreate();
    }

    private native boolean performDelete();

    public synchronized boolean delete() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkDelete(this.path);
        }
        return this.performDelete();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        File other = (File)obj;
        if (caseSensitive) {
            return this.path.equals(other.path);
        }
        return this.path.equalsIgnoreCase(other.path);
    }

    private boolean internalExists() {
        return this._access(2);
    }

    public boolean exists() {
        this.checkRead();
        return this.internalExists();
    }

    public File(String name) {
        this.path = this.normalizePath(name);
    }

    private String normalizePath(String p) {
        if (separatorChar == '\\' && (p = p.replace('/', '\\')).length() > 2 && p.charAt(0) == '\\' && (p.charAt(1) >= 'a' && p.charAt(1) <= 'z' || p.charAt(1) >= 'A' && p.charAt(1) <= 'Z') && p.charAt(2) == ':') {
            p = p.substring(1);
        }
        int dupIndex = p.indexOf(dupSeparator);
        int plen = p.length();
        if (dupSeparator.equals("\\\\") && dupIndex == 0) {
            dupIndex = p.indexOf(dupSeparator, 1);
        }
        if (dupIndex == -1) {
            if (plen > 1 && p.charAt(plen - 1) == separatorChar) {
                if (separatorChar != '\\' || plen != 3 || p.charAt(1) != ':') {
                    return p.substring(0, plen - 1);
                }
            } else {
                return p;
            }
        }
        StringBuffer newpath = new StringBuffer(plen);
        int last = 0;
        while (dupIndex != -1) {
            newpath.append(p.substring(last, dupIndex));
            while (p.charAt(dupIndex) == separatorChar) {
                if (++dupIndex != plen) continue;
                return newpath.toString();
            }
            newpath.append(separatorChar);
            last = dupIndex;
            dupIndex = p.indexOf(dupSeparator, last);
        }
        int end = plen > 1 && p.charAt(plen - 1) == separatorChar ? (separatorChar == '\\' && plen == 3 && p.charAt(1) == ':' ? plen : plen - 1) : plen;
        newpath.append(p.substring(last, end));
        return newpath.toString();
    }

    public File(String dirPath, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (dirPath != null) {
            if (dirPath.length() > 0) {
                this.path = dirPath.charAt(dirPath.length() - 1) == separatorChar || name.length() == 0 ? this.normalizePath(String.valueOf(dirPath) + name) : this.normalizePath(String.valueOf(dirPath) + separatorChar + name);
            } else {
                if (separatorChar == '\\') {
                    int skip = 0;
                    while (name.length() > skip && (name.charAt(skip) == separatorChar || name.charAt(skip) == '/')) {
                        ++skip;
                    }
                    name = name.substring(skip);
                }
                this.path = this.normalizePath(String.valueOf(separatorChar) + name);
            }
        } else {
            this.path = this.normalizePath(name);
        }
    }

    public File(File directory, String name) {
        this(directory == null ? null : directory.path, name);
    }

    public File(URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        if (!uri.getScheme().equals("file")) {
            throw new IllegalArgumentException("invalid uri protocol");
        }
        String name = uri.getPath();
        if (name == null) {
            throw new IllegalArgumentException("URI \"" + uri + "\" is not hierarchical");
        }
        this.path = this.normalizePath(name);
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        if (separatorChar == '\\' && this.path.length() > 0 && this.path.charAt(0) == '\\') {
            return String.valueOf(System.getProperty("user.dir").substring(0, 2)) + this.path;
        }
        if (separatorChar == '\\' && this.path.length() > 1 && this.path.charAt(1) == ':' && (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z')) {
            String drvDir = null;
            try {
                drvDir = new File(this.path.substring(0, 2)).getCanonicalPath();
            }
            catch (IOException iOException) {
                drvDir = String.valueOf(this.path.substring(0, 2)) + "\\";
            }
            if (this.path.length() > 2) {
                return String.valueOf(drvDir) + '\\' + this.path.substring(2, this.path.length());
            }
            return drvDir;
        }
        return String.valueOf(System.getProperty("user.dir")) + separatorChar + this.path;
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public native String getCanonicalPath() throws IOException;

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public String getName() {
        int nameSeqIndex = 0;
        if (separatorChar == '\\' && this.path.length() > 1 && (this.path.charAt(0) == '\\' && this.path.charAt(1) == '\\' || (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':')) {
            if (this.path.length() > 2) {
                nameSeqIndex = 2;
            } else {
                return "";
            }
        }
        String nameSeq = nameSeqIndex > 0 ? this.path.substring(nameSeqIndex) : this.path;
        int last = nameSeq.lastIndexOf(separatorChar);
        return nameSeq.substring(last + 1);
    }

    public String getParent() {
        String prefix = null;
        int nameSeqIndex = 0;
        if (separatorChar == '/' && this.path.charAt(0) == '/') {
            prefix = "/";
            nameSeqIndex = 1;
        } else if (separatorChar == '\\' && this.path.length() > 1 && (this.path.charAt(0) == '\\' && this.path.charAt(1) == '\\' || (this.path.charAt(0) >= 'a' && this.path.charAt(0) <= 'z' || this.path.charAt(0) >= 'A' && this.path.charAt(0) <= 'Z') && this.path.charAt(1) == ':')) {
            prefix = this.path.substring(0, 2);
            nameSeqIndex = 2;
        }
        if (nameSeqIndex < this.path.length()) {
            String nameSeq = this.path.substring(nameSeqIndex, this.path.length());
            int last = nameSeq.lastIndexOf(separatorChar);
            if (last == -1) {
                return prefix;
            }
            if (last == nameSeq.length() - 1) {
                return null;
            }
            if (last == 0) {
                ++last;
            }
            if (prefix != null) {
                return String.valueOf(prefix) + nameSeq.substring(0, last);
            }
            return nameSeq.substring(0, last);
        }
        return null;
    }

    public File getParentFile() {
        String parent = this.getParent();
        return parent != null ? new File(parent) : null;
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        if (caseSensitive) {
            return this.path.hashCode() ^ 0x12D591;
        }
        return this.path.toLowerCase().hashCode() ^ 0x12D591;
    }

    public native boolean isAbsolute();

    private boolean internalIsDirectory() {
        return this._stat(0);
    }

    public boolean isDirectory() {
        this.checkRead();
        return this.internalIsDirectory();
    }

    public boolean isFile() {
        this.checkRead();
        return this._stat(1);
    }

    public boolean isHidden() {
        this.checkRead();
        return this._stat(2);
    }

    public long lastModified() {
        this.checkRead();
        return this.attr(0);
    }

    public long length() {
        this.checkRead();
        return this.attr(1);
    }

    private final native Object[] performList(FilenameFilter var1, FileFilter var2, Class var3);

    public String[] list(FilenameFilter filter) {
        this.checkRead();
        return (String[])this.performList(filter, null, String.class);
    }

    public String[] list() {
        this.checkRead();
        return (String[])this.performList(null, null, String.class);
    }

    public File[] listFiles() {
        this.checkRead();
        return (File[])this.performList(null, null, File.class);
    }

    public File[] listFiles(FilenameFilter filter) {
        this.checkRead();
        return (File[])this.performList(filter, null, File.class);
    }

    public File[] listFiles(FileFilter filter) {
        this.checkRead();
        return (File[])this.performList(null, filter, File.class);
    }

    public String toString() {
        return this.path;
    }

    public URI toURI() {
        String abspath = this.getAbsolutePath();
        if (this.isDirectory()) {
            abspath = String.valueOf(abspath) + separator;
        }
        try {
            return new URI("file", abspath.replace(separatorChar, '/'), null);
        }
        catch (URISyntaxException use) {
            throw new RuntimeException(use);
        }
    }

    public URL toURL() throws MalformedURLException {
        if (separatorChar == '\\') {
            return new URL("file:/" + this.getAbsolutePath().replace('\\', '/') + (this.isDirectory() ? "/" : ""));
        }
        return new URL("file:" + this.getAbsolutePath() + (this.isDirectory() ? "/" : ""));
    }

    private final native boolean performMkdir();

    public boolean mkdir() {
        this.checkWrite();
        return this.performMkdir();
    }

    private static boolean mkdirs(File x) {
        if (x.isDirectory()) {
            return true;
        }
        String p = x.getPath();
        String parent = x.getParent();
        if (parent != null) {
            x.path = parent;
            if (!File.mkdirs(x)) {
                return false;
            }
            x.path = p;
        }
        return x.mkdir();
    }

    public boolean mkdirs() {
        this.checkWrite();
        if (this.isDirectory()) {
            return false;
        }
        return File.mkdirs(new File(this.path));
    }

    private static synchronized String nextValue() {
        return Long.toString(counter++, 36);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (directory == null) {
            String dirname = tmpdir;
            if (dirname == null) {
                throw new IOException("Cannot determine system temporary directory");
            }
            directory = new File(dirname);
            if (!directory.internalExists()) {
                throw new IOException("System temporary directory " + directory.getName() + " does not exist.");
            }
            if (!directory.internalIsDirectory()) {
                throw new IOException("System temporary directory " + directory.getName() + " is not really a directory.");
            }
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix too short: " + prefix);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (maxPathLen > 0 && prefix.length() + 6 + suffix.length() > maxPathLen) {
            int suf_len = 0;
            if (suffix.charAt(0) == '.') {
                suf_len = 4;
            }
            suffix = suffix.substring(0, suf_len);
            if (prefix.length() + 6 + suf_len > maxPathLen) {
                prefix = prefix.substring(0, maxPathLen - 6 - suf_len);
            }
        }
        int i = 0;
        while (i < 100) {
            String t = "ZZZZZZ" + File.nextValue();
            String l = String.valueOf(prefix) + t.substring(t.length() - 6) + suffix;
            try {
                File f = new File(directory, l);
                if (f.createNewFile()) {
                    return f;
                }
            }
            catch (IOException iOException) {}
            ++i;
        }
        throw new IOException("cannot create temporary file");
    }

    private native boolean setFilePermissions(boolean var1, boolean var2, int var3);

    public boolean setReadable(boolean readable) {
        return this.setReadable(readable, true);
    }

    public boolean setReadable(boolean readable, boolean ownerOnly) {
        this.checkWrite();
        return this.setFilePermissions(readable, ownerOnly, 0);
    }

    public boolean setWritable(boolean writable) {
        return this.setWritable(writable, true);
    }

    public boolean setWritable(boolean writable, boolean ownerOnly) {
        this.checkWrite();
        return this.setFilePermissions(writable, ownerOnly, 1);
    }

    public boolean setExecutable(boolean executable) {
        return this.setExecutable(executable, true);
    }

    public boolean setExecutable(boolean executable, boolean ownerOnly) {
        this.checkWrite();
        return this.setFilePermissions(executable, ownerOnly, 3);
    }

    private native boolean performSetReadOnly();

    public boolean setReadOnly() {
        this.checkWrite();
        return this.performSetReadOnly();
    }

    private static native File[] performListRoots();

    public static File[] listRoots() {
        File[] roots = File.performListRoots();
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            int count = roots.length;
            int i = 0;
            while (i < roots.length) {
                try {
                    s.checkRead(roots[i].path);
                }
                catch (SecurityException securityException) {
                    roots[i] = null;
                    --count;
                }
                ++i;
            }
            if (count != roots.length) {
                File[] newRoots = new File[count];
                int k = 0;
                int i2 = 0;
                while (i2 < roots.length) {
                    if (roots[i2] != null) {
                        newRoots[k++] = roots[i2];
                    }
                    ++i2;
                }
                roots = newRoots;
            }
        }
        return roots;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    @Override
    public int compareTo(File other) {
        if (caseSensitive) {
            return this.path.compareTo(other.path);
        }
        return this.path.compareToIgnoreCase(other.path);
    }

    private native boolean performRenameTo(File var1);

    public synchronized boolean renameTo(File dest) {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(this.getPath());
            s.checkWrite(dest.getPath());
        }
        return this.performRenameTo(dest);
    }

    private native boolean performSetLastModified(long var1);

    public boolean setLastModified(long time) {
        if (time < 0L) {
            throw new IllegalArgumentException("Negative modification time: " + time);
        }
        this.checkWrite();
        return this.performSetLastModified(time);
    }

    private void checkWrite() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(this.path);
        }
    }

    private void checkRead() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(this.path);
        }
    }

    private void checkExec() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkExec(this.path);
        }
    }

    public void deleteOnExit() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkDelete(this.getPath());
        }
        DeleteFileHelper.add(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeChar(separatorChar);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        char oldSeparatorChar = ois.readChar();
        if (oldSeparatorChar != separatorChar) {
            this.path = this.path.replace(oldSeparatorChar, separatorChar);
        }
    }
}

