/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.Serializable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterBlock
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -7577115551785240750L;
    protected Vector<Object> sources;
    protected Vector<Object> parameters;

    public ParameterBlock() {
        this(new Vector<Object>(), new Vector<Object>());
    }

    public ParameterBlock(Vector<Object> sources) {
        this(sources, new Vector<Object>());
    }

    public ParameterBlock(Vector<Object> sources, Vector<Object> parameters) {
        this.sources = sources;
        this.parameters = parameters;
    }

    public Object shallowClone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public Object clone() {
        ParameterBlock pb = (ParameterBlock)this.shallowClone();
        if (this.sources != null) {
            pb.sources = (Vector)this.sources.clone();
        }
        if (this.parameters != null) {
            pb.parameters = (Vector)this.parameters.clone();
        }
        return pb;
    }

    public ParameterBlock addSource(Object source) {
        this.sources.add(source);
        return this;
    }

    public Object getSource(int index) {
        return this.sources.get(index);
    }

    public ParameterBlock setSource(Object source, int index) {
        this.sources.ensureCapacity(index);
        this.sources.set(index, source);
        return this;
    }

    public RenderedImage getRenderedSource(int index) {
        return (RenderedImage)this.sources.get(index);
    }

    public RenderableImage getRenderableSource(int index) {
        return (RenderableImage)this.sources.get(index);
    }

    public int getNumSources() {
        return this.sources.size();
    }

    public Vector<Object> getSources() {
        return this.sources;
    }

    public void setSources(Vector<Object> sources) {
        this.sources = sources;
    }

    public void removeSources() {
        if (this.sources != null) {
            this.sources.clear();
        }
    }

    public int getNumParameters() {
        return this.parameters.size();
    }

    public Vector<Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Vector<Object> parameters) {
        this.parameters = parameters;
    }

    public void removeParameters() {
        if (this.parameters != null) {
            this.parameters.clear();
        }
    }

    public ParameterBlock add(Object o) {
        this.parameters.add(o);
        return this;
    }

    public ParameterBlock add(byte b) {
        return this.add(new Byte(b));
    }

    public ParameterBlock add(char c) {
        return this.add(new Character(c));
    }

    public ParameterBlock add(short s) {
        return this.add(new Short(s));
    }

    public ParameterBlock add(int i) {
        return this.add(new Integer(i));
    }

    public ParameterBlock add(long l) {
        return this.add(new Long(l));
    }

    public ParameterBlock add(float f) {
        return this.add(new Float(f));
    }

    public ParameterBlock add(double d) {
        return this.add(new Double(d));
    }

    public ParameterBlock set(Object o, int index) {
        this.parameters.ensureCapacity(index);
        this.parameters.set(index, o);
        return this;
    }

    public ParameterBlock set(byte b, int index) {
        return this.set(new Byte(b), index);
    }

    public ParameterBlock set(char c, int index) {
        return this.set(new Character(c), index);
    }

    public ParameterBlock set(short s, int index) {
        return this.set(new Short(s), index);
    }

    public ParameterBlock set(int i, int index) {
        return this.set(new Integer(i), index);
    }

    public ParameterBlock set(long l, int index) {
        return this.set(new Long(l), index);
    }

    public ParameterBlock set(float f, int index) {
        return this.set(new Float(f), index);
    }

    public ParameterBlock set(double d, int index) {
        return this.set(new Double(d), index);
    }

    public Object getObjectParameter(int index) {
        return this.parameters.get(index);
    }

    public byte getByteParameter(int index) {
        return (Byte)this.parameters.get(index);
    }

    public char getCharParameter(int index) {
        return ((Character)this.parameters.get(index)).charValue();
    }

    public short getShortParameter(int index) {
        return (Short)this.parameters.get(index);
    }

    public int getIntParameter(int index) {
        return (Integer)this.parameters.get(index);
    }

    public long getLongParameter(int index) {
        return (Long)this.parameters.get(index);
    }

    public float getFloatParameter(int index) {
        return ((Float)this.parameters.get(index)).floatValue();
    }

    public double getDoubleParameter(int index) {
        return (Double)this.parameters.get(index);
    }

    public Class[] getParamClasses() {
        int i = this.parameters.size();
        Class[] result = new Class[i];
        while (--i >= 0) {
            Class<? extends Object> c = this.parameters.get(i).getClass();
            result[i] = c == Byte.class ? Byte.TYPE : (c == Character.class ? Character.TYPE : (c == Short.class ? Short.TYPE : (c == Integer.class ? Integer.TYPE : (c == Long.class ? Long.TYPE : (c == Float.class ? Float.TYPE : (c == Double.class ? Double.TYPE : c))))));
        }
        return result;
    }
}

