/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.xpath;

import gnu.xml.xpath.Expr;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SumFunction
extends Expr {
    final Expr arg;

    SumFunction(List<Expr> args) {
        this(args.get(0));
    }

    SumFunction(Expr arg) {
        this.arg = arg;
    }

    @Override
    public Object evaluate(Node context, int pos, int len) {
        Object val = this.arg.evaluate(context, pos, len);
        double sum = 0.0;
        if (val instanceof Collection) {
            Collection nodes = (Collection)val;
            for (Node node2 : nodes) {
                String s = SumFunction.stringValue(node2);
                sum += SumFunction._number(context, s);
            }
        }
        return new Double(sum);
    }

    @Override
    public Expr clone(Object context) {
        return new SumFunction(this.arg.clone(context));
    }

    @Override
    public boolean references(QName var) {
        return this.arg.references(var);
    }

    public String toString() {
        return "sum(" + this.arg + ")";
    }
}

