/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.IntegerSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.Destination;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.RequestingUserName;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class PrinterDialog
extends JDialog
implements ActionListener {
    private JButton ok_bt;
    private JButton cancel_bt;
    private GeneralPanel general_panel;
    private PageSetupPanel pagesetup_panel;
    private AppearancePanel appearance_panel;
    private PrintService[] services;
    private PrintService defaultService;
    private PrintService selectedService;
    private DocFlavor flavor;
    private PrintRequestAttributeSet attributes;
    private boolean onlyPageDialog;
    private PrintRequestAttributeSet atts;
    private static final ResourceBundle messages = ResourceBundle.getBundle("gnu/javax/print/PrinterDialog");

    private PrinterDialog(GraphicsConfiguration gc, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes, boolean onlyPageDialog, String title) throws HeadlessException {
        super((Frame)null, title, true, gc);
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        if (flavor != null) {
            ArrayList<PrintService> list2 = new ArrayList<PrintService>(services.length);
            int i = 0;
            while (i < services.length) {
                if (services[i].isDocFlavorSupported(flavor)) {
                    list2.add(services[i]);
                }
                ++i;
            }
            if (defaultService != null && !list2.contains(defaultService)) {
                defaultService = (PrintService)list2.get(0);
            }
            PrintService[] newServices = new PrintService[list2.size()];
            this.services = list2.toArray(newServices);
        } else {
            this.services = services;
        }
        this.defaultService = defaultService == null ? services[0] : defaultService;
        this.selectedService = this.defaultService;
        this.flavor = flavor;
        this.attributes = attributes;
        this.atts = new HashPrintRequestAttributeSet(attributes);
        this.onlyPageDialog = onlyPageDialog;
        this.initUI(onlyPageDialog);
        this.pack();
        this.updateAll();
    }

    public PrinterDialog(GraphicsConfiguration gc, PrintService service, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        this(gc, new PrintService[]{service}, service, flavor, attributes, true, PrinterDialog.getLocalizedString("title.pagedialog"));
    }

    public PrinterDialog(GraphicsConfiguration gc, PrintService[] services, PrintService defaultService, DocFlavor flavor, PrintRequestAttributeSet attributes) throws HeadlessException {
        this(gc, services, defaultService, flavor, attributes, false, PrinterDialog.getLocalizedString("title.printdialog"));
    }

    private void initUI(boolean onlyPageDialog) {
        JPanel buttonPane = new JPanel();
        if (onlyPageDialog) {
            JPanel pane = new JPanel();
            pane.setLayout(new BorderLayout());
            this.pagesetup_panel = new PageSetupPanel();
            pane.add((Component)this.pagesetup_panel, "Center");
            this.ok_bt = new JButton(PrinterDialog.getLocalizedString("bt.OK"));
            this.ok_bt.addActionListener(this);
            this.cancel_bt = new JButton(PrinterDialog.getLocalizedString("bt.cancel"));
            this.cancel_bt.addActionListener(this);
            this.getContentPane().add((Component)pane, "Center");
        } else {
            this.general_panel = new GeneralPanel();
            this.pagesetup_panel = new PageSetupPanel();
            this.appearance_panel = new AppearancePanel();
            JTabbedPane pane = new JTabbedPane();
            pane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.ok_bt = new JButton(PrinterDialog.getLocalizedString("bt.print"));
            this.ok_bt.addActionListener(this);
            this.cancel_bt = new JButton(PrinterDialog.getLocalizedString("bt.cancel"));
            this.cancel_bt.addActionListener(this);
            pane.addTab(PrinterDialog.getLocalizedString("tab.general"), this.general_panel);
            pane.addTab(PrinterDialog.getLocalizedString("tab.pagesetup"), this.pagesetup_panel);
            pane.addTab(PrinterDialog.getLocalizedString("tab.appearance"), this.appearance_panel);
            this.getContentPane().add((Component)pane, "Center");
        }
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(this.ok_bt);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(this.cancel_bt);
        this.getContentPane().add((Component)buttonPane, "Last");
    }

    public PrintRequestAttributeSet getAttributes() {
        return this.attributes;
    }

    public PrintService getSelectedPrintService() {
        return this.selectedService;
    }

    protected void setSelectedPrintService(PrintService service) {
        this.selectedService = service;
    }

    protected PrintService[] getPrintServices() {
        return this.services;
    }

    void updateAll() {
        this.pagesetup_panel.update();
        if (!this.onlyPageDialog) {
            this.general_panel.update();
            this.appearance_panel.update();
        }
    }

    boolean categorySupported(Class category) {
        return this.getSelectedPrintService().isAttributeCategorySupported(category);
    }

    Object defaultValue(Class category) {
        return this.getSelectedPrintService().getDefaultAttributeValue(category);
    }

    Attribute attribute(Class category) {
        return this.atts.get(category);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ok_bt) {
            this.setVisible(false);
            this.attributes.addAll(this.atts);
            this.dispose();
        } else {
            this.setVisible(false);
            this.selectedService = null;
            this.dispose();
        }
    }

    static final String getLocalizedString(String key) {
        return messages.getString(key);
    }

    final class AppearancePanel
    extends JPanel {
        private Quality quality_panel;
        private JobAttributes jobAttr_panel;
        private SidesPanel sides_panel;
        private Color chromaticy_panel;

        public AppearancePanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.quality_panel = new Quality();
            this.jobAttr_panel = new JobAttributes();
            this.sides_panel = new SidesPanel();
            this.chromaticy_panel = new Color();
            JPanel layout_panel = new JPanel();
            layout_panel.setLayout(new BoxLayout(layout_panel, 2));
            layout_panel.add(this.chromaticy_panel);
            layout_panel.add(Box.createRigidArea(new Dimension(10, 0)));
            layout_panel.add(this.quality_panel);
            JPanel layout2_panel = new JPanel();
            layout2_panel.setLayout(new BoxLayout(layout2_panel, 2));
            layout2_panel.add(this.sides_panel);
            layout2_panel.add(Box.createRigidArea(new Dimension(10, 0)));
            layout2_panel.add(this.jobAttr_panel);
            this.setLayout(new BoxLayout(this, 3));
            this.add(layout_panel);
            this.add(Box.createRigidArea(new Dimension(0, 12)));
            this.add(layout2_panel);
        }

        void update() {
            this.quality_panel.updateForSelectedService();
            this.jobAttr_panel.updateForSelectedService();
            this.sides_panel.updateForSelectedService();
            this.chromaticy_panel.updateForSelectedService();
        }

        final class Color
        extends JPanel
        implements ActionListener {
            private JRadioButton bw = new JRadioButton(PrinterDialog.getLocalizedString("rbt.blackwhite"));
            private JRadioButton color;

            Color() {
                this.bw.addActionListener(this);
                this.color = new JRadioButton(PrinterDialog.getLocalizedString("rbt.color"));
                this.color.addActionListener(this);
                ButtonGroup group = new ButtonGroup();
                group.add(this.bw);
                group.add(this.color);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.color")));
                c.fill = 2;
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.bw, c);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.color, c);
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == this.bw) {
                    PrinterDialog.this.atts.add(Chromaticity.MONOCHROME);
                } else {
                    PrinterDialog.this.atts.add(Chromaticity.COLOR);
                }
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(Chromaticity.class)) {
                    this.bw.setEnabled(true);
                    this.color.setEnabled(true);
                    Object defaultValue = PrinterDialog.this.defaultValue(Chromaticity.class);
                    Attribute chromaticity = PrinterDialog.this.attribute(Chromaticity.class);
                    if (chromaticity != null) {
                        if (chromaticity.equals(Chromaticity.MONOCHROME)) {
                            this.bw.setSelected(true);
                        } else {
                            this.color.setSelected(true);
                        }
                    } else if (defaultValue.equals(Chromaticity.MONOCHROME)) {
                        this.bw.setSelected(true);
                    } else {
                        this.color.setSelected(true);
                    }
                } else {
                    this.bw.setEnabled(false);
                    this.color.setEnabled(false);
                }
            }
        }

        final class JobAttributes
        extends JPanel
        implements ActionListener,
        ChangeListener,
        FocusListener {
            private JLabel jobname = new JLabel(PrinterDialog.getLocalizedString("lb.jobname"));
            private JLabel username = new JLabel(PrinterDialog.getLocalizedString("lb.username"));
            private JLabel priority_lb = new JLabel(PrinterDialog.getLocalizedString("lb.priority"));
            private JTextField jobname_tf;
            private JTextField username_tf;
            private JCheckBox cover = new JCheckBox(PrinterDialog.getLocalizedString("cb.cover"));
            private JSpinner priority;
            private SpinnerNumberModel model;

            JobAttributes() {
                this.cover.addActionListener(this);
                this.model = new SpinnerNumberModel(1, 1, 100, 1);
                this.priority = new JSpinner(this.model);
                this.priority.addChangeListener(this);
                this.jobname_tf = new JTextField();
                this.jobname_tf.addFocusListener(this);
                this.username_tf = new JTextField();
                this.username_tf.addFocusListener(this);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.jobattributes")));
                c.insets = new Insets(10, 5, 10, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.cover, c);
                c.anchor = 22;
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 2.0;
                this.add((Component)this.priority_lb, c);
                c.gridx = 2;
                c.gridy = 0;
                c.weightx = 0.5;
                this.add((Component)this.priority, c);
                c.anchor = 22;
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.jobname, c);
                c.gridx = 0;
                c.gridy = 2;
                this.add((Component)this.username, c);
                c.anchor = 10;
                c.fill = 2;
                c.gridx = 1;
                c.gridy = 1;
                c.gridwidth = 2;
                c.weightx = 1.5;
                this.add((Component)this.jobname_tf, c);
                c.insets = new Insets(10, 5, 15, 5);
                c.gridx = 1;
                c.gridy = 2;
                this.add((Component)this.username_tf, c);
            }

            public void actionPerformed(ActionEvent event) {
                if (this.cover.isSelected()) {
                    PrinterDialog.this.atts.add(JobSheets.STANDARD);
                } else {
                    PrinterDialog.this.atts.add(JobSheets.NONE);
                }
            }

            public void stateChanged(ChangeEvent event) {
                int value = (Integer)this.priority.getValue();
                PrinterDialog.this.atts.add(new JobPriority(value));
            }

            public void focusGained(FocusEvent event) {
                this.updateTextfields(event);
            }

            public void focusLost(FocusEvent event) {
                this.updateTextfields(event);
            }

            private void updateTextfields(FocusEvent event) {
                if (event.getSource() == this.jobname_tf) {
                    PrinterDialog.this.atts.add(new JobName(this.jobname_tf.getText(), null));
                } else {
                    PrinterDialog.this.atts.add(new RequestingUserName(this.username_tf.getText(), null));
                }
            }

            void updateForSelectedService() {
                Object value;
                if (PrinterDialog.this.categorySupported(JobPriority.class)) {
                    JobPriority prio = (JobPriority)PrinterDialog.this.attribute(JobPriority.class);
                    value = (JobPriority)PrinterDialog.this.defaultValue(JobPriority.class);
                    this.priority.setEnabled(true);
                    if (prio != null) {
                        this.model.setValue(new Integer(prio.getValue()));
                    } else {
                        this.model.setValue(new Integer(((IntegerSyntax)value).getValue()));
                    }
                } else {
                    this.priority.setEnabled(false);
                }
                if (PrinterDialog.this.categorySupported(RequestingUserName.class)) {
                    Attribute user = PrinterDialog.this.attribute(RequestingUserName.class);
                    value = PrinterDialog.this.defaultValue(RequestingUserName.class);
                    this.username.setEnabled(true);
                    if (user != null) {
                        this.username_tf.setText(user.toString());
                    } else {
                        this.username_tf.setText(value.toString());
                    }
                } else {
                    this.username.setEnabled(false);
                }
                if (PrinterDialog.this.categorySupported(JobName.class)) {
                    Attribute job = PrinterDialog.this.attribute(JobName.class);
                    value = PrinterDialog.this.defaultValue(JobName.class);
                    this.jobname.setEnabled(true);
                    if (job != null) {
                        this.jobname_tf.setText(job.toString());
                    } else {
                        this.jobname_tf.setText(value.toString());
                    }
                } else {
                    this.jobname.setEnabled(false);
                }
                if (PrinterDialog.this.categorySupported(JobSheets.class)) {
                    Attribute sheet = PrinterDialog.this.attribute(JobSheets.class);
                    value = PrinterDialog.this.defaultValue(JobSheets.class);
                    this.cover.setEnabled(true);
                    if (sheet != null) {
                        if (sheet.equals(JobSheets.NONE)) {
                            this.cover.setSelected(false);
                        } else {
                            this.cover.setSelected(true);
                        }
                    } else if (value.equals(JobSheets.NONE)) {
                        this.cover.setSelected(false);
                    } else {
                        this.cover.setSelected(true);
                    }
                } else {
                    this.cover.setEnabled(false);
                }
            }
        }

        final class Quality
        extends JPanel
        implements ActionListener {
            private JRadioButton low = new JRadioButton(PrinterDialog.getLocalizedString("rbt.low"));
            private JRadioButton normal;
            private JRadioButton high;
            private ButtonGroup group;

            Quality() {
                this.low.addActionListener(this);
                this.normal = new JRadioButton(PrinterDialog.getLocalizedString("rbt.normal"));
                this.normal.addActionListener(this);
                this.high = new JRadioButton(PrinterDialog.getLocalizedString("rbt.high"));
                this.high.addActionListener(this);
                this.group = new ButtonGroup();
                this.group.add(this.low);
                this.group.add(this.normal);
                this.group.add(this.high);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.quality")));
                c.fill = 2;
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.low, c);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.normal, c);
                c.gridx = 0;
                c.gridy = 2;
                this.add((Component)this.high, c);
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == this.low) {
                    PrinterDialog.this.atts.add(PrintQuality.DRAFT);
                } else if (e.getSource() == this.normal) {
                    PrinterDialog.this.atts.add(PrintQuality.NORMAL);
                } else {
                    PrinterDialog.this.atts.add(PrintQuality.HIGH);
                }
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(PrintQuality.class)) {
                    this.low.setEnabled(true);
                    this.normal.setEnabled(true);
                    this.high.setEnabled(true);
                    Object defaultValue = PrinterDialog.this.defaultValue(PrintQuality.class);
                    Attribute quality = PrinterDialog.this.attribute(PrintQuality.class);
                    if (quality != null) {
                        if (quality.equals(PrintQuality.DRAFT)) {
                            this.low.setSelected(true);
                        } else if (quality.equals(PrintQuality.NORMAL)) {
                            this.normal.setSelected(true);
                        } else {
                            this.high.setSelected(true);
                        }
                    } else if (defaultValue.equals(PrintQuality.DRAFT)) {
                        this.low.setSelected(true);
                    } else if (defaultValue.equals(PrintQuality.NORMAL)) {
                        this.normal.setSelected(true);
                    } else {
                        this.high.setSelected(true);
                    }
                } else {
                    this.low.setEnabled(false);
                    this.normal.setEnabled(false);
                    this.high.setEnabled(false);
                }
            }
        }

        final class SidesPanel
        extends JPanel
        implements ActionListener {
            private JRadioButton oneside = new JRadioButton(PrinterDialog.getLocalizedString("rbt.onesided"));
            private JRadioButton calendar;
            private JRadioButton duplex;

            SidesPanel() {
                this.oneside.addActionListener(this);
                this.calendar = new JRadioButton(PrinterDialog.getLocalizedString("rbt.calendar"));
                this.calendar.addActionListener(this);
                this.duplex = new JRadioButton(PrinterDialog.getLocalizedString("rbt.duplex"));
                this.duplex.addActionListener(this);
                ButtonGroup group = new ButtonGroup();
                group.add(this.oneside);
                group.add(this.calendar);
                group.add(this.duplex);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.sides")));
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.oneside, c);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.calendar, c);
                c.gridx = 0;
                c.gridy = 2;
                this.add((Component)this.duplex, c);
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == this.calendar) {
                    PrinterDialog.this.atts.add(Sides.TWO_SIDED_SHORT_EDGE);
                } else if (e.getSource() == this.oneside) {
                    PrinterDialog.this.atts.add(Sides.ONE_SIDED);
                } else {
                    PrinterDialog.this.atts.add(Sides.TWO_SIDED_LONG_EDGE);
                }
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(Sides.class)) {
                    this.oneside.setEnabled(true);
                    this.calendar.setEnabled(true);
                    this.duplex.setEnabled(true);
                    Object defaultValue = PrinterDialog.this.defaultValue(Sides.class);
                    Attribute sides = PrinterDialog.this.attribute(Sides.class);
                    if (sides != null) {
                        if (sides.equals(Sides.TWO_SIDED_SHORT_EDGE)) {
                            this.calendar.setSelected(true);
                        } else if (sides.equals(Sides.ONE_SIDED)) {
                            this.oneside.setSelected(true);
                        } else {
                            this.duplex.setSelected(true);
                        }
                    } else if (defaultValue.equals(Sides.TWO_SIDED_SHORT_EDGE)) {
                        this.calendar.setSelected(true);
                    } else if (defaultValue.equals(Sides.ONE_SIDED)) {
                        this.oneside.setSelected(true);
                    } else {
                        this.duplex.setSelected(true);
                    }
                } else {
                    this.oneside.setEnabled(false);
                    this.calendar.setEnabled(false);
                    this.duplex.setEnabled(false);
                }
            }
        }
    }

    final class GeneralPanel
    extends JPanel {
        private PrintServices printserv_panel;
        private PrintRange printrange_panel;
        private CopiesAndSorted copies;

        public GeneralPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.printserv_panel = new PrintServices();
            this.printrange_panel = new PrintRange();
            this.copies = new CopiesAndSorted();
            JPanel layout_panel = new JPanel();
            layout_panel.setLayout(new BoxLayout(layout_panel, 2));
            layout_panel.add(this.printrange_panel);
            layout_panel.add(Box.createRigidArea(new Dimension(10, 0)));
            layout_panel.add(this.copies);
            this.setLayout(new BoxLayout(this, 3));
            this.add(this.printserv_panel);
            this.add(Box.createRigidArea(new Dimension(0, 12)));
            this.add(layout_panel);
        }

        void update() {
            this.printserv_panel.updateForSelectedService();
            this.printrange_panel.updateForSelectedService();
            this.copies.updateForSelectedService();
        }

        final class CopiesAndSorted
        extends JPanel
        implements ChangeListener,
        ActionListener {
            private JCheckBox sort;
            private JSpinner copies;
            private JLabel copies_lb = new JLabel(PrinterDialog.getLocalizedString("lb.copies"));
            private SpinnerNumberModel copiesModel;

            CopiesAndSorted() {
                this.sort = new JCheckBox(PrinterDialog.getLocalizedString("cb.sort"));
                this.sort.addActionListener(this);
                this.copiesModel = new SpinnerNumberModel(1, 1, 9999, 1);
                this.copies = new JSpinner(this.copiesModel);
                this.copies.addChangeListener(this);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                c.insets = new Insets(5, 5, 5, 5);
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.copies")));
                c.anchor = 17;
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.copies_lb, c);
                c.gridx = 1;
                c.gridy = 0;
                this.add((Component)this.copies, c);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.sort, c);
            }

            public void stateChanged(ChangeEvent event) {
                int value = (Integer)this.copies.getValue();
                PrinterDialog.this.atts.add(new Copies(value));
                if (value > 1 && PrinterDialog.this.categorySupported(SheetCollate.class)) {
                    this.sort.setEnabled(true);
                } else {
                    this.sort.setEnabled(false);
                }
            }

            public void actionPerformed(ActionEvent event) {
                if (this.sort.isSelected()) {
                    PrinterDialog.this.atts.add(SheetCollate.COLLATED);
                }
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(Copies.class)) {
                    this.copies.setEnabled(true);
                    this.copies_lb.setEnabled(true);
                    Copies copies = (Copies)PrinterDialog.this.attribute(Copies.class);
                    if (copies != null) {
                        this.copiesModel.setValue(new Integer(copies.getValue()));
                    }
                    if ((Integer)this.copiesModel.getValue() > 1 && PrinterDialog.this.categorySupported(SheetCollate.class)) {
                        this.sort.setEnabled(true);
                        Attribute collate = PrinterDialog.this.attribute(SheetCollate.class);
                        if (collate != null && collate.equals(SheetCollate.COLLATED)) {
                            this.sort.setSelected(true);
                        }
                    } else {
                        this.sort.setEnabled(false);
                    }
                } else {
                    this.copies.setEnabled(false);
                    this.copies_lb.setEnabled(false);
                }
            }
        }

        final class PrintRange
        extends JPanel
        implements ActionListener,
        FocusListener {
            private JLabel to = new JLabel(PrinterDialog.getLocalizedString("lb.to"));
            private JRadioButton all_rb;
            private JRadioButton pages_rb;
            private JTextField from_tf;
            private JTextField to_tf;

            PrintRange() {
                this.to.setEnabled(false);
                this.all_rb = new JRadioButton(PrinterDialog.getLocalizedString("rbt.all"));
                this.all_rb.setSelected(true);
                this.all_rb.setActionCommand("ALL");
                this.all_rb.addActionListener(this);
                this.pages_rb = new JRadioButton(PrinterDialog.getLocalizedString("rbt.pages"));
                this.pages_rb.setActionCommand("PAGES");
                this.pages_rb.setEnabled(false);
                this.pages_rb.addActionListener(this);
                ButtonGroup group = new ButtonGroup();
                group.add(this.all_rb);
                group.add(this.pages_rb);
                this.from_tf = new JTextField("1", 4);
                this.from_tf.setEnabled(false);
                this.from_tf.addFocusListener(this);
                this.to_tf = new JTextField("1", 4);
                this.to_tf.setEnabled(false);
                this.to_tf.addFocusListener(this);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.printrange")));
                c.insets = new Insets(15, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.all_rb, c);
                c.insets = new Insets(5, 5, 15, 5);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.pages_rb, c);
                c.gridx = 1;
                c.gridy = 1;
                this.add((Component)this.from_tf, c);
                c.gridx = 2;
                c.gridy = 1;
                this.add((Component)this.to, c);
                c.insets = new Insets(5, 5, 15, 15);
                c.gridx = 3;
                c.gridy = 1;
                this.add((Component)this.to_tf, c);
            }

            public void focusGained(FocusEvent event) {
                this.updatePageRanges();
            }

            public void focusLost(FocusEvent event) {
                this.updatePageRanges();
            }

            private void updatePageRanges() {
                int upper;
                int lower = Integer.parseInt(this.from_tf.getText());
                if (lower > (upper = Integer.parseInt(this.to_tf.getText()))) {
                    upper = lower;
                    this.to_tf.setText("" + lower);
                }
                PageRanges range = new PageRanges(lower, upper);
                PrinterDialog.this.atts.add(range);
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("ALL")) {
                    this.from_tf.setEnabled(false);
                    this.to.setEnabled(false);
                    this.to_tf.setEnabled(false);
                    PrinterDialog.this.atts.add(new PageRanges(1, Integer.MAX_VALUE));
                } else {
                    this.from_tf.setEnabled(true);
                    this.to.setEnabled(true);
                    this.to_tf.setEnabled(true);
                    this.all_rb.setSelected(false);
                }
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(PageRanges.class)) {
                    this.pages_rb.setEnabled(true);
                    PageRanges range = (PageRanges)PrinterDialog.this.attribute(PageRanges.class);
                    if (range != null) {
                        this.from_tf.setEnabled(true);
                        this.to.setEnabled(true);
                        this.to_tf.setEnabled(true);
                        this.all_rb.setSelected(false);
                        this.pages_rb.setSelected(true);
                        int[][] members = range.getMembers();
                        this.from_tf.setText("" + members[0][0]);
                        this.to_tf.setText("" + members[0][1]);
                    }
                } else {
                    this.from_tf.setEnabled(false);
                    this.to.setEnabled(false);
                    this.to_tf.setEnabled(false);
                    this.all_rb.setSelected(true);
                }
            }
        }

        final class PrintServices
        extends JPanel
        implements ActionListener {
            private JLabel name = new JLabel(PrinterDialog.getLocalizedString("lb.name"));
            private JLabel status = new JLabel(PrinterDialog.getLocalizedString("lb.status"));
            private JLabel typ = new JLabel(PrinterDialog.getLocalizedString("lb.typ"));
            private JLabel info = new JLabel(PrinterDialog.getLocalizedString("lb.info"));
            private JLabel statusValue;
            private JLabel typValue = new JLabel();
            private JLabel infoValue = new JLabel();
            private JButton attributes;
            private JComboBox services_cob;
            private JCheckBox fileRedirection_cb;

            PrintServices() {
                this.statusValue = new JLabel();
                this.attributes = new JButton(PrinterDialog.getLocalizedString("bt.attributes"));
                this.attributes.setEnabled(false);
                this.attributes.setActionCommand("ATTRIBUTES");
                this.attributes.addActionListener(this);
                this.services_cob = new JComboBox(PrinterDialog.this.getPrintServices());
                this.services_cob.setActionCommand("SERVICE");
                this.services_cob.addActionListener(this);
                this.fileRedirection_cb = new JCheckBox(PrinterDialog.getLocalizedString("cb.output"));
                this.fileRedirection_cb.setEnabled(false);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.printservice")));
                c.insets = new Insets(5, 5, 5, 5);
                c.anchor = 22;
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.name, c);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.status, c);
                c.gridx = 0;
                c.gridy = 2;
                this.add((Component)this.typ, c);
                c.gridx = 0;
                c.gridy = 3;
                this.add((Component)this.info, c);
                c.gridx = 2;
                c.gridy = 3;
                c.weightx = 1.0;
                this.add((Component)this.fileRedirection_cb, c);
                c.anchor = 21;
                c.fill = 2;
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 1.5;
                this.add((Component)this.services_cob, c);
                c.gridx = 1;
                c.gridy = 1;
                c.gridwidth = 2;
                c.weightx = 1.0;
                this.add((Component)this.statusValue, c);
                c.gridx = 1;
                c.gridy = 2;
                c.gridwidth = 2;
                c.weightx = 1.0;
                this.add((Component)this.typValue, c);
                c.gridx = 1;
                c.gridy = 3;
                c.gridwidth = 2;
                c.weightx = 1.0;
                this.add((Component)this.infoValue, c);
                c.gridx = 2;
                c.gridy = 0;
                c.weightx = 1.5;
                this.add((Component)this.attributes, c);
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("SERVICE")) {
                    PrinterDialog.this.setSelectedPrintService((PrintService)this.services_cob.getSelectedItem());
                    PrinterDialog.this.updateAll();
                } else {
                    e.getActionCommand().equals("ATTRIBUTES");
                }
            }

            void updateForSelectedService() {
                PrinterMakeAndModel att1 = PrinterDialog.this.getSelectedPrintService().getAttribute(PrinterMakeAndModel.class);
                this.typValue.setText(att1 == null ? "" : att1.getValue());
                PrinterInfo att2 = PrinterDialog.this.getSelectedPrintService().getAttribute(PrinterInfo.class);
                this.infoValue.setText(att2 == null ? "" : att2.getValue());
                PrinterIsAcceptingJobs att3 = PrinterDialog.this.getSelectedPrintService().getAttribute(PrinterIsAcceptingJobs.class);
                PrinterState att4 = PrinterDialog.this.getSelectedPrintService().getAttribute(PrinterState.class);
                String status = att4.toString();
                if (att3 == PrinterIsAcceptingJobs.ACCEPTING_JOBS) {
                    status = String.valueOf(status) + " - " + PrinterDialog.getLocalizedString("lb.acceptingjobs");
                } else if (att3 == PrinterIsAcceptingJobs.NOT_ACCEPTING_JOBS) {
                    status = String.valueOf(status) + " - " + PrinterDialog.getLocalizedString("lb.notacceptingjobs");
                }
                this.statusValue.setText(status);
                if (PrinterDialog.this.categorySupported(Destination.class)) {
                    this.fileRedirection_cb.setEnabled(false);
                }
            }
        }
    }

    final class PageSetupPanel
    extends JPanel {
        private MediaTypes media_panel;
        private Orientation orientation_panel;
        private Margins margins_panel;

        public PageSetupPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.media_panel = new MediaTypes();
            this.orientation_panel = new Orientation();
            this.margins_panel = new Margins();
            JPanel layout_panel = new JPanel();
            layout_panel.setLayout(new BoxLayout(layout_panel, 2));
            layout_panel.add(this.orientation_panel);
            layout_panel.add(Box.createRigidArea(new Dimension(10, 0)));
            layout_panel.add(this.margins_panel);
            this.setLayout(new BoxLayout(this, 3));
            this.add(this.media_panel);
            this.add(Box.createRigidArea(new Dimension(0, 12)));
            this.add(layout_panel);
        }

        void update() {
            this.media_panel.updateForSelectedService();
            this.orientation_panel.updateForSelectedService();
            this.margins_panel.updateForSelectedService();
        }

        final class Margins
        extends JPanel
        implements FocusListener {
            private JLabel left = new JLabel(PrinterDialog.getLocalizedString("lb.left"));
            private JLabel right = new JLabel(PrinterDialog.getLocalizedString("lb.right"));
            private JLabel top = new JLabel(PrinterDialog.getLocalizedString("lb.top"));
            private JLabel bottom = new JLabel(PrinterDialog.getLocalizedString("lb.bottom"));
            private JTextField left_tf = new JTextField(7);
            private JTextField right_tf;
            private JTextField top_tf;
            private JTextField bottom_tf;

            Margins() {
                this.left_tf.addFocusListener(this);
                this.right_tf = new JTextField(7);
                this.right_tf.addFocusListener(this);
                this.top_tf = new JTextField(7);
                this.top_tf.addFocusListener(this);
                this.bottom_tf = new JTextField(7);
                this.bottom_tf.addFocusListener(this);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.margins")));
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.left, c);
                c.gridx = 1;
                c.gridy = 0;
                this.add((Component)this.right, c);
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.left_tf, c);
                c.gridx = 1;
                c.gridy = 1;
                this.add((Component)this.right_tf, c);
                c.insets = new Insets(10, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 2;
                this.add((Component)this.top, c);
                c.gridx = 1;
                c.gridy = 2;
                this.add((Component)this.bottom, c);
                c.insets = new Insets(0, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 3;
                this.add((Component)this.top_tf, c);
                c.gridx = 1;
                c.gridy = 3;
                this.add((Component)this.bottom_tf, c);
            }

            public void focusGained(FocusEvent event) {
                this.updateMargins();
            }

            public void focusLost(FocusEvent event) {
                this.updateMargins();
            }

            private void updateMargins() {
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(MediaPrintableArea.class)) {
                    this.left.setEnabled(true);
                    this.right.setEnabled(true);
                    this.top.setEnabled(true);
                    this.bottom.setEnabled(true);
                    this.left_tf.setEnabled(true);
                    this.right_tf.setEnabled(true);
                    this.top_tf.setEnabled(true);
                    this.bottom_tf.setEnabled(true);
                } else {
                    this.left.setEnabled(false);
                    this.right.setEnabled(false);
                    this.top.setEnabled(false);
                    this.bottom.setEnabled(false);
                    this.left_tf.setEnabled(false);
                    this.right_tf.setEnabled(false);
                    this.top_tf.setEnabled(false);
                    this.bottom_tf.setEnabled(false);
                }
            }
        }

        final class MediaTypes
        extends JPanel
        implements ActionListener {
            private JLabel size_lb = new JLabel(PrinterDialog.getLocalizedString("lb.size"));
            private JLabel source_lb = new JLabel(PrinterDialog.getLocalizedString("lb.source"));
            private JComboBox size = new JComboBox();
            private JComboBox source;

            MediaTypes() {
                this.size.setEditable(false);
                this.size.addActionListener(this);
                this.source = new JComboBox();
                this.source.setEditable(false);
                this.size.addActionListener(this);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.medias")));
                c.insets = new Insets(5, 5, 5, 5);
                c.anchor = 22;
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.size_lb, c);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.source_lb, c);
                c.anchor = 21;
                c.fill = 2;
                c.gridx = 1;
                c.gridy = 0;
                c.weightx = 1.5;
                this.add((Component)this.size, c);
                c.gridx = 1;
                c.gridy = 1;
                c.weightx = 1.5;
                this.add((Component)this.source, c);
            }

            public void actionPerformed(ActionEvent event) {
                Object obj;
                if (event.getSource() == this.size && (obj = this.size.getSelectedItem()) instanceof Media) {
                    PrinterDialog.this.atts.add((Media)obj);
                }
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(Media.class)) {
                    Media[] medias = (Media[])PrinterDialog.this.getSelectedPrintService().getSupportedAttributeValues(Media.class, PrinterDialog.this.flavor, null);
                    this.size.removeAllItems();
                    if (medias.length == 0) {
                        this.size.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                    } else {
                        int i = 0;
                        while (i < medias.length) {
                            this.size.addItem(medias[i]);
                            ++i;
                        }
                    }
                    Media media = (Media)PrinterDialog.this.attribute(Media.class);
                    if (media != null) {
                        this.size.setSelectedItem(media);
                    }
                    this.source.removeAllItems();
                    this.source.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                } else {
                    this.size.removeAllItems();
                    this.source.removeAllItems();
                    this.size.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                    this.source.addItem(PrinterDialog.getLocalizedString("lb.automatically"));
                }
            }
        }

        final class Orientation
        extends JPanel
        implements ActionListener {
            private JRadioButton portrait = new JRadioButton(PrinterDialog.getLocalizedString("rbt.portrait"));
            private JRadioButton landscape;
            private JRadioButton rev_portrait;
            private JRadioButton rev_landscape;

            Orientation() {
                this.portrait.addActionListener(this);
                this.landscape = new JRadioButton(PrinterDialog.getLocalizedString("rbt.landscape"));
                this.landscape.addActionListener(this);
                this.rev_portrait = new JRadioButton(PrinterDialog.getLocalizedString("rbt.revportrait"));
                this.rev_portrait.addActionListener(this);
                this.rev_landscape = new JRadioButton(PrinterDialog.getLocalizedString("rbt.revlandscape"));
                this.rev_landscape.addActionListener(this);
                ButtonGroup group = new ButtonGroup();
                group.add(this.portrait);
                group.add(this.landscape);
                group.add(this.rev_portrait);
                group.add(this.rev_landscape);
                GridBagLayout layout = new GridBagLayout();
                GridBagConstraints c = new GridBagConstraints();
                c.fill = 1;
                this.setLayout(layout);
                this.setBorder(new TitledBorder(PrinterDialog.getLocalizedString("title.orientation")));
                c.insets = new Insets(5, 5, 5, 5);
                c.gridx = 0;
                c.gridy = 0;
                this.add((Component)this.portrait, c);
                c.gridx = 0;
                c.gridy = 1;
                this.add((Component)this.landscape, c);
                c.gridx = 0;
                c.gridy = 2;
                this.add((Component)this.rev_portrait, c);
                c.gridx = 0;
                c.gridy = 3;
                this.add((Component)this.rev_landscape, c);
            }

            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == this.portrait) {
                    PrinterDialog.this.atts.add(OrientationRequested.PORTRAIT);
                } else if (e.getSource() == this.landscape) {
                    PrinterDialog.this.atts.add(OrientationRequested.LANDSCAPE);
                } else if (e.getSource() == this.rev_portrait) {
                    PrinterDialog.this.atts.add(OrientationRequested.REVERSE_PORTRAIT);
                } else {
                    PrinterDialog.this.atts.add(OrientationRequested.REVERSE_LANDSCAPE);
                }
            }

            void updateForSelectedService() {
                if (PrinterDialog.this.categorySupported(OrientationRequested.class)) {
                    this.portrait.setEnabled(true);
                    this.landscape.setEnabled(true);
                    this.rev_landscape.setEnabled(true);
                    this.rev_portrait.setEnabled(true);
                    Attribute orientation = PrinterDialog.this.attribute(OrientationRequested.class);
                    if (orientation != null) {
                        if (orientation.equals(OrientationRequested.LANDSCAPE)) {
                            this.landscape.setSelected(true);
                        } else if (orientation.equals(OrientationRequested.PORTRAIT)) {
                            this.portrait.setSelected(true);
                        } else if (orientation.equals(OrientationRequested.REVERSE_PORTRAIT)) {
                            this.rev_portrait.setSelected(true);
                        } else {
                            this.rev_landscape.setSelected(true);
                        }
                    } else {
                        Object defaultValue = PrinterDialog.this.defaultValue(OrientationRequested.class);
                        if (defaultValue.equals(OrientationRequested.LANDSCAPE)) {
                            this.landscape.setSelected(true);
                        } else if (defaultValue.equals(OrientationRequested.PORTRAIT)) {
                            this.portrait.setSelected(true);
                        } else if (defaultValue.equals(OrientationRequested.REVERSE_PORTRAIT)) {
                            this.rev_portrait.setSelected(true);
                        } else {
                            this.rev_landscape.setSelected(true);
                        }
                    }
                } else {
                    this.portrait.setEnabled(false);
                    this.landscape.setEnabled(false);
                    this.rev_landscape.setEnabled(false);
                    this.rev_portrait.setEnabled(false);
                }
            }
        }
    }
}

