/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGComponent;
import gnu.javax.imageio.jpeg.JPEGScan;
import javax.imageio.plugins.jpeg.JPEGHuffmanTable;

public class JPEGFrame {
    public static final byte JPEG_COLOR_GRAY = 1;
    public static final byte JPEG_COLOR_RGB = 2;
    public static final byte JPEG_COLOR_YCbCr = 3;
    public static final byte JPEG_COLOR_CMYK = 4;
    public byte precision = (byte)8;
    public byte colorMode = (byte)3;
    public byte componentCount = 0;
    public short width = 0;
    public short height = 0;
    public JPEGScan components = new JPEGScan();

    public void addComponent(byte componentID, byte sampleFactors, byte quantizationTableID) {
        byte sampleHorizontalFactor = (byte)(sampleFactors >> 4);
        byte sampleVerticalFactor = (byte)(sampleFactors & 0xF);
        this.components.addComponent(componentID, sampleHorizontalFactor, sampleVerticalFactor, quantizationTableID);
    }

    public void setPrecision(byte data) {
        this.precision = data;
    }

    public void setScanLines(short data) {
        this.height = data;
    }

    public void setSamplesPerLine(short data) {
        this.width = data;
    }

    public void setColorMode(byte data) {
        this.colorMode = data;
    }

    public void setComponentCount(byte data) {
        this.componentCount = data;
    }

    public byte getComponentCount() {
        return this.componentCount;
    }

    public void setHuffmanTables(byte componentID, JPEGHuffmanTable ACTable, JPEGHuffmanTable DCTable) {
        JPEGComponent comp = this.components.getComponentByID(componentID);
        comp.setACTable(ACTable);
        comp.setDCTable(DCTable);
    }
}

