/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ByteBufferOutputStream
extends OutputStream {
    private ByteBuffer buffer;

    public ByteBufferOutputStream() {
        this(256);
    }

    public ByteBufferOutputStream(int initialCapacity) {
        this.buffer = ByteBuffer.allocate(initialCapacity);
    }

    public synchronized void write(int b) throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.growBuffer();
        }
        this.buffer.put((byte)b);
    }

    public synchronized void write(byte[] b, int offset, int length) {
        if (this.buffer.remaining() < length) {
            this.growBuffer();
        }
        this.buffer.put(b, offset, length);
    }

    public void write(byte[] b) {
        this.write(b, 0, b.length);
    }

    public ByteBuffer buffer() {
        return ((ByteBuffer)this.buffer.duplicate().flip()).slice();
    }

    public String toString() {
        return String.valueOf(super.toString()) + " [ buffer: " + this.buffer + " ]";
    }

    private void growBuffer() {
        int newCapacity = this.buffer.capacity();
        newCapacity = newCapacity < 16384 ? (newCapacity <<= 1) : (newCapacity += 4096);
        ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
        this.buffer.flip();
        newBuffer.put(this.buffer);
        this.buffer = newBuffer;
    }
}

